/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.AssenStelsel;
import GrafischeTechnieken.AssenStelselListener;
import GrafischeTechnieken.BasisMatrix;
import GrafischeTechnieken.Canvas;
import GrafischeTechnieken.ZoomBoxHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class GrafiekCanvas
extends Canvas
implements ComponentListener,
AssenStelselListener {
    double[][] xPoints;
    double[][] yPoints;
    double knotStart;
    double knotEnd;
    double yMax;
    double yMin;
    double[] knots;
    BasicStroke dotDash;
    Rectangle2D assenStelselMark;
    protected AssenStelsel assenStelsel = new AssenStelsel();
    protected BasisMatrix matrix;
    int k;

    public GrafiekCanvas() {
        super(false);
        this.addComponentListener(this);
        ZoomBoxHandler zbl = new ZoomBoxHandler(this, this.assenStelsel);
        this.addMouseMotionListener(zbl);
        this.addMouseListener(zbl);
        float[] dash2f = new float[]{1.0f, 2.0f};
        this.dotDash = new BasicStroke(1.0f, 0, 0, 1.0f, dash2f, 1.0f);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(new Color(200, 200, 200));
        g2.fillRect(0, 0, this.mWidth, this.mHeight);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.matrix != null) {
            int pi;
            Point2D.Double p2;
            Point2D.Double p1;
            BasicStroke thickStroke = new BasicStroke(5.0f);
            for (int i = 0; i < this.knots.length; ++i) {
                p1 = this.assenStelsel.cartToScreen(this.knots[i], this.yMin, this.getWidth(), this.getHeight());
                p2 = this.assenStelsel.cartToScreen(this.knots[i], this.yMax, this.getWidth(), this.getHeight());
                g2.setColor(new Color(150, 150, 150, 70));
                g2.setStroke(thickStroke);
                g2.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
                g2.setColor(new Color(250, 250, 250));
                g2.setStroke(this.dotDash);
                g2.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
            }
            int[][] xCurve = new int[this.matrix.getSize()][this.xPoints[0].length];
            int[][] yCurve = new int[this.matrix.getSize()][this.yPoints[0].length];
            for (pi = 0; pi < this.matrix.getSize(); ++pi) {
                for (int i = 0; i < this.xPoints[0].length; ++i) {
                    Point2D.Double sP = this.assenStelsel.cartToScreen(this.xPoints[pi][i], this.yPoints[pi][i], this.getWidth(), this.getHeight());
                    xCurve[pi][i] = (int)sP.getX();
                    yCurve[pi][i] = (int)sP.getY();
                }
            }
            g2.setColor(Color.black);
            for (pi = 0; pi < this.matrix.getSize(); ++pi) {
                g2.setColor(new Color(255, 255, 255, 120));
                g2.setStroke(new BasicStroke(5.0f));
                g2.drawPolyline(xCurve[pi], yCurve[pi], xCurve[0].length);
                g2.setStroke(new BasicStroke(1.0f));
                g2.setColor(Color.getHSBColor((float)pi / (float)this.matrix.getSize(), 0.9f, 0.4f));
                g2.drawPolyline(xCurve[pi], yCurve[pi], xCurve[0].length);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.black);
            p1 = this.assenStelsel.cartToScreen(this.knots[0], this.yMin, this.getWidth(), this.getHeight());
            p2 = this.assenStelsel.cartToScreen(this.knots[0], this.yMax, this.getWidth(), this.getHeight());
            g2.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
            p1 = this.assenStelsel.cartToScreen(this.knotEnd, this.yMin, this.getWidth(), this.getHeight());
            p2 = this.assenStelsel.cartToScreen(this.knotEnd, this.yMax, this.getWidth(), this.getHeight());
            g2.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
            g2.setStroke(new BasicStroke());
            p1 = this.assenStelsel.cartToScreen(this.knotStart, 0.0, this.getWidth(), this.getHeight());
            p2 = this.assenStelsel.cartToScreen(this.knotEnd, 0.0, this.getWidth(), this.getHeight());
            g2.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
            g2.setStroke(new BasicStroke());
            for (int i = 0; i < this.knots.length; ++i) {
                Point2D.Double pKnot = this.assenStelsel.cartToScreen(this.knots[i], 0.0, this.getWidth(), this.getHeight());
                g2.setColor(Color.white);
                g2.fillOval((int)pKnot.getX() - 5, (int)pKnot.getY() - 5, 10, 10);
                g2.setColor(Color.black);
                g2.drawOval((int)pKnot.getX() - 5, (int)pKnot.getY() - 5, 10, 10);
                g2.drawLine((int)pKnot.getX(), (int)pKnot.getY(), (int)pKnot.getX(), (int)pKnot.getY());
            }
            if (this.assenStelselMark != null) {
                g2.setColor(new Color(180, 180, 180, 180));
                g2.fill(this.assenStelselMark);
                g2.setColor(new Color(255, 255, 255));
                Point m = this.assenStelselMark.getBounds().getLocation();
                m.translate((int)this.assenStelselMark.getWidth() / 2, (int)this.assenStelselMark.getHeight() / 2);
                g2.setStroke(this.dotDash);
                g2.drawLine((int)this.assenStelselMark.getX(), (int)m.getY(), (int)(this.assenStelselMark.getX() + this.assenStelselMark.getWidth()), (int)m.getY());
                g2.drawLine((int)m.getX(), (int)this.assenStelselMark.getY(), (int)m.getX(), (int)(this.assenStelselMark.getY() + this.assenStelselMark.getHeight()));
                g2.setStroke(new BasicStroke());
                g2.fillOval((int)m.getX() - 3, (int)m.getY() - 3, 7, 7);
                g2.setColor(new Color(128, 128, 128, 200));
                g2.drawOval((int)m.getX() - 3, (int)m.getY() - 3, 7, 7);
                g2.setColor(Color.darkGray);
                g2.draw(this.assenStelselMark);
            }
        }
    }

    public void recalcCurves() {
        boolean minmax = false;
        this.yMax = 0.0;
        this.yMin = 0.0;
        double density = 100.0;
        if (this.matrix != null && this.knots != null) {
            this.xPoints = new double[this.matrix.getSize()][(int)density + 1];
            this.yPoints = new double[this.matrix.getSize()][(int)density + 1];
            for (int pi = 0; pi < this.matrix.getSize(); ++pi) {
                double yf;
                double xf = this.knotStart;
                for (int i = 0; i < (int)density; ++i) {
                    yf = this.matrix.eval(pi, xf);
                    this.xPoints[pi][i] = xf;
                    this.yPoints[pi][i] = yf;
                    if (!minmax) {
                        this.yMin = this.yMax = yf;
                        minmax = true;
                    } else {
                        if (yf < this.yMin) {
                            this.yMin = yf;
                        }
                        if (yf > this.yMax) {
                            this.yMax = yf;
                        }
                    }
                    xf += (this.knotEnd - this.knotStart) / density;
                }
                xf = this.knotEnd;
                yf = this.matrix.eval(pi, xf);
                this.xPoints[pi][i] = xf;
                this.yPoints[pi][i] = yf;
            }
            this.assenStelsel.setBounds(this.knotStart - 0.1, 11.0 * this.yMin / 10.0, this.knotEnd + 0.1, 11.0 * this.yMax / 10.0);
        }
    }

    public void setInputData(BasisMatrix matrix, double[] knots) {
        this.matrix = matrix;
        if (knots.length > 0) {
            this.knotStart = knots[0];
            this.knotEnd = knots[knots.length - 1];
            this.knots = knots;
        } else {
            this.knots = null;
        }
        this.recalcCurves();
        this.repaint();
    }

    public void setInputData(BasisMatrix matrix, double[] knots, int k, int firstKnotIndex) {
        this.matrix = matrix;
        this.knotStart = knots[firstKnotIndex];
        this.knotEnd = knots[firstKnotIndex + 2 * k - 3];
        this.knots = knots;
        this.k = k;
        this.recalcCurves();
        this.repaint();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void assenStelselChanged(double xMin, double yMin, double xMax, double yMax) {
        if (xMin != xMax && yMax != yMin) {
            this.assenStelsel.setBounds(xMin, yMin, xMax, yMax);
        }
        this.assenStelselMark = null;
        this.repaint();
    }

    public void setAssenStelselMark(Rectangle2D r) {
        this.assenStelselMark = r;
        this.repaint();
    }

    public double getWidthOnScreen() {
        return this.getWidth();
    }

    public double getHeightOnScreen() {
        return this.getHeight();
    }

    public JComponent getAsComponent() {
        return this;
    }

    public void defaultView() {
        this.assenStelsel.setBounds(this.knotStart - 0.1, 11.0 * this.yMin / 10.0, this.knotEnd + 0.1, 11.0 * this.yMax / 10.0);
        this.assenStelselMark = null;
        this.repaint();
    }

    public void fitToScreen() {
        this.assenStelsel.setBounds(this.knotStart - 0.1, 11.0 * this.yMin / 10.0, this.knotEnd + 0.1, 11.0 * this.yMax / 10.0);
        this.assenStelselMark = null;
        this.repaint();
    }

    public void recenter(double x, double y) {
        this.assenStelselChanged(x + this.assenStelsel.getXMin(), y + this.assenStelsel.getYMin(), x + this.assenStelsel.getXMax(), y + this.assenStelsel.getYMax());
    }
}

