/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.BasisMatrix;
import GrafischeTechnieken.ControlePunt;
import GrafischeTechnieken.DataPunt;
import GrafischeTechnieken.GebruikersInterface;
import GrafischeTechnieken.Graad;
import GrafischeTechnieken.Knoop;
import GrafischeTechnieken.Punt;
import GrafischeTechnieken.Tree;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.ListIterator;

public class GrafischeEngine {
    protected BasisMatrix itsBasisMatrix;
    protected LinkedList itsControlePunt = new LinkedList();
    protected LinkedList itsDataPunt = new LinkedList();
    protected GebruikersInterface itsGebruikersInterface;
    protected Graad itsGraad;
    protected LinkedList itsKnoop;
    protected LinkedList itsTree;
    boolean isOpen;

    public GrafischeEngine(GebruikersInterface itsGebruikersInterface) {
        this.itsGebruikersInterface = itsGebruikersInterface;
        this.itsKnoop = new LinkedList();
        this.itsTree = new LinkedList();
    }

    public void renderBuffers() {
    }

    public void renderToTekenVenster(Graphics2D g2) {
    }

    public void renderToOutputVenster(Graphics2D g2) {
    }

    public void berekenCurve() {
    }

    public void configureerEngine() {
    }

    public void gebruikGraad() {
    }

    public void maakLeeg() {
    }

    public void veranderAfgeleide(DataPunt p) {
    }

    public void verplaatsControlePunt(int index, ControlePunt cp) {
        if (index >= 0 && index < this.itsControlePunt.size()) {
            this.itsControlePunt.set(index, cp);
        }
    }

    public void verplaatsDataPunt(int index, DataPunt dp) {
        if (index >= 0 && index < this.itsDataPunt.size()) {
            this.itsDataPunt.set(index, dp);
        }
    }

    public void verplaatsPunt(Punt p, double newX, double newY) {
        p.setX(newX);
        p.setY(newY);
    }

    public void verplaatsKnoop() {
    }

    public void voegtoeKnoop(double knoop_value) {
    }

    public void verwijderAfgeleide(DataPunt p) {
        p.setDiff1(null);
    }

    public void verwijderAfgeleide(int index) {
        if (index >= 0 && index < this.itsDataPunt.size()) {
            ((DataPunt)this.itsDataPunt.get(index)).setDiff1(null);
        }
    }

    public void verwijderTweedeAfgeleide(int index) {
        if (index >= 0 && index < this.itsDataPunt.size()) {
            ((DataPunt)this.itsDataPunt.get(index)).setDiff2(null);
        }
    }

    public void verwijderTweedeAfgeleide(DataPunt p) {
        p.setDiff2(null);
    }

    public void verplaatsAfgeleide(int index, Punt nieuwe_afgeleide) {
        if (index >= 0 && index < this.itsDataPunt.size()) {
            ((DataPunt)this.itsDataPunt.get(index)).setDiff1(nieuwe_afgeleide);
        }
    }

    public void verplaatsTweedeAfgeleide(int index, Punt nieuwe_afgeleide) {
        if (index >= 0 && index < this.itsDataPunt.size()) {
            ((DataPunt)this.itsDataPunt.get(index)).setDiff2(nieuwe_afgeleide);
        }
    }

    public void verwijderControlePunt(int index) {
        if (index >= 0 && index < this.itsControlePunt.size()) {
            this.itsControlePunt.remove(index);
        }
    }

    public void verwijderDataPunt(int index) {
        if (index >= 0 && index < this.itsDataPunt.size()) {
            this.itsDataPunt.remove(index);
        }
    }

    public void verwijderControlePunt(Punt p) {
        this.itsControlePunt.remove(p);
        this.maakUniform();
    }

    public void verwijderDataPunt(Punt p) {
        this.itsDataPunt.remove(p);
        this.maakUniform();
    }

    public void voegtoeAfgeleide(DataPunt p, Punt afgeleide) {
        p.setDiff1(afgeleide);
    }

    public void voegtoeControlePunt(ControlePunt cp) {
        this.addItsControlePunt(cp);
    }

    public void voegtoeDataPunt(DataPunt dp) {
        this.addItsDataPunt(dp);
    }

    public void voegtoeKnoopWaarde(double knoopVal) {
        Knoop k = new Knoop(knoopVal);
        this.itsKnoop.add(k);
    }

    public void maakUniform() {
        int n = this.itsDataPunt.size() + this.itsControlePunt.size();
        this.itsKnoop.clear();
        for (int i = 0; i < n; ++i) {
            this.voegtoeKnoopWaarde(i);
        }
        this.itsGebruikersInterface.getItsMenuVenster().getItsKnopenManipulatieVenster().repaint();
        this.isOpen = false;
    }

    public void maakOpenUniform() {
        this.maakUniform();
        this.isOpen = true;
    }

    public void wijzigGraad(int graad) {
        if (this.itsGraad != null && graad > 0) {
            this.itsGraad.setValue(graad);
        }
    }

    public void verwijderCurve() {
        this.itsControlePunt.clear();
        this.itsDataPunt.clear();
        this.itsKnoop.clear();
        this.itsBasisMatrix = null;
    }

    public void flushInputs() {
    }

    public void saveToFile(RandomAccessFile out) throws IOException {
        ListIterator iterD = this.itsDataPunt.listIterator(0);
        ListIterator iterC = this.itsControlePunt.listIterator(0);
        ListIterator iterK = this.itsKnoop.listIterator(0);
        out.writeInt(this.itsDataPunt.size());
        while (iterD.hasNext()) {
            DataPunt dp = (DataPunt)iterD.next();
            if (dp.getDiff2() != null) {
                out.writeInt(2);
            } else if (dp.getDiff1() != null) {
                out.writeInt(1);
            } else {
                out.writeInt(0);
            }
            out.writeDouble(dp.getX());
            out.writeDouble(dp.getY());
            if (dp.getDiff1() != null) {
                out.writeDouble(dp.getDiff1().getX());
                out.writeDouble(dp.getDiff1().getY());
            }
            if (dp.getDiff2() == null) continue;
            out.writeDouble(dp.getDiff2().getX());
            out.writeDouble(dp.getDiff2().getY());
        }
        out.writeInt(this.itsControlePunt.size());
        while (iterC.hasNext()) {
            ControlePunt cp = (ControlePunt)iterC.next();
            out.writeDouble(cp.getX());
            out.writeDouble(cp.getY());
        }
        out.writeInt(this.itsKnoop.size());
        while (iterK.hasNext()) {
            Knoop kn = (Knoop)iterK.next();
            out.writeDouble(kn.getValue());
        }
        out.writeLong(-559038737L);
    }

    public void loadFromFile(RandomAccessFile in) throws IOException {
        double y;
        double x;
        int dataPuntSize = in.readInt();
        for (int i = 0; i < dataPuntSize; ++i) {
            int nDiffs = in.readInt();
            x = in.readDouble();
            y = in.readDouble();
            DataPunt dp = new DataPunt(x, y);
            if (nDiffs > 0) {
                x = in.readDouble();
                y = in.readDouble();
                dp.setDiff1(new Punt(x, y));
            }
            if (nDiffs > 1) {
                x = in.readDouble();
                y = in.readDouble();
                dp.setDiff2(new Punt(x, y));
            }
            this.itsDataPunt.add(dp);
        }
        int controlePuntSize = in.readInt();
        for (int i = 0; i < controlePuntSize; ++i) {
            x = in.readDouble();
            y = in.readDouble();
            ControlePunt cp = new ControlePunt(x, y);
            this.itsControlePunt.add(cp);
        }
        int knoopSize = in.readInt();
        for (int i = 0; i < knoopSize; ++i) {
            double knoopVal = in.readDouble();
            this.itsKnoop.add(new Knoop(knoopVal));
        }
        this.flushInputs();
    }

    public void outputBasisMatrix() {
        if (this.itsBasisMatrix != null) {
            this.itsGebruikersInterface.getItsOutputVenster().getItsBasisMatrixVenster().setMatrix(this.itsBasisMatrix);
        }
    }

    public BasisMatrix getItsBasisMatrix() {
        return this.itsBasisMatrix;
    }

    public void __setItsBasisMatrix(BasisMatrix p_BasisMatrix) {
        this.itsBasisMatrix = p_BasisMatrix;
    }

    public void _setItsBasisMatrix(BasisMatrix p_BasisMatrix) {
        if (this.itsBasisMatrix != null) {
            this.itsBasisMatrix.__setItsGrafischeEngine(null);
        }
        this.__setItsBasisMatrix(p_BasisMatrix);
    }

    public void setItsBasisMatrix(BasisMatrix p_BasisMatrix) {
        if (p_BasisMatrix != null) {
            p_BasisMatrix._setItsGrafischeEngine(this);
        }
        this._setItsBasisMatrix(p_BasisMatrix);
    }

    public void _clearItsBasisMatrix() {
        this.itsBasisMatrix = null;
    }

    public ListIterator getItsControlePunt() {
        ListIterator iter = this.itsControlePunt.listIterator(0);
        return iter;
    }

    public void _addItsControlePunt(ControlePunt p_ControlePunt) {
        this.itsControlePunt.add(p_ControlePunt);
    }

    public void addItsControlePunt(ControlePunt p_ControlePunt) {
        if (p_ControlePunt != null) {
            p_ControlePunt._setItsGrafischeEngine(this);
        }
        this._addItsControlePunt(p_ControlePunt);
    }

    public void _removeItsControlePunt(ControlePunt p_ControlePunt) {
        this.itsControlePunt.remove(p_ControlePunt);
    }

    public void removeItsControlePunt(ControlePunt p_ControlePunt) {
        if (p_ControlePunt != null) {
            p_ControlePunt.__setItsGrafischeEngine(null);
        }
        this._removeItsControlePunt(p_ControlePunt);
    }

    public void _clearItsControlePunt() {
        this.itsControlePunt.clear();
    }

    public void clearItsControlePunt() {
        ListIterator iter = this.itsControlePunt.listIterator(0);
        while (iter.hasNext()) {
            ((ControlePunt)iter.next())._clearItsGrafischeEngine();
        }
        this._clearItsControlePunt();
    }

    public ListIterator getItsDataPunt() {
        ListIterator iter = this.itsDataPunt.listIterator(0);
        return iter;
    }

    public void _addItsDataPunt(DataPunt p_DataPunt) {
        this.itsDataPunt.add(p_DataPunt);
    }

    public void addItsDataPunt(DataPunt p_DataPunt) {
        if (p_DataPunt != null) {
            p_DataPunt._setItsGrafischeEngine(this);
        }
        this._addItsDataPunt(p_DataPunt);
    }

    public void _removeItsDataPunt(DataPunt p_DataPunt) {
        this.itsDataPunt.remove(p_DataPunt);
    }

    public void removeItsDataPunt(DataPunt p_DataPunt) {
        if (p_DataPunt != null) {
            p_DataPunt.__setItsGrafischeEngine(null);
        }
        this._removeItsDataPunt(p_DataPunt);
    }

    public void _clearItsDataPunt() {
        this.itsDataPunt.clear();
    }

    public void clearItsDataPunt() {
        ListIterator iter = this.itsDataPunt.listIterator(0);
        while (iter.hasNext()) {
            ((DataPunt)iter.next())._clearItsGrafischeEngine();
        }
        this._clearItsDataPunt();
    }

    public GebruikersInterface getItsGebruikersInterface() {
        return this.itsGebruikersInterface;
    }

    public void setItsGebruikersInterface(GebruikersInterface itsGebruikersInterface) {
        this.itsGebruikersInterface = itsGebruikersInterface;
    }

    public Graad getItsGraad() {
        return this.itsGraad;
    }

    public void __setItsGraad(Graad p_Graad) {
        this.itsGraad = p_Graad;
    }

    public void _setItsGraad(Graad p_Graad) {
        if (this.itsGraad != null) {
            this.itsGraad.__setItsGrafischeEngine(null);
        }
        this.__setItsGraad(p_Graad);
    }

    public void setItsGraad(Graad p_Graad) {
        if (p_Graad != null) {
            p_Graad._setItsGrafischeEngine(this);
        }
        this._setItsGraad(p_Graad);
    }

    public void _clearItsGraad() {
        this.itsGraad = null;
    }

    public ListIterator getItsKnoop() {
        ListIterator iter = this.itsKnoop.listIterator(0);
        return iter;
    }

    public void setItsKnoop(LinkedList itsKnoop) {
        this.itsKnoop = itsKnoop;
    }

    public void _addItsKnoop(Knoop p_Knoop) {
        this.itsKnoop.add(p_Knoop);
    }

    public void addItsKnoop(Knoop p_Knoop) {
        if (p_Knoop != null) {
            p_Knoop._setItsGrafischeEngine(this);
        }
        this._addItsKnoop(p_Knoop);
    }

    public void _removeItsKnoop(Knoop p_Knoop) {
        this.itsKnoop.remove(p_Knoop);
    }

    public void removeItsKnoop(Knoop p_Knoop) {
        if (p_Knoop != null) {
            p_Knoop.__setItsGrafischeEngine(null);
        }
        this._removeItsKnoop(p_Knoop);
    }

    public void _clearItsKnoop() {
        this.itsKnoop.clear();
    }

    public void clearItsKnoop() {
        ListIterator iter = this.itsKnoop.listIterator(0);
        while (iter.hasNext()) {
            ((Knoop)iter.next())._clearItsGrafischeEngine();
        }
        this._clearItsKnoop();
    }

    public ListIterator getItsTree() {
        ListIterator iter = this.itsTree.listIterator(0);
        return iter;
    }

    public void _addItsTree(Tree p_Tree) {
        this.itsTree.add(p_Tree);
    }

    public void addItsTree(Tree p_Tree) {
        if (p_Tree != null) {
            p_Tree._setItsGrafischeEngine(this);
        }
        this._addItsTree(p_Tree);
    }

    public void _removeItsTree(Tree p_Tree) {
        this.itsTree.remove(p_Tree);
    }

    public void removeItsTree(Tree p_Tree) {
        if (p_Tree != null) {
            p_Tree.__setItsGrafischeEngine(null);
        }
        this._removeItsTree(p_Tree);
    }

    public void _clearItsTree() {
        this.itsTree.clear();
    }

    public void clearItsTree() {
        ListIterator iter = this.itsTree.listIterator(0);
        while (iter.hasNext()) {
            ((Tree)iter.next())._clearItsGrafischeEngine();
        }
        this._clearItsTree();
    }
}

