/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.Canvas;
import GrafischeTechnieken.Knoop;
import GrafischeTechnieken.PuntenVenster;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.ListIterator;

public class KnopenManipulatieVenster
extends Canvas
implements ComponentListener,
MouseMotionListener,
MouseListener {
    protected LinkedList itsKnoop;
    protected PuntenVenster itsPuntenVenster;
    private static final Font miniFont = new Font("Monospaced", 0, 10);
    private static final Font fatFont = new Font("Monospaced", 0, 12);
    private static Stroke dashedLine;
    private static Stroke dottedLine;
    int knotDragged;

    public KnopenManipulatieVenster() {
        super(false);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        float[] dashf = new float[]{4.0f, 2.0f};
        dashedLine = new BasicStroke(1.0f, 0, 0, 1.0f, dashf, 0.0f);
        float[] dashf2 = new float[]{1.0f, 2.0f};
        dottedLine = new BasicStroke(1.0f, 0, 0, 1.0f, dashf2, 0.0f);
        this.knotDragged = -1;
        this.itsKnoop = new LinkedList();
    }

    public void drawGrid() {
        super.redrawGrid();
        this.gridBufG.setColor(Color.darkGray);
        this.gridBufG.setStroke(dottedLine);
        if (this.itsKnoop.size() > 0) {
            double scale = (double)(this.mWidth - 60) / (double)(this.itsKnoop.size() - 1);
            this.gridBufG.setColor(new Color(150, 150, 150));
            double id = 0.0;
            while (id * scale < (double)(this.mWidth - 60)) {
                this.gridBufG.drawLine((int)(id * scale) + 30, this.mHeight, (int)(id * scale) + 30, 0);
                id += 0.25;
            }
            this.gridBufG.setColor(Color.darkGray);
            for (int i = 0; i < this.itsKnoop.size(); ++i) {
                this.gridBufG.drawLine((int)((double)i * scale) + 30, this.mHeight, (int)((double)i * scale) + 30, 0);
            }
        }
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.gridBuf, 0, 0, this.mWidth, this.mHeight, this);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.itsKnoop.size() > 0) {
            g2.setColor(Color.darkGray);
            g2.setStroke(dashedLine);
            g2.drawLine(10, this.mHeight / 2, this.mWidth - 10, this.mHeight / 2);
            g2.setStroke(new BasicStroke());
            this.drawKnots(g2);
        }
    }

    public void drawKnots(Graphics2D g) {
        ListIterator iter = this.getItsKnoop();
        int i = 0;
        double last = ((Knoop)this.itsKnoop.getLast()).getValue();
        double scale = (double)(this.mWidth - 60) / last;
        String vector = "";
        while (iter.hasNext()) {
            Knoop k = (Knoop)iter.next();
            if (i != this.knotDragged) {
                g.setColor(new Color(220, 220, 230));
                g.fillOval((int)(k.getValue() * scale) + 30 - 6, this.mHeight / 2 - 6, 12, 12);
                g.setColor(Color.darkGray);
                g.drawOval((int)(k.getValue() * scale) + 30 - 6, this.mHeight / 2 - 6, 12, 12);
                g.fillOval((int)(k.getValue() * scale) + 30 - 1, this.mHeight / 2 - 1, 3, 3);
                g.setColor(new Color(200, 200, 200));
                g.fillRect((int)(k.getValue() * scale) + 30 - 8, this.mHeight - 18, 15, 10);
                g.setColor(Color.darkGray);
                g.setFont(miniFont);
                g.drawString(i + "", (int)(k.getValue() * scale) + 30 - 3, this.mHeight - 10);
            } else {
                g.setColor(new Color(240, 200, 200, 128));
                g.fillRect((int)(k.getValue() * scale) + 30 - 6, this.mHeight / 2 - 6, 12, 12);
                g.setColor(Color.black);
                g.drawRect((int)(k.getValue() * scale) + 30 - 6, this.mHeight / 2 - 6, 12, 12);
                g.setColor(new Color(200, 200, 200));
                g.fillRect((int)(k.getValue() * scale) + 30 - 8, this.mHeight - 18, 15, 10);
                g.setColor(Color.darkGray);
                g.setFont(miniFont);
                g.drawString(i + "", (int)(k.getValue() * scale) + 30 - 3, this.mHeight - 10);
                String valString = k.getValue() + "";
                g.setColor(new Color(200, 240, 200));
                g.fillRect((int)(k.getValue() * scale) + 30 - 20, this.mHeight - 52, valString.length() * 6 + 10, 15);
                g.setColor(Color.darkGray);
                g.drawRect((int)(k.getValue() * scale) + 30 - 20, this.mHeight - 52, valString.length() * 6 + 10, 15);
                g.drawString(valString, (int)(k.getValue() * scale) + 30 - 15, this.mHeight - 40);
            }
            ++i;
        }
    }

    public void knotsChanged() {
        this.itsPuntenVenster.getItsGrafischeEngine().berekenCurve();
    }

    public void addKnoop() {
        int len = this.itsKnoop.size();
        this._addItsKnoop(new Knoop(len));
    }

    public void clearItsKnoop() {
        this.itsKnoop = new LinkedList();
    }

    public ListIterator getItsKnoop() {
        ListIterator iter = this.itsKnoop.listIterator(0);
        return iter;
    }

    public ListIterator getItsKnoopEnd() {
        return this.itsKnoop.listIterator(this.itsKnoop.lastIndexOf(this.itsKnoop.getLast()));
    }

    public void _addItsKnoop(Knoop p_Knoop) {
        this.itsKnoop.add(p_Knoop);
        this.drawGrid();
        this.repaint();
    }

    public void setItsKnoop(LinkedList itsKnoop) {
        this.itsKnoop = itsKnoop;
        if (itsKnoop.size() > 0) {
            this.drawGrid();
        }
        this.repaint();
    }

    public Knoop newItsKnoop() {
        Knoop newKnoop = new Knoop();
        newKnoop._setItsKnopenManipulatieVenster(this);
        this.itsKnoop.add(newKnoop);
        return newKnoop;
    }

    public void _removeItsKnoop(Knoop p_Knoop) {
        this.itsKnoop.remove(p_Knoop);
    }

    public void deleteItsKnoop(Knoop p_Knoop) {
        p_Knoop._setItsKnopenManipulatieVenster(null);
        this.itsKnoop.remove(p_Knoop);
        p_Knoop = null;
    }

    public PuntenVenster getItsPuntenVenster() {
        return this.itsPuntenVenster;
    }

    public void __setItsPuntenVenster(PuntenVenster p_PuntenVenster) {
        this.itsPuntenVenster = p_PuntenVenster;
    }

    public void _setItsPuntenVenster(PuntenVenster p_PuntenVenster) {
        if (this.itsPuntenVenster != null) {
            this.itsPuntenVenster.__setItsKnopenManipulatieVenster(null);
        }
        this.__setItsPuntenVenster(p_PuntenVenster);
    }

    public void setItsPuntenVenster(PuntenVenster p_PuntenVenster) {
        if (p_PuntenVenster != null) {
            p_PuntenVenster._setItsKnopenManipulatieVenster(this);
        }
        this._setItsPuntenVenster(p_PuntenVenster);
    }

    public void _clearItsPuntenVenster() {
        this.itsPuntenVenster = null;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.redrawGrid();
        this.drawGrid();
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        ListIterator iter = this.getItsKnoop();
        if (iter.hasNext()) {
            iter.next();
        }
        if (this.itsKnoop.size() > 0) {
            double last = ((Knoop)this.itsKnoop.getLast()).getValue();
            double scale = (double)(this.mWidth - 60) / last;
            for (int i = 1; i < this.itsKnoop.size() - 1; ++i) {
                Knoop k = (Knoop)iter.next();
                Point kp = new Point((int)(k.getValue() * scale) + 30, this.mHeight / 2);
                Point p = e.getPoint();
                if (!(p.distance(kp) < 12.0)) continue;
                this.knotDragged = i;
                this.repaint();
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.knotDragged > 0) {
            double last = ((Knoop)this.itsKnoop.getLast()).getValue();
            double scale = (double)(this.mWidth - 60) / last;
            Knoop k = (Knoop)this.itsKnoop.get(this.knotDragged);
            Knoop nk = (Knoop)this.itsKnoop.get(this.knotDragged + 1);
            Knoop pk = (Knoop)this.itsKnoop.get(this.knotDragged - 1);
            if ((double)(e.getX() - 30) / scale > pk.getValue() && (double)(e.getX() - 30) / scale < nk.getValue()) {
                k.setValue((double)(e.getX() - 30) / scale);
                this.knotsChanged();
                this.itsPuntenVenster.getItsTekenVenster().repaint();
                this.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.knotDragged > 0) {
            this.knotDragged = -1;
            this.repaint();
        }
    }
}

