/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.BasisMatrix;
import GrafischeTechnieken.DataPunt;
import GrafischeTechnieken.GTPolynomial;
import GrafischeTechnieken.GebruikersInterface;
import GrafischeTechnieken.Graad;
import GrafischeTechnieken.GraadManipulatieVenster;
import GrafischeTechnieken.GrafischeEngine;
import GrafischeTechnieken.Knoop;
import GrafischeTechnieken.KnopenManipulatieVenster;
import GrafischeTechnieken.Kromme;
import GrafischeTechnieken.NevilleTree;
import GrafischeTechnieken.OutputVenster;
import GrafischeTechnieken.Punt;
import GrafischeTechnieken.TekenVenster;
import java.util.LinkedList;
import java.util.ListIterator;

public class Neville
extends GrafischeEngine {
    NevilleTree itsRenderTree;
    private Kromme curve;

    public Neville(GebruikersInterface gui) {
        super(gui);
    }

    public void berekenCurve() {
        double[] knots = new double[this.itsKnoop.size()];
        double density = 0.0;
        if (this.itsDataPunt.size() >= 2) {
            knots = this.getKnotsAsDoubles();
            int[] index = this.getRootLabel();
            DataPunt[] points = new DataPunt[this.itsDataPunt.size()];
            Object[] pobj = this.itsDataPunt.toArray();
            for (int i = 0; i < pobj.length; ++i) {
                points[i] = (DataPunt)pobj[i];
            }
            this.itsRenderTree = new NevilleTree(index, 0, index.length - 1, points, 0, null);
            density = (double)index.length * 25.0;
            this.itsRenderTree.initFlags(true);
            this.calcBasisMatrix(knots);
            this.calcCurveDown(density, knots);
        }
        this.outputBasisMatrix();
        this.outputPolynomes(knots);
        this.outputToTekenVenster();
        this.outputCurve();
    }

    private double[] getKnotsAsDoubles() {
        ListIterator knoopIter = this.itsKnoop.listIterator(0);
        double[] knots = new double[this.itsKnoop.size()];
        for (int i = 0; i < knots.length; ++i) {
            Knoop knoop = (Knoop)knoopIter.next();
            knots[i] = knoop.getValue() / ((double)knots.length - 1.0);
        }
        return knots;
    }

    private int[] getRootLabel() {
        ListIterator iterD = this.getItsDataPunt();
        int indexlength = 0;
        while (iterD.hasNext()) {
            DataPunt dp = (DataPunt)iterD.next();
            if (dp.getDiff2() != null) {
                indexlength += 2;
            } else if (dp.getDiff1() != null) {
                ++indexlength;
            }
            ++indexlength;
        }
        int[] index = new int[indexlength];
        iterD = this.getItsDataPunt();
        int i = 0;
        int j = 0;
        while (iterD.hasNext()) {
            DataPunt dp = (DataPunt)iterD.next();
            if (dp.getDiff2() != null) {
                index[i++] = j;
                index[i++] = j;
            } else if (dp.getDiff1() != null) {
                index[i++] = j;
            }
            index[i++] = j++;
        }
        return index;
    }

    public void calcBasisMatrix(double[] knots) {
        this.itsRenderTree.setPolynomial(new GTPolynomial(1.0));
        LinkedList leafList = new LinkedList();
        this.itsBasisMatrix = new BasisMatrix();
        this.itsRenderTree.getLeafs(leafList);
        for (int i = 0; i < leafList.size(); ++i) {
            NevilleTree nTree = (NevilleTree)leafList.get(i);
            this.itsBasisMatrix.addCol(((NevilleTree)leafList.get(i)).calcPolynomial(knots));
        }
    }

    public void calcCurveUp(double density, double[] knots) {
        double[] xCurve = new double[(int)density + 1];
        double[] yCurve = new double[(int)density + 1];
        int len = knots.length;
        double id = 0.0;
        for (int i = 0; i < (int)density; ++i) {
            this.itsRenderTree.initFlags(true);
            double[] cPoint = this.itsRenderTree.calc(id, knots);
            xCurve[i] = cPoint[0];
            yCurve[i] = cPoint[1];
            id += knots[len - 1] / density;
        }
        DataPunt lP = (DataPunt)this.itsDataPunt.getLast();
        xCurve[i] = lP.getX();
        yCurve[i] = lP.getY();
        this.curve = new Kromme(xCurve, yCurve);
    }

    public void calcCurveDown(double density, double[] knots) {
        int i = 0;
        int curPoint = 0;
        double[] xCurve = new double[(int)density + 1];
        double[] yCurve = new double[(int)density + 1];
        LinkedList<Punt> allPoints = new LinkedList<Punt>();
        ListIterator iterD = this.getItsDataPunt();
        int graad = this.itsDataPunt.size();
        while (iterD.hasNext()) {
            DataPunt dp = (DataPunt)iterD.next();
            if (dp.getDiff2() != null) {
                allPoints.add(dp.getDiff2().scalar((double)graad * (double)graad));
            }
            if (dp.getDiff1() != null) {
                allPoints.add(dp.getDiff1().scalar(graad));
            }
            allPoints.add(dp);
        }
        double id = 0.0;
        while (i < (int)density) {
            curPoint = 0;
            iterD = allPoints.listIterator(0);
            xCurve[i] = 0.0;
            yCurve[i] = 0.0;
            while (iterD.hasNext()) {
                double factor = this.itsBasisMatrix.eval(curPoint, id);
                Punt dp = (Punt)iterD.next();
                int n = i;
                xCurve[n] = xCurve[n] + factor * dp.getX();
                int n2 = i;
                yCurve[n2] = yCurve[n2] + factor * dp.getY();
                ++curPoint;
            }
            id += knots[knots.length - 1] / density;
            ++i;
        }
        Punt lP = (Punt)this.itsDataPunt.getLast();
        xCurve[i] = lP.getX();
        yCurve[i] = lP.getY();
        this.curve = new Kromme(xCurve, yCurve);
    }

    public void outputPolynomes(double[] knots) {
        if (this.itsBasisMatrix != null) {
            this.itsGebruikersInterface.getItsOutputVenster().getItsGrafiekVenster().setInputData(this.itsBasisMatrix, knots);
        }
    }

    public void outputToTekenVenster() {
        this.itsGebruikersInterface.getItsMenuVenster().getItsTekenVenster().setItsKromme(this.curve);
    }

    public void outputCurve() {
        this.itsGebruikersInterface.getItsOutputVenster().setItsKromme(this.curve);
    }

    public void configureerEngine() {
    }

    public void flushInputs() {
        this.itsGebruikersInterface.getItsOutputVenster().setItsKromme(this.curve);
        TekenVenster tekenVenster = this.itsGebruikersInterface.getItsMenuVenster().getItsTekenVenster();
        KnopenManipulatieVenster knopenVenster = this.itsGebruikersInterface.getItsMenuVenster().getItsKnopenManipulatieVenster();
        OutputVenster outputVenster = this.itsGebruikersInterface.getItsOutputVenster();
        GraadManipulatieVenster graadVenster = this.itsGebruikersInterface.getItsMenuVenster().getItsGraadManipulatieVenster();
        this.itsGebruikersInterface.getItsMenuVenster().setBigTitle("Lagrange");
        tekenVenster.setItsDataPunt(this.itsDataPunt);
        tekenVenster.setItsControlePunt(this.itsControlePunt);
        tekenVenster.setItsKromme(this.curve);
        knopenVenster.setItsKnoop(this.itsKnoop);
        outputVenster.setItsKromme(this.curve);
        graadVenster.setItsGraad(new Graad());
        this.itsGebruikersInterface.getItsOutputVenster().getItsGrafiekVenster().setBigTitle("Lagrange");
    }

    public void verwijderDataPunt(Punt p) {
        this.itsDataPunt.remove(p);
        this.maakUniform();
    }

    public void verwijderCurve() {
        super.verwijderCurve();
        this.curve = null;
        this.flushInputs();
    }

    public void voegtoeKnoop(double knoop_value) {
        this.berekenCurve();
        double[] knots = this.getKnotsAsDoubles();
        for (int l = 0; l < this.itsKnoop.size(); ++l) {
            if (((Knoop)this.itsKnoop.get(l)).getValue() != knoop_value) continue;
            return;
        }
        int i = 0;
        for (i = 0; i < this.itsKnoop.size() - 1; ++i) {
            Knoop thisK = (Knoop)this.itsKnoop.get(i);
            Knoop nextK = (Knoop)this.itsKnoop.get(i + 1);
            if (thisK.getValue() < knoop_value && knoop_value < nextK.getValue()) break;
        }
        if (knoop_value < ((Knoop)this.itsKnoop.getFirst()).getValue()) {
            i = -1;
        }
        this.itsKnoop.add(i + 1, new Knoop(knoop_value));
        this.itsRenderTree.initFlags(true);
        double[] cPoint = this.itsRenderTree.calc(knoop_value / (double)this.itsKnoop.size(), knots);
        this.itsDataPunt.add(i + 1, new DataPunt(cPoint[0], cPoint[1]));
        this.itsGebruikersInterface.getItsMenuVenster().getItsKnopenManipulatieVenster().repaint();
    }
}

