/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.DataPunt;
import GrafischeTechnieken.MouseEventHandler;
import GrafischeTechnieken.Punt;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class NevilleMouseEventHandler
extends MouseEventHandler
implements ActionListener {
    JPopupMenu addMenu;
    JPopupMenu moveMenu = new JPopupMenu();
    JPopupMenu removeMenu;
    JRadioButtonMenuItem movePoint = new JRadioButtonMenuItem("verplaats punt");
    JRadioButtonMenuItem moveDiff = new JRadioButtonMenuItem("verplaats afgeleide");
    JRadioButtonMenuItem moveDiff2 = new JRadioButtonMenuItem("verplaats tweede afgeleide");

    public NevilleMouseEventHandler() {
        this.moveMenu.add(this.movePoint);
        this.moveMenu.add(this.moveDiff);
        this.moveMenu.add(this.moveDiff2);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.movePoint);
        bGroup.add(this.moveDiff);
        bGroup.add(this.moveDiff2);
        this.movePoint.setSelected(true);
        this.movePoint.addActionListener(this);
        this.moveDiff.addActionListener(this);
        this.moveDiff2.addActionListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.lastScreenPoint = e.getPoint();
        if (this.itsPuntenVenster != null) {
            int cursorMode = this.itsPuntenVenster.getItsToolPane().getMode();
            switch (cursorMode) {
                case 0: {
                    this.itsPuntenVenster.getItsTekenVenster().addScreenDataPunt(e.getPoint());
                    this.itsPuntenVenster.getItsKnopenManipulatieVenster().addKnoop();
                    this.itsPuntenVenster.onConfiguratieChange();
                    break;
                }
                case 1: {
                    this.itsPuntenVenster.getItsTekenVenster().removeDataPunt(this.itsPuntenVenster.getItsTekenVenster().getSelectedPoint());
                    break;
                }
                case 2: {
                    Punt p = this.itsPuntenVenster.getItsTekenVenster().getSelectedPoint();
                    if (p == null) break;
                    this.moveMenu.show(this.itsPuntenVenster, e.getX(), e.getY());
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.itsPuntenVenster != null) {
            int cursorMode = this.itsPuntenVenster.getItsToolPane().getMode();
            switch (cursorMode) {
                case 0: {
                    this.itsPuntenVenster.getItsTekenVenster().setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    this.itsPuntenVenster.getItsTekenVenster().setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.itsPuntenVenster.getItsTekenVenster().setCursor(Cursor.getPredefinedCursor(13));
                    break;
                }
                case 3: {
                    this.itsPuntenVenster.getItsTekenVenster().setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 4: {
                    this.itsPuntenVenster.getItsTekenVenster().setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        this.itsPuntenVenster.getItsTekenVenster().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        boolean closePoint = false;
        if (this.itsPuntenVenster != null) {
            Point2D.Double sp = this.itsPuntenVenster.getItsTekenVenster().getItsAssenStelsel().screenToCart(e.getX(), e.getY(), this.itsPuntenVenster.getItsTekenVenster().getWidth(), this.itsPuntenVenster.getItsTekenVenster().getHeight());
            String xString = "(" + (double)((int)(100.0 * sp.getX())) / 100.0;
            String yString = (double)((int)(100.0 * sp.getY())) / 100.0 + ")";
            this.itsPuntenVenster.setSubTitle(xString + "," + yString, 140);
            ListIterator iterD = this.itsPuntenVenster.getItsTekenVenster().getItsDataPunt();
            while (iterD.hasNext()) {
                Punt p = (Punt)iterD.next();
                sp = this.itsPuntenVenster.getItsTekenVenster().getItsAssenStelsel().cartToScreen(p.getX(), p.getY(), this.itsPuntenVenster.getItsTekenVenster().getWidth(), this.itsPuntenVenster.getItsTekenVenster().getHeight());
                if (!(sp.distance(e.getPoint()) < 15.0)) continue;
                if (this.itsPuntenVenster.getItsTekenVenster().getSelectedPoint() != p) {
                    this.itsPuntenVenster.getItsTekenVenster().setSelectedPoint(p);
                }
                closePoint = true;
            }
            if (!closePoint) {
                this.itsPuntenVenster.getItsTekenVenster().setSelectedPoint(null);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.itsPuntenVenster != null) {
            int cursorMode = this.itsPuntenVenster.getItsToolPane().getMode();
            switch (cursorMode) {
                case 0: {
                    if (this.lastScreenPoint != null && e.getPoint().distance(this.lastScreenPoint) < 15.0) {
                        return;
                    }
                    DataPunt dp = this.itsPuntenVenster.getItsTekenVenster().getActiveDataPunt();
                    if (dp == null) break;
                    this.itsPuntenVenster.getItsTekenVenster().setScreenDiff1(e.getPoint(), dp);
                    this.itsPuntenVenster.onConfiguratieChange();
                    this.itsPuntenVenster.getItsTekenVenster().repaint();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    Punt p = this.itsPuntenVenster.getItsTekenVenster().getSelectedPoint();
                    if (p == null) break;
                    Point2D.Double sp = this.itsPuntenVenster.getItsTekenVenster().getItsAssenStelsel().screenToCart(e.getX(), e.getY(), this.itsPuntenVenster.getItsTekenVenster().getWidth(), this.itsPuntenVenster.getItsTekenVenster().getHeight());
                    if (this.movePoint.isSelected()) {
                        this.itsPuntenVenster.getItsTekenVenster().changePunt(p, sp.getX(), sp.getY());
                        break;
                    }
                    if (this.moveDiff.isSelected()) {
                        this.itsPuntenVenster.getItsTekenVenster().setScreenDiff1(p, e.getPoint());
                        this.itsPuntenVenster.onConfiguratieChange();
                        break;
                    }
                    if (!this.moveDiff2.isSelected()) break;
                    this.itsPuntenVenster.getItsTekenVenster().setScreenDiff2(p, e.getPoint());
                    this.itsPuntenVenster.onConfiguratieChange();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }
}

