/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.DataPunt;
import GrafischeTechnieken.GTPolynomial;
import GrafischeTechnieken.Punt;
import GrafischeTechnieken.Tree;
import java.util.LinkedList;

public class NevilleTree
extends Tree {
    double X;
    double Y;
    int[] index;
    int p;
    int y;
    DataPunt[] points;
    GTPolynomial poly;
    int depth;
    boolean flag;
    boolean dFlag;
    boolean diff;
    NevilleTree lChild;
    NevilleTree rChild;
    NevilleTree lParent;
    NevilleTree rParent;
    NevilleTree dParent;

    public NevilleTree() {
    }

    public NevilleTree(int[] index, int p, int y, DataPunt[] points, int parentParity, NevilleTree parent) {
        this.flag = false;
        this.diff = false;
        this.index = index;
        this.p = p;
        this.y = y;
        this.points = points;
        this.poly = new GTPolynomial();
        if (parent != null) {
            if (parentParity == 0) {
                this.lParent = parent;
            } else {
                this.rParent = parent;
            }
        }
        if (this.lParent != null && this.lParent.lChild != null && this.lParent.lChild.rChild != null) {
            this.lChild = this.lParent.lChild.rChild;
        }
        if (this.rParent != null && this.rParent.rChild != null && this.rParent.rChild.lChild != null) {
            this.rChild = this.rParent.rChild.lChild;
        }
        if (index[y] == index[p]) {
            if (y - p == 2) {
                this.lChild = new NevilleTree(index, p, points[index[p]].getDiff2());
                this.lChild.rParent = this;
                this.lChild.diff = true;
                if (this.lParent != null && this.lParent.lChild != null && this.lParent.lChild.rChild != null) {
                    this.rChild = this.lParent.lChild.rChild;
                    this.rChild.dParent = this;
                } else {
                    this.rChild = points[index[p]].getDiff1() != null ? new NevilleTree(index, p + 1, y, points, 0, null) : new NevilleTree(index, p + 2, y, points, 0, this);
                }
                this.rChild.dParent = this;
            } else if (y - p == 1) {
                this.lChild = new NevilleTree(index, p, points[index[p]].getDiff1());
                this.lChild.rParent = this;
                this.lChild.diff = true;
                if (this.lParent != null && this.lParent.lChild != null && this.lParent.lChild.rChild != null) {
                    this.rChild = this.lParent.lChild.rChild;
                    this.rChild.dParent = this;
                } else {
                    this.rChild = new NevilleTree(index, p + 1, y, points, 0, null);
                    this.rChild.dParent = this;
                }
            }
            if (y - p == 0) {
                this.flag = true;
                this.X = points[index[p]].getX();
                this.Y = points[index[p]].getY();
            }
        } else {
            if (this.lChild == null) {
                this.lChild = new NevilleTree(index, p, y - 1, points, 1, this);
            }
            this.lChild.rParent = this;
            if (this.rChild == null) {
                this.rChild = new NevilleTree(index, p + 1, y, points, 0, this);
            }
            this.rChild.lParent = this;
        }
    }

    public NevilleTree(int[] index, int y, Punt p) {
        this.X = p.getX();
        this.Y = p.getY();
        this.y = this.p = y;
        this.index = index;
        this.poly = new GTPolynomial();
        this.flag = true;
    }

    public void initFlags(boolean flag) {
        this.flag = false;
        this.dFlag = false;
        if (this.lChild != null) {
            this.lChild.initFlags(flag);
        }
        if (this.rChild != null) {
            this.rChild.initFlags(flag);
        }
        if (this.y == this.p) {
            this.flag = flag;
            this.dFlag = false;
        }
    }

    public GTPolynomial getPolynomial() {
        return this.poly;
    }

    public void setPolynomial(GTPolynomial poly) {
        this.poly = poly;
        this.flag = true;
    }

    public void getLeafs(LinkedList l) {
        if (this.lChild != null) {
            this.lChild.getLeafs(l);
        } else if (!l.contains(this)) {
            l.add(this);
        }
        if (this.rChild != null) {
            if (this.rChild.dParent == this || this.rChild.dParent == null) {
                this.rChild.getLeafs(l);
            }
        } else if (!l.contains(this)) {
            l.add(this);
        }
    }

    public GTPolynomial calcPolynomial(double[] knots) {
        double rtp;
        double rty;
        double ltp;
        double lty;
        if (this.lParent == null && this.rParent == null) {
            return this.poly;
        }
        if (this.dFlag) {
            return this.poly;
        }
        GTPolynomial lPoly = new GTPolynomial();
        GTPolynomial rPoly = new GTPolynomial();
        if (this.lParent != null) {
            lty = knots[this.index[this.lParent.y]];
            ltp = knots[this.index[this.lParent.p]];
        } else {
            lty = 0.0;
            ltp = 1.0;
        }
        if (this.rParent != null) {
            rty = knots[this.index[this.rParent.y]];
            rtp = knots[this.index[this.rParent.p]];
        } else {
            rty = 0.0;
            rtp = 1.0;
        }
        lPoly.add(-ltp / (lty - ltp));
        lPoly.add(1.0 / (lty - ltp));
        if (this.diff) {
            if (this.rParent.y - this.rParent.p == 1) {
                rPoly.add(-rty);
                rPoly.add(1.0);
            } else if (this.rParent.y - this.rParent.p == 2) {
                rPoly.add(rty * rty / 2.0);
                rPoly.add(-rty);
                rPoly.add(0.5);
            }
        } else {
            rPoly.add(rty / (rty - rtp));
            rPoly.add(-1.0 / (rty - rtp));
        }
        lPoly = this.lParent != null ? this.lParent.calcPolynomial(knots).multiply(lPoly) : new GTPolynomial(0.0);
        rPoly = this.rParent != null ? this.rParent.calcPolynomial(knots).multiply(rPoly) : new GTPolynomial(0.0);
        if (this.dParent != null) {
            lPoly = lPoly.sum(this.dParent.calcPolynomial(knots));
        }
        this.poly = lPoly.sum(rPoly);
        this.dFlag = true;
        return this.poly;
    }

    public double[] calc(double u, double[] knots) {
        if (this.flag) {
            double[] pair = new double[]{this.X, this.Y};
            return pair;
        }
        String indexString = "";
        for (int i = this.p; i <= this.y; ++i) {
            indexString = indexString + this.index[i];
        }
        double[] lP = this.lChild.calc(u, knots);
        double[] rP = this.rChild.calc(u, knots);
        double[] pair = new double[2];
        double ty = knots[this.index[this.y]];
        double tp = knots[this.index[this.p]];
        if (this.index[this.y] != this.index[this.p]) {
            for (int i = 0; i < 2; ++i) {
                pair[i] = lP[i] * (ty - u) / (ty - tp) + rP[i] * (u - tp) / (ty - tp);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                pair[i] = rP[i] + Math.pow(this.points.length, this.y - this.p) * lP[i] * Math.pow(u - tp, this.y - this.p) / (double)(this.y - this.p);
            }
        }
        this.X = pair[0];
        this.Y = pair[1];
        this.flag = true;
        return pair;
    }
}

