/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.AssenStelsel;
import GrafischeTechnieken.AssenStelselListener;
import GrafischeTechnieken.Canvas;
import GrafischeTechnieken.GebruikersInterface;
import GrafischeTechnieken.Kromme;
import GrafischeTechnieken.ZoomBoxHandler;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.EtchedBorder;

public class OutputCanvas
extends Canvas
implements ComponentListener,
AssenStelselListener {
    Kromme itsKromme;
    Kromme[] itsSplines;
    boolean isSplines;
    GebruikersInterface itsGebruikersInterface;
    AssenStelsel itsAssenStelsel = new AssenStelsel();
    BufferedImage curveBuffer;
    static Stroke dotDash;
    Rectangle2D assenStelselMark;

    public OutputCanvas(GebruikersInterface GUI) {
        super(true);
        float[] dash2f = new float[]{1.0f, 3.0f};
        dotDash = new BasicStroke(1.0f, 0, 2, 1.0f, dash2f, 1.0f);
        ZoomBoxHandler zbl = new ZoomBoxHandler(this, this.itsAssenStelsel);
        this.addMouseMotionListener(zbl);
        this.addMouseListener(zbl);
        this.itsGebruikersInterface = GUI;
        this.setBorder(new EtchedBorder());
        this.addComponentListener(this);
    }

    public void paintComponent(Graphics G) {
        G.drawImage(this.curveBuffer, 0, 0, this);
        Graphics2D g2 = (Graphics2D)G;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.assenStelselMark != null) {
            g2.setColor(new Color(180, 180, 180, 180));
            g2.fill(this.assenStelselMark);
            g2.setColor(new Color(255, 255, 255));
            Point m = this.assenStelselMark.getBounds().getLocation();
            m.translate((int)this.assenStelselMark.getWidth() / 2, (int)this.assenStelselMark.getHeight() / 2);
            g2.setStroke(dotDash);
            g2.drawLine((int)this.assenStelselMark.getX(), (int)m.getY(), (int)(this.assenStelselMark.getX() + this.assenStelselMark.getWidth()), (int)m.getY());
            g2.drawLine((int)m.getX(), (int)this.assenStelselMark.getY(), (int)m.getX(), (int)(this.assenStelselMark.getY() + this.assenStelselMark.getHeight()));
            g2.setStroke(new BasicStroke());
            g2.fillOval((int)m.getX() - 3, (int)m.getY() - 3, 7, 7);
            g2.setColor(new Color(128, 128, 128, 200));
            g2.drawOval((int)m.getX() - 3, (int)m.getY() - 3, 7, 7);
            g2.setColor(Color.darkGray);
            g2.draw(this.assenStelselMark);
        }
    }

    public void paintKromme(Graphics2D G) {
        G.setComposite(AlphaComposite.getInstance(3));
        G.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G.setColor(new Color(230, 230, 230));
        G.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.itsKromme == null) {
            return;
        }
        double[] xItsKromme = this.itsKromme.getXCurve();
        double[] yItsKromme = this.itsKromme.getYCurve();
        int[] sItsKrommeX = new int[xItsKromme.length];
        int[] sItsKrommeY = new int[yItsKromme.length];
        Rectangle rect = G.getClipBounds();
        int bufW = this.getWidth();
        int bufH = this.getHeight();
        for (int i = 0; i < xItsKromme.length; ++i) {
            Point2D.Double sP = this.itsAssenStelsel.cartToScreen(xItsKromme[i], yItsKromme[i], bufW, bufH);
            sItsKrommeX[i] = (int)sP.getX();
            sItsKrommeY[i] = (int)sP.getY();
        }
        G.setColor(new Color(80, 50, 80));
        G.setStroke(new BasicStroke(2.0f, 0, 1));
        G.drawPolyline(sItsKrommeX, sItsKrommeY, xItsKromme.length);
    }

    public void paintSplines(Graphics2D G) {
        G.setComposite(AlphaComposite.getInstance(3));
        G.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G.setColor(new Color(230, 230, 230));
        G.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.itsSplines == null) {
            return;
        }
        for (int nSeg = 0; nSeg < this.itsSplines.length; ++nSeg) {
            double[] xItsKromme = this.itsSplines[nSeg].getXCurve();
            double[] yItsKromme = this.itsSplines[nSeg].getYCurve();
            int[] sItsKrommeX = new int[xItsKromme.length];
            int[] sItsKrommeY = new int[yItsKromme.length];
            Rectangle rect = G.getClipBounds();
            int bufW = this.getWidth();
            int bufH = this.getHeight();
            for (int i = 0; i < xItsKromme.length; ++i) {
                Point2D.Double sP = this.itsAssenStelsel.cartToScreen(xItsKromme[i], yItsKromme[i], bufW, bufH);
                sItsKrommeX[i] = (int)sP.getX();
                sItsKrommeY[i] = (int)sP.getY();
            }
            G.setColor(new Color(80, 50, 80));
            G.setStroke(new BasicStroke(2.0f, 0, 1));
            G.drawPolyline(sItsKrommeX, sItsKrommeY, xItsKromme.length);
        }
    }

    public void setItsKromme(Kromme p_Kromme) {
        this.itsKromme = p_Kromme;
        this.isSplines = false;
        if (this.curveBuffer != null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.paintKromme(this.curveBuffer.createGraphics());
            this.repaint();
        }
    }

    public void setItsSplines(Kromme[] segments) {
        this.itsSplines = segments;
        this.isSplines = true;
        if (this.curveBuffer != null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.paintSplines(this.curveBuffer.createGraphics());
            this.repaint();
        }
    }

    public Image getCurveBuffer() {
        return this.curveBuffer;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.curveBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        if (!this.isSplines) {
            this.paintKromme(this.curveBuffer.createGraphics());
        }
        if (this.isSplines) {
            this.paintSplines(this.curveBuffer.createGraphics());
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void assenStelselChanged(double xMin, double yMin, double xMax, double yMax) {
        this.itsAssenStelsel.setBounds(xMin, yMin, xMax, yMax);
        this.assenStelselMark = null;
        if (this.itsKromme != null && !this.isSplines) {
            this.paintKromme(this.curveBuffer.createGraphics());
        } else if (this.isSplines && this.itsSplines != null) {
            this.paintSplines(this.curveBuffer.createGraphics());
        }
        this.repaint();
    }

    public void setAssenStelselMark(Rectangle2D r) {
        this.assenStelselMark = r;
        this.repaint();
    }

    public double getWidthOnScreen() {
        return this.getWidth();
    }

    public double getHeightOnScreen() {
        return this.getHeight();
    }

    public JComponent getAsComponent() {
        return this;
    }

    public void defaultView() {
        this.assenStelselChanged(-100.0, -100.0, 100.0, 100.0);
    }

    public void recenter(double x, double y) {
        this.assenStelselChanged(x + this.itsAssenStelsel.getXMin(), y + this.itsAssenStelsel.getYMin(), x + this.itsAssenStelsel.getXMax(), y + this.itsAssenStelsel.getYMax());
    }

    public void fitToScreen() {
        if (!this.isSplines) {
            this.fitKrommeToScreen();
        } else {
            this.fitSplinesToScreen();
        }
    }

    public void fitKrommeToScreen() {
        if (this.itsKromme != null) {
            double[] xCurve = this.itsKromme.getXCurve();
            double[] yCurve = this.itsKromme.getYCurve();
            double xMin = -100.0;
            double yMin = -100.0;
            double yMax = 100.0;
            double xMax = 100.0;
            xMin = xMax = xCurve[0];
            yMin = yMax = yCurve[0];
            for (int i = 0; i < xCurve.length; ++i) {
                if (xCurve[i] < xMin) {
                    xMin = xCurve[i];
                }
                if (xCurve[i] > xMax) {
                    xMax = xCurve[i];
                }
                if (yCurve[i] < yMin) {
                    yMin = yCurve[i];
                }
                if (!(yCurve[i] > yMax)) continue;
                yMax = yCurve[i];
            }
            if (xMin != xMax && yMax != yMin) {
                this.assenStelselChanged(xMin * 1.1, yMin * 1.1, xMax * 1.1, yMax * 1.1);
            }
        }
    }

    private void fitSplinesToScreen() {
        double xMin = -100.0;
        double yMin = -100.0;
        double yMax = 100.0;
        double xMax = 100.0;
        if (this.itsSplines == null) {
            return;
        }
        xMin = xMax = this.itsSplines[0].getXCurve()[0];
        yMin = yMax = this.itsSplines[0].getYCurve()[0];
        for (int nSegment = 0; nSegment < this.itsSplines.length; ++nSegment) {
            double[] xCurve = this.itsSplines[nSegment].getXCurve();
            double[] yCurve = this.itsSplines[nSegment].getYCurve();
            for (int i = 0; i < xCurve.length; ++i) {
                if (xCurve[i] < xMin) {
                    xMin = xCurve[i];
                }
                if (xCurve[i] > xMax) {
                    xMax = xCurve[i];
                }
                if (yCurve[i] < yMin) {
                    yMin = yCurve[i];
                }
                if (!(yCurve[i] > yMax)) continue;
                yMax = yCurve[i];
            }
            if (xMin == xMax || yMax == yMin) continue;
            this.assenStelselChanged(xMin * 1.1, yMin * 1.1, xMax * 1.1, yMax * 1.1);
        }
    }
}

