/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.GebruikersInterface;
import GrafischeTechnieken.GrafischeEngine;
import GrafischeTechnieken.OutputVenster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class ProjectGT {
    private static final String bgImagePath = "images/woodsbig.jpg";
    protected GebruikersInterface itsGebruikersInterface;
    protected GrafischeEngine itsGrafischeEngine;
    protected OutputVenster itsOutputVenster;
    protected JWindow desktopWindow;

    public ProjectGT() {
        this.initRelations();
        this.createDesktopPane();
    }

    private void createDesktopPane() {
        this.desktopWindow = new JWindow();
        Toolkit tk = this.desktopWindow.getToolkit();
        JLayeredPane lPane = new JLayeredPane();
        lPane.setDoubleBuffered(true);
        lPane.add((Component)this.createBGPane(), Integer.MIN_VALUE);
        lPane.add((Component)this.itsGebruikersInterface.getItsMenuVenster(), new Integer(1));
        lPane.add((Component)this.itsGebruikersInterface.getItsOutputVenster(), new Integer(2));
        lPane.add((Component)this.itsGebruikersInterface.getItsOutputVenster().getItsBasisMatrixVenster(), new Integer(2));
        lPane.add((Component)this.itsGebruikersInterface.getItsOutputVenster().getItsGrafiekVenster(), new Integer(2));
        lPane.add((Component)this.itsGebruikersInterface.getItsMenuVenster().getItsGraadManipulatieVenster(), new Integer(2));
        lPane.add((Component)this.itsGebruikersInterface.getItsMenuVenster().getItsHelpVenster(), new Integer(3));
        Color bgColor = new Color(0, 0, 0);
        Font smallFont = new Font("SansSerif", 1, 11);
        this.desktopWindow.setLayeredPane(lPane);
        this.desktopWindow.setSize(tk.getScreenSize());
        this.desktopWindow.show();
        try {
            this.itsGebruikersInterface.getItsMenuVenster().setSelected(true);
            this.itsGebruikersInterface.getItsMenuVenster().show();
            this.itsGebruikersInterface.getItsOutputVenster().setIcon(true);
            this.itsGebruikersInterface.getItsOutputVenster().show();
            this.itsGebruikersInterface.getItsOutputVenster().getItsBasisMatrixVenster().setIcon(true);
            this.itsGebruikersInterface.getItsOutputVenster().getItsBasisMatrixVenster().show();
            this.itsGebruikersInterface.getItsOutputVenster().getItsGrafiekVenster().setIcon(true);
            this.itsGebruikersInterface.getItsOutputVenster().getItsGrafiekVenster().show();
            this.itsGebruikersInterface.getItsMenuVenster().getItsHelpVenster().setIcon(true);
            this.itsGebruikersInterface.getItsMenuVenster().getItsHelpVenster().show();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public JPanel createBGPane() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        BufferedImage bgImg = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 1);
        Graphics2D bgGraph = bgImg.createGraphics();
        try {
            bgGraph.drawImage(ImageIO.read(new File(bgImagePath)), 0, 0, (int)d.getWidth(), (int)d.getHeight(), this.desktopWindow);
        }
        catch (IOException e) {
            // empty catch block
        }
        JLabel bgLabel = new JLabel(new ImageIcon(bgImg));
        bgLabel.setForeground(Color.black);
        bgLabel.setOpaque(true);
        JPanel testPane = new JPanel(new BorderLayout());
        testPane.add(bgLabel);
        testPane.setSize(tk.getScreenSize());
        testPane.setOpaque(false);
        return testPane;
    }

    public GebruikersInterface getItsGebruikersInterface() {
        return this.itsGebruikersInterface;
    }

    public GebruikersInterface newItsGebruikersInterface() {
        this.itsGebruikersInterface = new GebruikersInterface();
        return this.itsGebruikersInterface;
    }

    public void deleteItsGebruikersInterface() {
        this.itsGebruikersInterface = null;
    }

    public GrafischeEngine getItsGrafischeEngine() {
        return this.itsGrafischeEngine;
    }

    public void deleteItsGrafischeEngine() {
        this.itsGrafischeEngine = null;
    }

    public OutputVenster getItsOutputVenster() {
        return this.itsOutputVenster;
    }

    public OutputVenster newItsOutputVenster() {
        this.itsOutputVenster = new OutputVenster();
        return this.itsOutputVenster;
    }

    public void deleteItsOutputVenster() {
        this.itsOutputVenster = null;
    }

    protected void initRelations() {
        this.itsGebruikersInterface = this.newItsGebruikersInterface();
        this.itsOutputVenster = this.newItsOutputVenster();
    }
}

