/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.AssenStelsel;
import GrafischeTechnieken.AssenStelselListener;
import GrafischeTechnieken.BSplineMouseEventHandler;
import GrafischeTechnieken.BezierMouseEventHandler;
import GrafischeTechnieken.Canvas;
import GrafischeTechnieken.ControlePunt;
import GrafischeTechnieken.DataPunt;
import GrafischeTechnieken.GrafischeEngine;
import GrafischeTechnieken.Kromme;
import GrafischeTechnieken.NevilleMouseEventHandler;
import GrafischeTechnieken.Punt;
import GrafischeTechnieken.PuntenVenster;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class TekenVenster
extends Canvas
implements ComponentListener,
AssenStelselListener {
    protected AssenStelsel itsAssenStelsel;
    protected LinkedList itsControlePunt;
    protected LinkedList itsDataPunt;
    protected DataPunt activeDataPunt;
    protected Kromme itsKromme;
    protected Kromme[] itsSplines;
    protected PuntenVenster itsPuntenVenster;
    protected GrafischeEngine itsGrafischeEngine;
    public static NevilleMouseEventHandler nevilleMouseListener;
    public static BSplineMouseEventHandler bsplineMouseListener;
    public static BezierMouseEventHandler bezierMouseListener;
    public static BufferedImage dataPointImg;
    public static BufferedImage sDataPointImg;
    public static BufferedImage controlPointImg;
    public static BufferedImage sControlPointImg;
    Color fadeBlack = new Color(0, 0, 0, 128);
    Color reddish = new Color(250, 160, 170, 170);
    Color blueish = new Color(180, 160, 230, 170);
    Color greenish = new Color(180, 250, 180, 170);
    Rectangle2D assenStelselMark;
    int typeOfCurve;
    Color curveColor;
    static Stroke thinDash;
    static Stroke dotDash;
    private static final Font miniFont;
    Punt selectedPoint;
    BufferedImage curveBuffer;
    boolean isSpline;

    public TekenVenster() {
        super(true);
        this.addComponentListener(this);
        try {
            dataPointImg = ImageIO.read(new File("images/point_0.png"));
            sDataPointImg = ImageIO.read(new File("images/point_1.png"));
            controlPointImg = ImageIO.read(new File("images/point_2.png"));
            sControlPointImg = ImageIO.read(new File("images/point_3.png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        float[] dashf = new float[]{1.0f, 3.0f};
        thinDash = new BasicStroke(1.0f, 0, 0, 1.0f, dashf, 0.0f);
        float[] dash2f = new float[]{1.0f, 3.0f, 2.0f};
        dotDash = new BasicStroke(1.0f, 0, 2, 1.0f, dash2f, 1.0f);
        this.curveColor = this.reddish;
        this.itsControlePunt = new LinkedList();
        this.itsDataPunt = new LinkedList();
        this.initRelations();
        this.selectedPoint = null;
    }

    public void drawGrid() {
        super.redrawGrid();
        Point2D.Double p = this.itsAssenStelsel.cartToScreen(0.0, 0.0, this.getWidth(), this.getHeight());
        int centerx = (int)p.getX();
        int centery = (int)p.getY();
        int step = this.itsAssenStelsel.getGridStep();
        this.gridBufG.setColor(this.fadeBlack);
        this.gridBufG.setStroke(new BasicStroke());
        this.gridBufG.drawLine(centerx, 10, centerx, this.mHeight - 10);
        this.gridBufG.drawLine(10, centery, this.mWidth - 10, centery);
        this.gridBufG.setStroke(thinDash);
        int x = centerx;
        while (x + step < this.mWidth - 5) {
            this.gridBufG.drawLine(x += step, 0, x, this.mHeight);
        }
        x = centerx;
        while (x - step > 5) {
            this.gridBufG.drawLine(x -= step, 0, x, this.mHeight);
        }
        int y = centery;
        while (y + step < this.mHeight - 5) {
            this.gridBufG.drawLine(0, y += step, this.mWidth, y);
        }
        y = centery;
        while (y - step > 5) {
            this.gridBufG.drawLine(0, y -= step, this.mWidth, y);
        }
        this.gridBufG.fillOval(centerx - 3, centery - 3, 7, 7);
    }

    public void paintComponent(Graphics G) {
        Graphics2D g2 = (Graphics2D)G;
        g2.drawImage(this.gridBuf, 0, 0, this.mWidth, this.mHeight, this);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.itsKromme != null || this.itsSplines != null) {
            G.drawImage(this.curveBuffer, 0, 0, this);
        }
        this.paintInputs((Graphics2D)G);
        if (this.assenStelselMark != null) {
            g2.setColor(new Color(180, 180, 180, 180));
            g2.fill(this.assenStelselMark);
            g2.setColor(new Color(255, 255, 255));
            Point m = this.assenStelselMark.getBounds().getLocation();
            m.translate((int)this.assenStelselMark.getWidth() / 2, (int)this.assenStelselMark.getHeight() / 2);
            g2.setStroke(dotDash);
            g2.drawLine((int)this.assenStelselMark.getX(), (int)m.getY(), (int)(this.assenStelselMark.getX() + this.assenStelselMark.getWidth()), (int)m.getY());
            g2.drawLine((int)m.getX(), (int)this.assenStelselMark.getY(), (int)m.getX(), (int)(this.assenStelselMark.getY() + this.assenStelselMark.getHeight()));
            g2.setStroke(new BasicStroke());
            g2.fillOval((int)m.getX() - 3, (int)m.getY() - 3, 7, 7);
            g2.setColor(new Color(128, 128, 128, 200));
            g2.drawOval((int)m.getX() - 3, (int)m.getY() - 3, 7, 7);
            g2.setColor(Color.darkGray);
            g2.draw(this.assenStelselMark);
        }
    }

    public void paintInputs(Graphics2D g2) {
        int id = 0;
        ListIterator iterD = this.getItsDataPunt();
        while (iterD.hasNext()) {
            this.paintDataPunt((DataPunt)iterD.next(), id, g2);
            ++id;
        }
        iterD = this.getItsControlePunt();
        while (iterD.hasNext()) {
            this.paintControlePunt((ControlePunt)iterD.next(), id, g2);
            ++id;
        }
    }

    public void paintDataPunt(DataPunt dp, int id, Graphics2D g2) {
        double x = dp.getX();
        double y = dp.getY();
        Point2D.Double sP = this.itsAssenStelsel.cartToScreen(x, y, this.getWidth(), this.getHeight());
        int sx = (int)sP.getX();
        int sy = (int)sP.getY();
        if (dp.getDiff1() != null) {
            Point2D.Double diff1P = this.itsAssenStelsel.cartToScreen(dp.getDiff1().getX() + x, dp.getDiff1().getY() + y, this.getWidth(), this.getHeight());
            int diff1x = (int)diff1P.getX();
            int diff1y = (int)diff1P.getY();
            g2.setColor(new Color(255, 255, 255, 128));
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(sx, sy, diff1x, diff1y);
            g2.setColor(new Color(70, 80, 100));
            g2.setStroke(new BasicStroke(1.5f));
            g2.drawLine(sx, sy, diff1x, diff1y);
            g2.setColor(new Color(255, 255, 255, 128));
            g2.fillOval(diff1x - 4, diff1y - 4, 9, 9);
            g2.setColor(Color.black);
            g2.fillOval(diff1x - 3, diff1y - 3, 7, 7);
            g2.setColor(Color.white);
            g2.fillOval(diff1x - 1, diff1y - 1, 3, 3);
            if (dp.getDiff2() != null) {
                Point2D.Double diff2P = this.itsAssenStelsel.cartToScreen(dp.getDiff2().getX() + x, dp.getDiff2().getY() + y, this.getWidth(), this.getHeight());
                int diff2x = (int)diff2P.getX();
                int diff2y = (int)diff2P.getY();
                g2.setColor(new Color(255, 255, 255, 128));
                g2.setStroke(new BasicStroke(3.0f));
                g2.drawLine(sx, sy, diff2x, diff2y);
                g2.setColor(new Color(90, 90, 60));
                g2.setStroke(new BasicStroke());
                g2.drawLine(sx, sy, diff2x, diff2y);
                g2.setColor(new Color(255, 255, 255, 128));
                g2.fillOval(diff2x - 4, diff2y - 4, 9, 9);
                g2.setColor(new Color(50, 50, 20));
                g2.fillOval(diff2x - 3, diff2y - 3, 7, 7);
            }
        }
        g2.setFont(miniFont);
        g2.setColor(new Color(220, 220, 220, 220));
        g2.setStroke(new BasicStroke(0.5f));
        if (id < 10) {
            g2.fillRoundRect(sx + 3, sy + 1, 13, 11, 3, 3);
            g2.setColor(Color.white);
            g2.drawRoundRect(sx + 3, sy + 1, 13, 11, 3, 3);
        } else {
            g2.fillRoundRect(sx + 3, sy + 1, 20, 11, 3, 3);
            g2.setColor(Color.white);
            g2.drawRoundRect(sx + 3, sy + 1, 20, 11, 3, 3);
        }
        g2.setColor(Color.black);
        g2.drawString(id + "", sx + 6, sy + 10);
        if (this.selectedPoint != dp) {
            g2.drawImage(dataPointImg, null, sx - 7, sy - 7);
        } else {
            g2.drawImage(sDataPointImg, null, sx - 7, sy - 7);
        }
    }

    public void paintControlePunt(ControlePunt cp, int id, Graphics2D g2) {
        double x = cp.getX();
        double y = cp.getY();
        Point2D.Double sP = this.itsAssenStelsel.cartToScreen(x, y, this.getWidth(), this.getHeight());
        int sx = (int)sP.getX();
        int sy = (int)sP.getY();
        g2.setFont(miniFont);
        g2.setColor(new Color(220, 220, 220, 220));
        g2.setStroke(new BasicStroke(0.5f));
        if (id < 10) {
            g2.fillRoundRect(sx + 3, sy + 1, 13, 11, 3, 3);
            g2.setColor(Color.white);
            g2.drawRoundRect(sx + 3, sy + 1, 13, 11, 3, 3);
        } else {
            g2.fillRoundRect(sx + 3, sy + 1, 20, 11, 3, 3);
            g2.setColor(Color.white);
            g2.drawRoundRect(sx + 3, sy + 1, 20, 11, 3, 3);
        }
        g2.setColor(Color.black);
        g2.drawString(id + "", sx + 6, sy + 10);
        if (this.selectedPoint != cp) {
            g2.drawImage(controlPointImg, null, sx - 7, sy - 7);
        } else {
            g2.drawImage(sControlPointImg, null, sx - 7, sy - 7);
        }
    }

    public void paintKromme(Graphics2D G) {
        G.setComposite(AlphaComposite.getInstance(1));
        G.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G.setColor(new Color(0, 0, 0, 0));
        G.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.itsKromme == null) {
            return;
        }
        double[] xItsKromme = this.itsKromme.getXCurve();
        double[] yItsKromme = this.itsKromme.getYCurve();
        int[] sItsKrommeX = new int[xItsKromme.length];
        int[] sItsKrommeY = new int[yItsKromme.length];
        Rectangle rect = G.getClipBounds();
        int bufW = this.getWidth();
        int bufH = this.getHeight();
        G.setComposite(AlphaComposite.getInstance(3));
        for (int i = 0; i < xItsKromme.length; ++i) {
            Point2D.Double sP = this.itsAssenStelsel.cartToScreen(xItsKromme[i], yItsKromme[i], bufW, bufH);
            sItsKrommeX[i] = (int)sP.getX();
            sItsKrommeY[i] = (int)sP.getY();
        }
        G.setColor(this.curveColor);
        G.setStroke(new BasicStroke(5.0f));
        G.drawPolyline(sItsKrommeX, sItsKrommeY, xItsKromme.length);
        G.setColor(new Color(80, 50, 80));
        G.setStroke(new BasicStroke(1.0f, 0, 1));
        G.drawPolyline(sItsKrommeX, sItsKrommeY, xItsKromme.length);
    }

    public void paintSplines(Graphics2D G) {
        G.setComposite(AlphaComposite.getInstance(1));
        G.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G.setColor(new Color(0, 0, 0, 0));
        G.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.itsSplines == null) {
            return;
        }
        for (int nSegment = 0; nSegment < this.itsSplines.length; ++nSegment) {
            double[] xItsKromme = this.itsSplines[nSegment].getXCurve();
            double[] yItsKromme = this.itsSplines[nSegment].getYCurve();
            int[] sItsKrommeX = new int[xItsKromme.length];
            int[] sItsKrommeY = new int[yItsKromme.length];
            Rectangle rect = G.getClipBounds();
            int bufW = this.getWidth();
            int bufH = this.getHeight();
            G.setComposite(AlphaComposite.getInstance(3));
            for (int i = 0; i < xItsKromme.length; ++i) {
                Point2D.Double sP = this.itsAssenStelsel.cartToScreen(xItsKromme[i], yItsKromme[i], bufW, bufH);
                sItsKrommeX[i] = (int)sP.getX();
                sItsKrommeY[i] = (int)sP.getY();
            }
            G.setColor(this.curveColor);
            G.setStroke(new BasicStroke(5.0f));
            G.drawPolyline(sItsKrommeX, sItsKrommeY, xItsKromme.length);
            G.setColor(new Color(80, 50, 80));
            G.setStroke(new BasicStroke(1.0f, 0, 1));
            G.drawPolyline(sItsKrommeX, sItsKrommeY, xItsKromme.length);
            G.setColor(Color.black);
            G.fillOval(sItsKrommeX[0] - 4, sItsKrommeY[0] - 4, 9, 9);
            G.setColor(Color.white);
            G.fillOval(sItsKrommeX[0] - 1, sItsKrommeY[0] - 1, 3, 3);
            if (nSegment != this.itsSplines.length - 1) continue;
            G.setColor(Color.black);
            G.fillOval(sItsKrommeX[sItsKrommeX.length - 1] - 4, sItsKrommeY[sItsKrommeY.length - 1] - 4, 9, 9);
            G.setColor(Color.white);
            G.fillOval(sItsKrommeX[sItsKrommeX.length - 1] - 1, sItsKrommeY[sItsKrommeY.length - 1] - 1, 3, 3);
        }
    }

    public void setSelectedPoint(Punt p) {
        this.selectedPoint = p;
        this.repaint();
    }

    public Punt getSelectedPoint() {
        return this.selectedPoint;
    }

    public void changePunt(Punt p, double newX, double newY) {
        this.itsGrafischeEngine.verplaatsPunt(p, newX, newY);
        this.itsGrafischeEngine.berekenCurve();
    }

    public void removeDataPunt(Punt p) {
        if (p != null) {
            this.itsDataPunt.remove(p);
            this.itsGrafischeEngine.verwijderDataPunt(p);
            this.itsGrafischeEngine.berekenCurve();
        }
    }

    public void removeControlePunt(Punt p) {
        if (p != null) {
            this.itsControlePunt.remove(p);
            this.itsGrafischeEngine.verwijderControlePunt(p);
            this.itsGrafischeEngine.berekenCurve();
        }
    }

    public void setItsKromme(Kromme p_Kromme) {
        this.itsKromme = p_Kromme;
        if (this.curveBuffer != null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.paintKromme(this.curveBuffer.createGraphics());
            this.repaint();
        }
    }

    public void setItsSplines(Kromme[] p_Kromme) {
        this.itsSplines = p_Kromme;
        if (this.curveBuffer != null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.paintSplines(this.curveBuffer.createGraphics());
            this.repaint();
        }
    }

    public void redrawDetails() {
    }

    public void setItsGrafischeEngine(GrafischeEngine ge) {
        this.itsGrafischeEngine = ge;
    }

    public AssenStelsel getItsAssenStelsel() {
        return this.itsAssenStelsel;
    }

    public void __setItsAssenStelsel(AssenStelsel p_AssenStelsel) {
        this.itsAssenStelsel = p_AssenStelsel;
    }

    public void _setItsAssenStelsel(AssenStelsel p_AssenStelsel) {
        if (this.itsAssenStelsel != null) {
            this.itsAssenStelsel.__setItsTekenVenster(null);
        }
        this.__setItsAssenStelsel(p_AssenStelsel);
    }

    public AssenStelsel newItsAssenStelsel() {
        this.itsAssenStelsel = new AssenStelsel();
        this.itsAssenStelsel._setItsTekenVenster(this);
        return this.itsAssenStelsel;
    }

    public void deleteItsAssenStelsel() {
        this.itsAssenStelsel.__setItsTekenVenster(null);
        this.itsAssenStelsel = null;
    }

    public ListIterator getItsControlePunt() {
        ListIterator iter = this.itsControlePunt.listIterator(0);
        return iter;
    }

    public void _addItsControlePunt(ControlePunt p_ControlePunt) {
        this.itsControlePunt.add(p_ControlePunt);
    }

    public void addItsControlePunt(ControlePunt p_ControlePunt) {
        if (p_ControlePunt != null) {
            p_ControlePunt._setItsTekenVenster(this);
        }
        this._addItsControlePunt(p_ControlePunt);
    }

    public void _removeItsControlePunt(ControlePunt p_ControlePunt) {
        this.itsControlePunt.remove(p_ControlePunt);
    }

    public void removeItsControlePunt(ControlePunt p_ControlePunt) {
        if (p_ControlePunt != null) {
            p_ControlePunt.__setItsTekenVenster(null);
        }
        this._removeItsControlePunt(p_ControlePunt);
    }

    public void _clearItsControlePunt() {
        this.itsControlePunt.clear();
    }

    public void clearItsControlePunt() {
        ListIterator iter = this.itsControlePunt.listIterator(0);
        while (iter.hasNext()) {
            ((ControlePunt)iter.next())._clearItsTekenVenster();
        }
        this._clearItsControlePunt();
    }

    public ListIterator getItsDataPunt() {
        ListIterator iter = this.itsDataPunt.listIterator(0);
        return iter;
    }

    public void setItsDataPunt(LinkedList itsDataPunt) {
        this.itsDataPunt = itsDataPunt;
    }

    public void setItsControlePunt(LinkedList itsControlePunt) {
        this.itsControlePunt = itsControlePunt;
    }

    public void addScreenDataPunt(Point p) {
        Point2D.Double cartP = this.itsAssenStelsel.screenToCart(p.getX(), p.getY(), this.mWidth, this.mHeight);
        this.activeDataPunt = new DataPunt(cartP);
        this.addDataPunt(this.activeDataPunt);
        this.repaint();
    }

    public void addScreenControlePunt(Point p) {
        Point2D.Double cartP = this.itsAssenStelsel.screenToCart(p.getX(), p.getY(), this.mWidth, this.mHeight);
        this.addItsControlePunt(new ControlePunt(cartP));
    }

    public void addDataPunt(DataPunt dp) {
        this.addItsDataPunt(dp);
    }

    public DataPunt getActiveDataPunt() {
        return this.activeDataPunt;
    }

    public void setScreenDiff1(Point p, DataPunt dp) {
        Point2D.Double cartP = this.itsAssenStelsel.screenToCart(p.getX(), p.getY(), this.mWidth, this.mHeight);
        Point2D.Double diffP = new Point2D.Double(cartP.getX() - dp.getX(), cartP.getY() - dp.getY());
        Punt diff = new Punt(diffP);
        dp.setDiff1(diff);
    }

    public void setScreenDiff1(Punt p, Point new_location) {
        DataPunt dp = (DataPunt)this.itsDataPunt.get(this.itsDataPunt.indexOf(p));
        if (dp != null) {
            this.setScreenDiff1(new_location, dp);
        }
    }

    public void setScreenDiff2(Point p, DataPunt dp) {
        Point2D.Double cartP = this.itsAssenStelsel.screenToCart(p.getX(), p.getY(), this.mWidth, this.mHeight);
        Point2D.Double diffP = new Point2D.Double(cartP.getX() - dp.getX(), cartP.getY() - dp.getY());
        Punt diff = new Punt(diffP);
        if (dp.getDiff1() != null) {
            dp.setDiff2(diff);
        }
    }

    public void setScreenDiff2(Punt p, Point new_location) {
        DataPunt dp = (DataPunt)this.itsDataPunt.get(this.itsDataPunt.indexOf(p));
        if (dp != null) {
            this.setScreenDiff2(new_location, dp);
        }
    }

    public void _addItsDataPunt(DataPunt p_DataPunt) {
        this.itsDataPunt.add(p_DataPunt);
    }

    public void addItsDataPunt(DataPunt p_DataPunt) {
        if (p_DataPunt != null) {
            p_DataPunt._setItsTekenVenster(this);
        }
        this._addItsDataPunt(p_DataPunt);
    }

    public void _removeItsDataPunt(DataPunt p_DataPunt) {
        this.itsDataPunt.remove(p_DataPunt);
    }

    public void removeItsDataPunt(DataPunt p_DataPunt) {
        if (p_DataPunt != null) {
            p_DataPunt.__setItsTekenVenster(null);
        }
        this._removeItsDataPunt(p_DataPunt);
    }

    public void _clearItsDataPunt() {
        this.itsDataPunt.clear();
    }

    public void clearItsDataPunt() {
        ListIterator iter = this.itsDataPunt.listIterator(0);
        while (iter.hasNext()) {
            ((DataPunt)iter.next())._clearItsTekenVenster();
        }
        this._clearItsDataPunt();
    }

    public PuntenVenster getItsPuntenVenster() {
        return this.itsPuntenVenster;
    }

    public void __setItsPuntenVenster(PuntenVenster p_PuntenVenster) {
        this.itsPuntenVenster = p_PuntenVenster;
        nevilleMouseListener.setItsPuntenVenster(this.itsPuntenVenster);
        bsplineMouseListener.setItsPuntenVenster(this.itsPuntenVenster);
        bezierMouseListener.setItsPuntenVenster(this.itsPuntenVenster);
    }

    public void _setItsPuntenVenster(PuntenVenster p_PuntenVenster) {
        if (this.itsPuntenVenster != null) {
            this.itsPuntenVenster.__setItsTekenVenster(null);
        }
        this.__setItsPuntenVenster(p_PuntenVenster);
    }

    public void setItsPuntenVenster(PuntenVenster p_PuntenVenster) {
        if (p_PuntenVenster != null) {
            p_PuntenVenster._setItsTekenVenster(this);
        }
        this._setItsPuntenVenster(p_PuntenVenster);
        this.drawGrid();
    }

    public void _clearItsPuntenVenster() {
        this.itsPuntenVenster = null;
    }

    protected void initRelations() {
        this.itsAssenStelsel = this.newItsAssenStelsel();
        nevilleMouseListener = new NevilleMouseEventHandler();
        bsplineMouseListener = new BSplineMouseEventHandler();
        bezierMouseListener = new BezierMouseEventHandler();
    }

    public void changeTypeOfCurve(int oldType, int newType) {
        switch (oldType) {
            case 0: {
                this.removeMouseListener(nevilleMouseListener);
                this.removeMouseMotionListener(nevilleMouseListener);
                break;
            }
            case 1: {
                this.removeMouseListener(bsplineMouseListener);
                this.removeMouseMotionListener(bsplineMouseListener);
                break;
            }
            case 2: {
                this.removeMouseListener(bezierMouseListener);
                this.removeMouseMotionListener(bezierMouseListener);
            }
        }
        switch (newType) {
            case 0: {
                this.addMouseListener(nevilleMouseListener);
                this.addMouseMotionListener(nevilleMouseListener);
                this.isSpline = false;
                this.curveColor = this.reddish;
                break;
            }
            case 1: {
                this.addMouseListener(bsplineMouseListener);
                this.addMouseMotionListener(bsplineMouseListener);
                this.isSpline = true;
                this.curveColor = this.blueish;
                break;
            }
            case 2: {
                this.addMouseListener(bezierMouseListener);
                this.addMouseMotionListener(bezierMouseListener);
                this.isSpline = true;
                this.curveColor = this.greenish;
            }
        }
        this.typeOfCurve = newType;
    }

    public int getType() {
        return this.typeOfCurve;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.drawGrid();
        this.curveBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        if (this.itsKromme != null) {
            this.paintKromme(this.curveBuffer.createGraphics());
        }
        if (this.itsSplines != null) {
            this.paintSplines(this.curveBuffer.createGraphics());
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void assenStelselChanged(double xMin, double yMin, double xMax, double yMax) {
        if (xMin != xMax && yMax != yMin) {
            this.itsAssenStelsel.setBounds(xMin, yMin, xMax, yMax);
        }
        this.assenStelselMark = null;
        if (this.itsKromme != null) {
            this.paintKromme(this.curveBuffer.createGraphics());
        }
        if (this.itsSplines != null) {
            this.paintSplines(this.curveBuffer.createGraphics());
        }
        this.drawGrid();
        this.repaint();
    }

    public void setAssenStelselMark(Rectangle2D r) {
        this.assenStelselMark = r;
        this.repaint();
    }

    public double getWidthOnScreen() {
        return this.getWidth();
    }

    public double getHeightOnScreen() {
        return this.getHeight();
    }

    public JComponent getAsComponent() {
        return this;
    }

    public void defaultView() {
        this.assenStelselChanged(-100.0, -100.0, 100.0, 100.0);
        this.assenStelselMark = null;
        this.repaint();
    }

    public void fitToScreen() {
        if (!this.isSpline) {
            this.fitKrommeToScreen();
        } else {
            this.fitSplinesToScreen();
        }
    }

    public void recenter(double x, double y) {
        this.assenStelselChanged(x + this.itsAssenStelsel.getXMin(), y + this.itsAssenStelsel.getYMin(), x + this.itsAssenStelsel.getXMax(), y + this.itsAssenStelsel.getYMax());
    }

    private void fitKrommeToScreen() {
        double xMin = -100.0;
        double yMin = -100.0;
        double yMax = 100.0;
        double xMax = 100.0;
        if (this.itsKromme != null) {
            double[] xCurve = this.itsKromme.getXCurve();
            double[] yCurve = this.itsKromme.getYCurve();
            xMin = xMax = xCurve[0];
            yMin = yMax = yCurve[0];
            for (int i = 0; i < xCurve.length; ++i) {
                if (xCurve[i] < xMin) {
                    xMin = xCurve[i];
                }
                if (xCurve[i] > xMax) {
                    xMax = xCurve[i];
                }
                if (yCurve[i] < yMin) {
                    yMin = yCurve[i];
                }
                if (!(yCurve[i] > yMax)) continue;
                yMax = yCurve[i];
            }
            if (xMin != xMax && yMax != yMin) {
                this.assenStelselChanged(xMin * 1.1, yMin * 1.1, xMax * 1.1, yMax * 1.1);
            }
        }
    }

    private void fitSplinesToScreen() {
        double xMin = -100.0;
        double yMin = -100.0;
        double yMax = 100.0;
        double xMax = 100.0;
        if (this.itsSplines == null) {
            return;
        }
        xMin = xMax = this.itsSplines[0].getXCurve()[0];
        yMin = yMax = this.itsSplines[0].getYCurve()[0];
        for (int nSegment = 0; nSegment < this.itsSplines.length; ++nSegment) {
            double[] xCurve = this.itsSplines[nSegment].getXCurve();
            double[] yCurve = this.itsSplines[nSegment].getYCurve();
            for (int i = 0; i < xCurve.length; ++i) {
                if (xCurve[i] < xMin) {
                    xMin = xCurve[i];
                }
                if (xCurve[i] > xMax) {
                    xMax = xCurve[i];
                }
                if (yCurve[i] < yMin) {
                    yMin = yCurve[i];
                }
                if (!(yCurve[i] > yMax)) continue;
                yMax = yCurve[i];
            }
            if (xMin == xMax || yMax == yMin) continue;
            this.assenStelselChanged(xMin * 1.1, yMin * 1.1, xMax * 1.1, yMax * 1.1);
        }
    }

    static {
        miniFont = new Font("Monospaced", 1, 10);
    }
}

