/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.AssenStelsel;
import GrafischeTechnieken.AssenStelselListener;
import GrafischeTechnieken.GTToolPane;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ZoomBoxHandler
implements MouseListener,
MouseMotionListener,
ActionListener {
    boolean needsToolPane;
    GTToolPane toolPane;
    AssenStelselListener target;
    AssenStelsel assenStelsel;
    Point lastScreenPoint;
    Point nPoint;
    boolean draggingBox;
    JPopupMenu zoomMenu;
    JMenuItem boxZoom;

    public ZoomBoxHandler(AssenStelselListener target, AssenStelsel assenStelsel, GTToolPane toolPane) {
        this.target = target;
        this.assenStelsel = assenStelsel;
        this.toolPane = toolPane;
        this.needsToolPane = true;
        this.makeZoomMenu();
    }

    public ZoomBoxHandler(AssenStelselListener target, AssenStelsel assenStelsel) {
        this.target = target;
        this.assenStelsel = assenStelsel;
        this.needsToolPane = false;
        this.makeZoomMenu();
    }

    public void makeZoomMenu() {
        this.zoomMenu = new JPopupMenu();
        this.boxZoom = new JMenuItem("Use dragged box");
        this.zoomMenu.add(this.boxZoom);
        JMenuItem fitToScreen = new JMenuItem("Fit to screen");
        this.zoomMenu.add(fitToScreen);
        JMenuItem defaultView = new JMenuItem("Default view");
        this.zoomMenu.add(defaultView);
        this.target.getAsComponent().add(this.zoomMenu);
        this.boxZoom.setEnabled(false);
        this.boxZoom.addActionListener(this);
        fitToScreen.addActionListener(this);
        defaultView.addActionListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.needsToolPane && this.toolPane.getMode() == 3 || !this.needsToolPane) {
            this.lastScreenPoint = e.getPoint();
        }
        if (this.needsToolPane && this.toolPane.getMode() == 4) {
            Point2D.Double centerP = this.assenStelsel.screenToCart(e.getX(), e.getY(), this.target.getWidthOnScreen(), this.target.getHeightOnScreen());
            this.target.recenter(centerP.getX(), centerP.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.needsToolPane && this.toolPane.getMode() == 3 || !this.needsToolPane) {
            this.nPoint = e.getPoint();
            if (this.lastScreenPoint != null) {
                this.zoomMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if ((this.needsToolPane && this.toolPane.getMode() == 3 || !this.needsToolPane) && this.lastScreenPoint != null) {
            this.draggingBox = true;
            this.boxZoom.setEnabled(true);
            Rectangle r = new Rectangle();
            r.setRect(this.lastScreenPoint.getX(), this.lastScreenPoint.getY(), e.getPoint().getX() - this.lastScreenPoint.getX(), e.getPoint().getY() - this.lastScreenPoint.getY());
            this.target.setAssenStelselMark(r);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equals("Use dragged box")) {
            this.zoomWithBox();
        }
        if (str.equals("Fit to screen")) {
            this.target.fitToScreen();
        }
        if (str.equals("Default view")) {
            this.target.defaultView();
        }
        this.boxZoom.setEnabled(false);
        this.draggingBox = false;
        this.lastScreenPoint = null;
    }

    public void zoomWithBox() {
        if (this.draggingBox) {
            Point2D.Double firstP = this.assenStelsel.screenToCart(this.lastScreenPoint.getX(), this.lastScreenPoint.getY(), this.target.getWidthOnScreen(), this.target.getHeightOnScreen());
            Point2D.Double lastP = this.assenStelsel.screenToCart(this.nPoint.getX(), this.nPoint.getY(), this.target.getWidthOnScreen(), this.target.getHeightOnScreen());
            double xMin = Math.min(firstP.getX(), lastP.getX());
            double xMax = Math.max(firstP.getX(), lastP.getX());
            double yMin = Math.min(firstP.getY(), lastP.getY());
            double yMax = Math.max(firstP.getY(), lastP.getY());
            this.target.assenStelselChanged(xMin, yMin, xMax, yMax);
        }
    }
}

