/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package be.hogent.iii.voetbal.bo;

import be.hogent.iii.voetbal.interfaces.IClub;
import be.hogent.iii.voetbal.interfaces.IDoelpunt;
import be.hogent.iii.voetbal.interfaces.IKaart;
import be.hogent.iii.voetbal.interfaces.IMatch;
import be.hogent.iii.voetbal.interfaces.IScheidsrechter;
import be.hogent.iii.voetbal.interfaces.IVoetballer;
import be.hogent.iii.voetbal.interfaces.IWissel;
import java.sql.Time;
import java.util.Date;
import java.util.List;

/**
 *
 * @author kvdw
 */
public class Match implements IMatch{

    private int id;
    private int speeldag;
    private Date datum;
    private Time uur;
    private int aantalToeschouwers;
    private IClub thuisploeg;
    private IClub uitploeg;
    private List <IVoetballer> thuisspelers;
    private List <IVoetballer> uitspelers;
    private List <IKaart> kaarten;
    private List <IDoelpunt> doelpunten;
    private List <IWissel> wissels;
    private IScheidsrechter referee;

    public Match(int id, int speeldag, Date datum, Time uur, int aantalToeschouwers, IClub thuisploeg, IClub uitploeg, List<IVoetballer> thuisspelers, List<IVoetballer> uitspelers, List<IKaart> kaarten, List<IDoelpunt> doelpunten, List<IWissel> wissels, IScheidsrechter referee) {
        this.id = id;
        this.speeldag = speeldag;
        this.datum = datum;
        this.uur = uur;
        this.aantalToeschouwers = aantalToeschouwers;
        this.thuisploeg = thuisploeg;
        this.uitploeg = uitploeg;
        this.thuisspelers = thuisspelers;
        this.uitspelers = uitspelers;
        this.kaarten = kaarten;
        this.doelpunten = doelpunten;
        this.wissels = wissels;
        this.referee = referee;
    }
    
    public int getId() {
        return id;
    }

    public int getSpeeldag() {
        return speeldag;
    }

    public IClub getThuisploeg() {
        return thuisploeg;
    }

    public IClub getUitploeg() {
        return uitploeg;
    }

    public IScheidsrechter getScheidsrechter() {
        return referee;
    }

    public Date getDatum() {
        return datum;
    }

    public Time getTime() {
        return uur;
    }

    public int getAantalToeschouwers() {
        return aantalToeschouwers;
    }

    public List<IVoetballer> getThuisPloegSpelers() {
        return thuisspelers;
    }

    public List<IVoetballer> getUitPloegSpelers() {
        return uitspelers;
    }

    public List<IKaart> getKaarten() {
        return kaarten;
    }

    public List<IDoelpunt> getDoelpunten() {
        return doelpunten;
    }

    public List<IWissel> getWissels() {
        return wissels;
    }

}
