/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package be.hogent.iii.concerten.bo;

import be.hogent.iii.concerten.interfaces.IDataStorage;
import be.hogent.iii.concerten.interfaces.IConcert;
import be.hogent.iii.concerten.interfaces.IPersoon;
import be.hogent.iii.concerten.interfaces.IReservatie;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 *
 * @author kvdw
 */
public class DataStorage implements IDataStorage {

    private Map<String, IPersoon> personen;
    private Map<String, IConcert> concerten;
    private Map<String, Collection<IReservatie>> reservaties;

    public DataStorage() {

        personen = new HashMap<String, IPersoon>();
        concerten = new HashMap<String, IConcert>();
        reservaties = new HashMap<String, Collection<IReservatie>>();

        Persoon p;
        for (int i = 0; i < 10000; i++) {
            p = new Persoon("voornaam" + i, "familienaam" + i, "log" + i, "wachtwoord" + i,false);
            personen.put("log" + i, p);
        }
        p = new Persoon("Admin","admin","admin","admin",true);
        personen.put("admin", p);
        Concert c;
        Random r = new Random();
        for (int i = 0; i < 10000; i++) {
            int aantal = r.nextInt(100000);
            double prijs = r.nextDouble() * 100;

            Calendar cal = Calendar.getInstance();
            c = new Concert("naam" + i, new Date(cal.getTimeInMillis()+Math.abs(r.nextLong())/ 100000000), aantal, prijs, "plaats" + i);
            concerten.put("naam" + i, c);
        }

        Reservatie res;
        Collection<IReservatie> lijst;
        for (int i = 0; i < 1000; i++) {
            int naam = r.nextInt(1000);
            int concert = r.nextInt(10000);
            int aantal = r.nextInt(9)+1;
            res = new Reservatie(personen.get("log" + naam), concerten.get("naam" + concert), aantal);
            System.out.println("naam"+naam);
            if (reservaties.containsKey("log" + naam)) {
                lijst = reservaties.get("log" + naam);
            } else {
                lijst = new ArrayList<IReservatie>();
                reservaties.put("log" + naam, lijst);
            }
            lijst.add(res);
        }

    }

    public Collection<IPersoon> getPersonen() {
        return personen.values();
    }

    public Collection<IConcert> getConcerten() {
        return concerten.values();
    }

    public Collection<IReservatie> getReservatiesPersoon(String persoon) {
        return reservaties.get(persoon);
    }

    public Collection<IReservatie> getReservatiesConcert(String naam) {

        Collection<Collection<IReservatie>> lijstReservaties = reservaties.values();

        Collection<IReservatie> resultaat = new ArrayList<IReservatie>();

        for (Collection<IReservatie> r : lijstReservaties) {
            for (IReservatie reservatie : r) {
                if (reservatie.getConcert().getConcertnaam().equals(naam)) {
                    resultaat.add(reservatie);
                }
            }
        }

        return resultaat.size() != 0 ? resultaat : null;

    }

    public IPersoon getPersoon(String login) {
        return personen.get(login);
    }

    public IConcert getConcert(String naam) {
        return concerten.get(naam);
    }

    public IReservatie getReservatie(String persoonnaam, String concertnaam) {

        IReservatie reservatie = null;

        Collection<IReservatie> lijst = reservaties.get(persoonnaam);

        if (lijst != null) {

            for (IReservatie r : lijst) {
                if (r.getConcert().getConcertnaam().equals(concertnaam)) {
                    reservatie = r;
                }
            }

        }

        return reservatie;

    }

    public boolean addConcert(String naam, Date datum, int capaciteit, double prijs, String plaats) {
        boolean resultaat = false;
        if (!concerten.containsKey(naam)) {
            concerten.put(naam, new Concert(naam, datum, capaciteit, prijs, plaats));
            resultaat = true;
        }
        return resultaat;
    }

    public boolean addPersoon(String login,String voornaam,String familienaam,String wachtwoord) {
        boolean resultaat = false;
        if (!personen.containsKey(login)) {
            personen.put(login,new Persoon(voornaam,familienaam,login,wachtwoord,false));
            resultaat = true;
        }

        return resultaat;
    }

    public boolean addReservatie (String persoonnaam, String concert, int aaantal) {
        boolean resultaat = false;
        IPersoon p = personen.get(persoonnaam);
        IConcert c = concerten.get(concert);
        if (getReservatie(persoonnaam, concert)==null && p !=null && c !=null) {
            Collection <IReservatie> lijst;
            if (reservaties.containsKey(persoonnaam)) {
                lijst = reservaties.get(persoonnaam);
            } else {
                lijst = new ArrayList<IReservatie>();
                reservaties.put(persoonnaam, lijst);
            }
            lijst.add(new Reservatie(p, c, aaantal));
            resultaat = true;
        }
        return resultaat;
    }

    public boolean deletePersoon (String login) {

        reservaties.remove(login);

        return personen.remove(login) != null;

    }

    public boolean deleteConcert (String concert) {

        return concerten.remove(concert)!=null;

    }

    public boolean deleteReservatie (String persoon, String concert) {

        if (reservaties.containsKey(persoon)) {
            boolean resultaat = false;
            for(IReservatie r : reservaties.get(persoon)) {
                if (r.getConcert().getConcertnaam().equals(concert))
                    resultaat = reservaties.get(persoon).remove(r);
            }
            return resultaat;
        }
        else
            return false;

    }

}
