/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package be.hogent.iii.concerten.interfaces;

import be.hogent.iii.concerten.interfaces.IConcert;
import be.hogent.iii.concerten.interfaces.IPersoon;
import be.hogent.iii.concerten.interfaces.IReservatie;
import java.util.Collection;
import java.util.Date;

/**
 *
 * @author kvdw
 */
public interface IDataStorage {

    boolean addConcert(String naam, Date datum, int capaciteit, double prijs, String plaats);

    boolean addPersoon(String login, String voornaam, String familienaam, String wachtwoord);

    boolean addReservatie(String persoonnaam, String concert, int aaantal);

    boolean deleteConcert(String concert);

    boolean deletePersoon(String login);

    boolean deleteReservatie(String persoon, String concert);

    IConcert getConcert(String naam);

    Collection<IConcert> getConcerten();

    Collection<IPersoon> getPersonen();

    IPersoon getPersoon(String login);

    IReservatie getReservatie(String persoonnaam, String concertnaam);

    Collection<IReservatie> getReservatiesConcert(String naam);

    Collection<IReservatie> getReservatiesPersoon(String persoon);

}
