using System;
using System.Text;

namespace Be.Hogent.III.Keuken
{
	/// <summary>
	/// 
	/// </summary>
	public class Koelkast
	{       
		private Keuken keuken = null;
		private Dier inhoud = null;
		private bool deuropen = false;
		private string koelkastId = null;
		private int slijtage = 0;
    
		/// <summary>
		/// Creates a new instance of Koelkast.
		/// </summary>
		/// <param name="p_id"></param>
		/// <param name="p_keuken"></param>
		public Koelkast(string id,Keuken keuken) 
		{ 
			koelkastId = id;
			this.keuken = keuken;
		}
    
		public String Id 
		{
			get 
			{
				return koelkastId;
			}
		}
		public bool BevatDier(Dier dier) 
		{
			return inhoud==dier;
		}
    
		public void OpenDeur() 
		{
			if (deuropen) 
			{
				Error("deur reeds open");
			} 
			else 
			{
				deuropen=true;
				Log("deur open");
			}
		}
    
		public void SluitDeur() 
		{
			if (deuropen) 
			{
				deuropen=false;
				Log("deur dicht");
			} 
			else 
			{
				Error("deur reeds gesloten");
			}
		}    
    
		/// <summary>
		///  Laat het dier dat actief/geselecteerd is in de keuken 
		///  binnen.
		/// </summary>
		public void LaatBinnen() 
		{
			Dier dier = keuken.GetActiefDier();
			if (dier == null) 
			{
				Error("geen dier actief");
			}
			else if (inhoud!=null) 
			{
				Error("reeds bezet door "+inhoud+", "+dier+" kan er niet in");
			} 
			else if (!deuropen) 
			{
				Error("deur is gesloten, "+dier+" kan er niet in");
			} 
			else if (!keuken.IsDierInKeuken(dier)) 
			{
				Error(dier+" zit in een andere koelkast");
			} 
			else 
			{
				inhoud = dier;
				Log(dier+" er in");
			}
		}
		/// <summary>
		///  Laat het dier dat actief/geselecteerd is in de koelkast 
		///  buiten.
		/// </summary>
		public void LaatBuiten() 
		{
			Dier dier = keuken.GetActiefDier();
			if (dier == null) 
			{
				Error("geen dier actief");
			}
			else if (inhoud!=dier) 
			{
				Error(dier+" zit er niet in en kan er niet uit");
			} 
			else if (!deuropen) 
			{
				Error("deur is gesloten, "+dier+" kan er niet uit");
			} 
			else 
			{
				inhoud = null;
				Log(dier+" er uit");
			}
		}
    
		void Log(string msg) 
		{
			Console.WriteLine((slijtage++)+"\t[koelkast "+koelkastId+"] "+msg);
		} 

		void Error(string msg) 
		{
			throw new Exception(koelkastId+": "+msg);
		}

		public override string ToString() 
		{
			return "Koelkast "+koelkastId
				+ " (" 
				+ "deur " + (deuropen?"open":"dicht") 
				+ ", " + (inhoud==null?"geen dier":inhoud.ToString()) 
				+ ")";
		}

	}
}
