using System;
using System.Collections;

namespace Be.Hogent.III.Keuken
{
	public delegate void ScenarioOpdracht();

	/// <summary>
	/// Summary description for KeukenApplicatie.
	/// </summary>
	class Scenario
	{
		public static readonly string USAGE = 
		      "Welkom in de keuken, typ een van de volgende commando's\n"
			+ "  koelkastId diernaam ['in'|'uit']\n"
			+ "         : voeg actie toe aan scenario : plaats dier in of uit een koelkast\n"
			+ "  koelkastId 'deur' ['open'|'dicht']\n"
			+ "         : voeg actie toe aan scenario : open of sluit een koelkastdeur\n"
			+ "  start  : voer scenario uit\n"    
			+ "  reset  : wis scenario\n"
			+ "  toon   : toon keuken\n"
			+ "  exit   : verlaat programma";

		private Keuken keuken = new Keuken();

		private ScenarioOpdracht opdrachten = null;

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{			
			try {
				Scenario scenario = new Scenario();
				Console.Write(">");
				Console.WriteLine(USAGE);
				Console.Write(">");
				string line = Console.In.ReadLine();
				while(line != "exit") {
					scenario.Verwerk(line);
					Console.Write(">");
					line = Console.In.ReadLine();
				}        
			} catch (Exception e) {
				Console.WriteLine(e.StackTrace);
			}
		}

		    
		/// <summary>
		/// Verwerkt een lijn ingevoerd in het console-venster.
		/// </summary>
		/// <param name="line"></param>
		public void Verwerk(string line) 
		{
			if (line.StartsWith("reset")) 
			{
				Reset();
			} 
			else if (line.StartsWith("start")) 
			{
				VoerOpdrachtenUit();
			} 
			else if (line.StartsWith("toon")) 
			{
				Console.WriteLine(keuken.ToString());
			} 
			else 
			{            
				string[] args = line.Split(' ');
				if (args.Length < 3) 
				{
					Console.WriteLine(USAGE);
				} 
				else 
				{
					Koelkast koelkast = keuken.GetKoelkast(args[0]);
					string slachtoffer = args[1];
					string actie = args[2];
					VerwerkScenarioOpdrachtOfLuisteraar(koelkast,slachtoffer,actie);
				}
			}
		}

		/// <summary>
		/// Verwerkt een lijn ingegeven in het console-venster, die
		/// begint met een koelkast.
		/// </summary>
		/// <param name="koelkast"></param>
		/// <param name="slachtoffer"></param>
		/// <param name="actie"></param>
		public void VerwerkScenarioOpdrachtOfLuisteraar(Koelkast koelkast,string slachtoffer,string actie) 
		{
			// tweede woordje: deur
			if ("deur".Equals(slachtoffer)) 
			{
				if ("open".Equals(actie)) 				
					opdrachten += new ScenarioOpdracht(koelkast.OpenDeur);				 
				else if ("dicht".Equals(actie)) 				
					opdrachten += new ScenarioOpdracht(koelkast.SluitDeur);				 
				else 				
					Console.WriteLine(USAGE);        				
			}
				// tweede woordje: een dier
			else if ("in".Equals(actie) || "uit".Equals(actie)) 
			{
				Dier dier = keuken.GetDier(slachtoffer);
				//opdrachten += new ScenarioOpdracht(dier.MaakActief);
                opdrachten += dier.MaakActief;
				try 
				{
					if ("in".Equals(actie)) 
						opdrachten += new ScenarioOpdracht(koelkast.LaatBinnen);
					else if ("uit".Equals(actie)) 
						opdrachten += new ScenarioOpdracht(koelkast.LaatBuiten);
					else 				
						Console.WriteLine(USAGE);        				
				} 
				finally 
				{
					opdrachten += new ScenarioOpdracht(dier.MaakInactief);
				}							
			} 
			else 
			{
				Console.WriteLine(USAGE);        
			}                    
		}


		/// <summary>
		/// Opdrachten leeg maken
		/// </summary>
		public void Reset() 
		{
			opdrachten = null;
		}

		/// <summary>
		/// Opdrachten uitvoeren.
		/// </summary>
		public void VoerOpdrachtenUit() 
		{
			if (opdrachten != null) 
			{
				try 
				{					
					opdrachten();
				} 
				catch (Exception e) 
				{
					Dier dier = keuken.GetActiefDier();
					if (dier != null)
						dier.MaakInactief();
					Console.WriteLine("senario voortijdig gestopt " + e.Message);
				} 
				finally 
				{
					Reset();
				}
			}
		}
	}
}
