using System;
using System.Collections;
using System.Text;

namespace Be.Hogent.III.Keuken
{
	/// <summary>
	/// 
	/// </summary>
	public class Keuken
	{
		private Hashtable dieren = new Hashtable();    
		private Hashtable koelkasten = new Hashtable();

		public Keuken()
		{
			// 
			// TODO: Add constructor logic here
			//
		}
		
            
		public Koelkast GetKoelkast(string koelkastId) 
		{
			Koelkast koelkast = (Koelkast)koelkasten[koelkastId];
			if (koelkast==null) 
			{
				koelkast = new Koelkast(koelkastId,this);
				koelkasten[koelkastId] = koelkast;
			} 
			return koelkast;
		}
    
		public Dier GetDier(string diernaam) 
		{
			Dier dier = (Dier)dieren[diernaam];
			if (dier==null) 
			{
				dier = new Dier(diernaam);
				dieren[diernaam] = dier;
			} 
			return dier;        
		}
    
		public bool IsDierInKeuken(Dier dier) 
		{
			bool inKoelkast = false;
			IEnumerator it = koelkasten.Values.GetEnumerator();
			while (it.MoveNext() && !inKoelkast)
			{
				inKoelkast = ((Koelkast)it.Current).BevatDier(dier);
			}
			return !inKoelkast;
		}

		public Dier GetActiefDier() 
		{
			bool gevonden = false;
			Dier actiefDier = null;
			IEnumerator it = dieren.Values.GetEnumerator();
			while (it.MoveNext() && !gevonden)
			{
				actiefDier = (Dier)it.Current;
				gevonden = actiefDier.Actief;
			}
			return gevonden?actiefDier:null;
		}
    
		public override string ToString() 
		{
			StringBuilder buffer = new StringBuilder();
			IEnumerator it = koelkasten.Values.GetEnumerator();
			while (it.MoveNext())
			{
				buffer.Append("\t").Append(it.Current).Append("\n");
			}
			it = dieren.Values.GetEnumerator(); 
			while (it.MoveNext())
			{
				Dier dier = (Dier)it.Current;
				if (IsDierInKeuken(dier)) 
				{
					buffer.Append("\tDier in keuken: ").Append(dier).Append("\n");
				}
			}
			return buffer.ToString();
		}
    
	}
}
