using System;
using System.Text;

namespace Be.Hogent.III.Keuken
{
	/// <summary>
	/// 
	/// </summary>
	public class Koelkast
	{       
		private Keuken keuken = null;
		private Dier inhoud = null;
		private bool deuropen = false;
		private string koelkastId = null;

		public event KoelkastEventHandler Executing;
		public event KoelkastEventHandler Executed;
    
		/// <summary>
		/// Creates a new instance of Koelkast.
		/// </summary>
		/// <param name="p_id"></param>
		/// <param name="p_keuken"></param>
		public Koelkast(string id,Keuken keuken) 
		{ 
			koelkastId = id;
			this.keuken = keuken;
		}
    
		public String Id 
		{
			get 
			{
				return koelkastId;
			}
		}
		public bool BevatDier(Dier dier) 
		{
			return inhoud==dier;
		}
    
		public void OpenDeur() 
		{
			OnExecuting(new KoelkastEventArgs(Actie.DeurOpen,null));
			if (deuropen) 
			{
				Error("deur reeds open");
			} 
			else 
			{
				deuropen=true;
			}
			OnExecuted(new KoelkastEventArgs(Actie.DeurOpen,null));
		}
    
		public void SluitDeur() 
		{
			OnExecuting(new KoelkastEventArgs(Actie.DeurDicht,null));
			if (deuropen) 
			{
				deuropen=false;
			} 
			else 
			{
				Error("deur reeds gesloten");
			}
			OnExecuted(new KoelkastEventArgs(Actie.DeurDicht,null));
		}    
    
		public void LaatBinnen() 
		{
			OnExecuting(new KoelkastEventArgs(Actie.DierIn,null));
			Dier dier = keuken.GetActiefDier();
			if (dier == null) 
			{
				Error("geen dier actief");
			}
			else if (inhoud!=null) 
			{
				Error("reeds bezet door "+inhoud+", "+dier+" kan er niet in");
			} 
			else if (!deuropen) 
			{
				Error("deur is gesloten, "+dier+" kan er niet in");
			} 
			else if (!keuken.IsDierInKeuken(dier)) 
			{
				Error(dier+" zit in een andere koelkast");
			} 
			else 
			{
				inhoud = dier;
			}
			OnExecuted(new KoelkastEventArgs(Actie.DierIn,dier));
		}
    
		public void LaatBuiten() 
		{
			OnExecuting(new KoelkastEventArgs(Actie.DierUit,null));
			Dier dier = keuken.GetActiefDier();
			if (dier == null) 
			{
				Error("geen dier actief");
			}
			else if (inhoud!=dier) 
			{
				Error(dier+" zit er niet in en kan er niet uit");
			} 
			else if (!deuropen) 
			{
				Error("deur is gesloten, "+dier+" kan er niet uit");
			} 
			else 
			{
				inhoud = null;
			}
			OnExecuted(new KoelkastEventArgs(Actie.DierUit,dier));
		}
    
		void Error(string msg) 
		{
			throw new Exception(koelkastId+": "+msg);
		}

		public override string ToString() 
		{
			return "Koelkast "+koelkastId
				+ " (" 
				+ "deur " + (deuropen?"open":"dicht") 
				+ ", " + (inhoud==null?"geen dier":inhoud.ToString()) 
				+ ")";
		}
    
		protected virtual void OnExecuting(KoelkastEventArgs e) 
		{
			if (Executing != null)
				Executing(this,e);
		}
		protected virtual void OnExecuted(KoelkastEventArgs e) 
		{
			if (Executed != null)
				Executed(this,e);
		}

	}
}
