using System;
using System.Collections;

namespace Be.Hogent.III.Keuken
{
	public delegate void ScenarioOpdracht();

	/// <summary>
	/// Summary description for KeukenApplicatie.
	/// </summary>
	class Scenario
	{
		public static readonly string USAGE = 
		      "Welkom in de keuken, typ een van de volgende commando's\n"
			+ "  koelkastId diernaam ['in'|'uit']\n"
			+ "         : voeg actie toe aan scenario : plaats dier in of uit een koelkast\n"
			+ "  koelkastId 'deur' ['open'|'dicht']\n"
			+ "         : voeg actie toe aan scenario : open of sluit een koelkastdeur\n"
			+ "  koelkastId ['bel|'lamp'|'bieper'|...] ['erbij'|'weg']\n"
			+ "         : voeg luisteraar toe aan (of verwijder van) een koelkast\n"
			+ "  start  : voer scenario uit\n"    
			+ "  reset  : wis scenario\n"
			+ "  toon   : toon keuken\n"
			+ "  exit   : verlaat programma";

		private Keuken keuken = new Keuken();
		private Hashtable luisteraars = new Hashtable();

		private ScenarioOpdracht opdrachten = null;

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{			
			try {
				Scenario scenario = new Scenario();
				Console.Write(">");
				Console.WriteLine(USAGE);
				Console.Write(">");
				string line = Console.In.ReadLine();
				while(line != "exit") {
					scenario.Verwerk(line);
					Console.Write(">");
					line = Console.In.ReadLine();
				}        
			} catch (Exception e) {
				Console.WriteLine(e.StackTrace);
			}
		}

		    
		public void Verwerk(string line) 
		{
			if (line.StartsWith("reset")) 
			{
				Reset();
			} 
			else if (line.StartsWith("start")) 
			{
				VoerOpdrachtenUit();
			} 
			else if (line.StartsWith("toon")) 
			{
				Console.WriteLine(keuken.ToString());
			} 
			else 
			{            
				String[] args = line.Split(' ');
				if (args.Length < 3) 
				{
					Console.WriteLine(USAGE);
				} 
				else 
				{
					Koelkast koelkast = keuken.GetKoelkast(args[0]);
					String slachtoffer = args[1];
					String actie = args[2];
					VerwerkScenarioOpdrachtOfLuisteraar(koelkast,slachtoffer,actie);
				}
			}
		}

		public void VerwerkScenarioOpdrachtOfLuisteraar(Koelkast koelkast,string slachtoffer,string actie) 
		{
			if ("deur".Equals(slachtoffer)) 
			{
				if ("open".Equals(actie)) 				
					opdrachten += new ScenarioOpdracht(koelkast.OpenDeur);				 
				else if ("dicht".Equals(actie)) 				
					opdrachten += new ScenarioOpdracht(koelkast.SluitDeur);				 
				else 				
					Console.WriteLine(USAGE);        				
			}
			else if ("in".Equals(actie) || "uit".Equals(actie)) 
			{
				Dier dier = keuken.GetDier(slachtoffer);
				opdrachten += new ScenarioOpdracht(dier.MaakActief);
				try 
				{
					if ("in".Equals(actie)) 
						opdrachten += new ScenarioOpdracht(koelkast.LaatBinnen);
					else if ("uit".Equals(actie)) 
						opdrachten += new ScenarioOpdracht(koelkast.LaatBuiten);
					else 				
						Console.WriteLine(USAGE);        				
				} 
				finally 
				{
					opdrachten += new ScenarioOpdracht(dier.MaakInactief);
				}							
			} 
			else if ("erbij".Equals(actie) || "weg".Equals(actie) ) 
			{
				KoelkastLuisteraar kl = GetLuisteraar(slachtoffer);						
				if (actie.Equals("erbij")) 
				{
					koelkast.Executing += 
                        new KoelkastEventHandler(kl.Koelkast_Executing);
					koelkast.Executed += new KoelkastEventHandler(kl.Koelkast_Executed);
				}
				else if (actie.Equals("weg")) 
				{
					koelkast.Executing -= new KoelkastEventHandler(kl.Koelkast_Executing);
					koelkast.Executed -= new KoelkastEventHandler(kl.Koelkast_Executed);
				}
				else 				
					Console.WriteLine(USAGE);        				

			}
			else 
			{
				Console.WriteLine(USAGE);        
			}                    
		}

		public KoelkastLuisteraar GetLuisteraar(string luisteraarId) 
		{
			KoelkastLuisteraar kl = (KoelkastLuisteraar)luisteraars[luisteraarId];
			if (kl==null) 
			{
				if ("lamp" == luisteraarId) 
					kl = new Lamp(luisteraarId);
				else if ("bieper" == luisteraarId)
					kl = new Bieper(luisteraarId);
				else if ("bel" == luisteraarId)
					kl = new Bel(luisteraarId);
				else 
					kl = new StandaardKoelkastLuisteraar(luisteraarId);
				luisteraars[luisteraarId] = kl;
			} 
			return kl;
		}

		public void Reset() 
		{
			opdrachten = null;
		}

		public void VoerOpdrachtenUit() 
		{
			if (opdrachten != null) 
			{
				try 
				{					
					opdrachten();
				} 
				catch (Exception e) 
				{
					Dier dier = keuken.GetActiefDier();
					if (dier != null)
						dier.MaakInactief();
					Console.WriteLine("senario voortijdig gestopt " + e.Message);
				} 
				finally 
				{
					Reset();
				}
			}
		}

	}
}
