using System;

namespace Be.Hogent.III.Keuken
{
	/// <summary>
	/// 
	/// </summary>
	public class StandaardKoelkastLuisteraar: KoelkastLuisteraar
	{
		private string naam;
		public StandaardKoelkastLuisteraar(string naam)
		{
			this.naam = naam;
		}

		public void Koelkast_Executing(object sender, KoelkastEventArgs e) 
		{
			Console.Write("[luisteraar" + naam + "] ");
			if (e.Actie == Actie.DeurOpen) 
				Console.WriteLine(((Koelkast)sender).Id+ " start openen deur");
			else if (e.Actie == Actie.DeurDicht)
				Console.WriteLine(((Koelkast)sender).Id+ " start sluiten deur");
			else if (e.Actie == Actie.DierIn)
				Console.WriteLine(((Koelkast)sender).Id+ " start binnen laten dier");
			else if (e.Actie == Actie.DierUit)
				Console.WriteLine(((Koelkast)sender).Id+ " start buiten laten "+ e.DierInActie);
			else 
				Console.WriteLine(((Koelkast)sender).Id+ " onbekende actie");
		}

		public void Koelkast_Executed(object sender, KoelkastEventArgs e) 
		{
			Console.Write("[luisteraar" + naam + "] ");
			if (e.Actie == Actie.DeurOpen) 
				Console.WriteLine(((Koelkast)sender).Id+ " deur is open");
			else if (e.Actie == Actie.DeurDicht)
				Console.WriteLine(((Koelkast)sender).Id+ " deur is dicht");
			else if (e.Actie == Actie.DierIn)
				Console.WriteLine(((Koelkast)sender).Id+ " liet " + e.DierInActie + " binnen");
			else if (e.Actie == Actie.DierUit)
				Console.WriteLine(((Koelkast)sender).Id+ " liet " + e.DierInActie+ " buiten ");
			else 
				Console.WriteLine(((Koelkast)sender).Id+ " onbekende actie");
		}
	}
}
