using System;
using System.Data;
using System.Data.Common;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

/// <summary>
/// Summary description for GegevensFabriek
/// </summary>
public class GegevensFabriek
{
    public GegevensFabriek()
    {

    }

    public string[] GetCategorieen()
    {
        string[] categorieen = { "Sport", "Muziek", "Actualiteit", "Geschiedenis" };
        return categorieen;
    }

    public Dictionary<string, string> GetMaaltijden()
    {

        Dictionary<string, string> maaltijden = new Dictionary<string, string>();
        maaltijden.Add("ONT", "ontbijt");
        maaltijden.Add("10U", "tienuurtje");
        maaltijden.Add("MID", "middagmaal");
        maaltijden.Add("16U", "vieruurtje");
        maaltijden.Add("AVO", "avondmaal");
        return maaltijden;
    }

    public Dictionary<string, Land> GetLanden()
    {
        Dictionary<string, Land> landen = new Dictionary<string, Land>();
        string[] codes = { "BE", "NL", "FR" };
        string[] namen = { "Belgi", "Nederland", "Frankrijk" };
        for (int i = 0; i < codes.Length; i++)
        {
            Land land = new Land(codes[i], namen[i]);
            landen.Add(land.Code, land);
        }
        return landen;
    }

    public DataTable GetBestellingen()
    {
        // configuratie ophalen
        ConnectionStringSettings configConn = 
            ConfigurationManager.ConnectionStrings["bestellingDB"];
        // factory aanmaken
        DbProviderFactory factory = 
            DbProviderFactories.GetFactory(configConn.ProviderName);
        // verbinding met de gegevensbank
        DbConnection conn = factory.CreateConnection();
        conn.ConnectionString = configConn.ConnectionString;
        // commando-object aanmaken
        DbCommand command = conn.CreateCommand();
        command.CommandText =
            ConfigurationManager.AppSettings["SELECT_BESTELLINGEN"];

        // DataAdapter aanmaken
        DbDataAdapter adapter = factory.CreateDataAdapter();
        adapter.SelectCommand = command;

        // DataSet aanmaken
        DataTable klantTabel = new DataTable("Bestellingen");

        // DataSet opvullen
        adapter.Fill(klantTabel);

        return klantTabel;
    }

}
