using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Lijsten : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
            vulLijstenOp();
    }

    private void vulLijstenOp()
    {
        GegevensFabriek data = new GegevensFabriek();

        // Categorien: tabel van strings
        KeuzeCategorie.DataSource = data.GetCategorieen();
        KeuzeCategorie.DataBind();

        // Maaltijden: naam/waarde-paren
        KeuzeEten.DataSource = data.GetMaaltijden();
        KeuzeEten.DataValueField = "Key";
        KeuzeEten.DataTextField = "Value";
        KeuzeEten.DataBind();
        // Landen: sleutel/object-paren
        KeuzeLand.DataSource = data.GetLanden();
        KeuzeLand.DataValueField = "Key";
        KeuzeLand.DataTextField = "Value";
        KeuzeLand.DataBind();
    }

    protected void KeuzeLand_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        ListControl lijst = ((ListControl)sender);
        string bericht = "Lijst " + lijst.ID;
        bericht += " index " + lijst.SelectedIndex;
        bericht += " item " + lijst.SelectedItem;
        bericht += " waarde " + lijst.SelectedValue + "\n";
        Overzicht.Text += bericht;
    }

    protected void KeuzeCategorie_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        ListControl lijst = ((ListControl)sender);
        foreach (ListItem item in lijst.Items)
        {
            if (item.Selected)
            {
                string bericht = "Lijst " + lijst.ID;
                bericht += " item " + item.Text;
                bericht += " waarde " + item.Value + "\n";
                Overzicht.Text += bericht;
            }
        }
    }
}
