/*
 * GeheugenCatalogus.java
 *
 * Created on 3 oktober 2005, 15:18
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package be.hogent.iii.boeken.implMemory;

import be.hogent.iii.boeken.bo.Boek;
import be.hogent.iii.boeken.bo.Catalogus;
import be.hogent.iii.boeken.bo.BoekNietBeschikbaarException;
import java.util.Map;
import java.util.HashMap;
/**
 *
 * @author vongenae
 */
public class GeheugenCatalogus implements Catalogus{
    private Boek[] boeken = null;
    
    /** Creates a new instance of GeheugenCatalogus */
    public GeheugenCatalogus() {
        String[] titel = {"Thinking in Java","Java Servlet Programming","Java Server Programming","The Java Tutorial","Java Swing"};
        double[] prijs = {58,36,81,65,55};
        boeken = new Boek[5];
        for (int i = 0; i < boeken.length; i++) {
            boeken[i] = new Boek(Integer.toString(i), titel[i], prijs[i]);
        }
    }
    
    public Boek[] getBoeken() {
        return boeken;
    }
    
    public Boek getBoek(String isbn) throws BoekNietBeschikbaarException {
        Boek boek = null;
        try {
            boek = boeken[Integer.parseInt(isbn)];
        } catch (NumberFormatException e) {
            throw new BoekNietBeschikbaarException(BoekNietBeschikbaarException.ISBNONGELDIG);
        } catch (Exception e) {
            throw new BoekNietBeschikbaarException(BoekNietBeschikbaarException.ISBNNIETBESCHIKBAAR);
        }
        return boek;
    }
    
    public Map<String,Boek> getBoekMap() {
        Map<String,Boek> mapBoeken = new HashMap<String,Boek>(5);
        for (int i = 0; i < boeken.length; i++)
            mapBoeken.put(boeken[i].getIsbn(), boeken[i]);
        return mapBoeken;
    }
    
}
