/*
 * BoekDetailServlet.java
 *
 * Created on 3 oktober 2005, 16:15
 */

package be.hogent.iii.boeken.web;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;
import be.hogent.iii.boeken.bo.*;

/**
 *
 * @author vongenae
 * @version
 */
public class BoekDetailServlet extends HttpServlet {
    
    public static final String ISBN = "isbn";
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, 
            HttpServletResponse response)
    throws ServletException, IOException {
        Catalogus catalogus = (Catalogus) getServletContext().
                getAttribute(AanmaakCatalogus.CATALOGUS);
        String isbn = request.getParameter(ISBN);
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Detail Boek</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h1>Boekgegevens</h1>");
        if (catalogus != null && isbn != null) {
            try {
                Boek boek = catalogus.getBoek(isbn);
                if (boek != null) {
                    out.println(boek.getIsbn() + " " 
                        + boek.getTitel() 
                        + " " + boek.getPrijs());
                } else {
                    out.println("Geen gegevens over het boek " 
                        + "met ISBN-nummer " + isbn);
                }
            } catch (BoekNietBeschikbaarException e) {
                out.print("Geen gegevens over het boek met ");
                out.print("ISBN-nummer ");
                out.print(isbn);
                out.println(". " + e.getMessage());
            }
        } else {
            out.println("ISBN-nummer of catalogus onbeschikbaar");
        }
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, 
            HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, 
            HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
