/*
 * OverzichtBoekenServlet.java
 *
 * Created on 3 oktober 2005, 15:54
 */

package be.hogent.iii.boeken.web;

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import be.hogent.iii.boeken.bo.*;

/**
 *
 * @author vongenae
 * @version
 */
public class OverzichtBoekenServlet extends HttpServlet {
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, 
            HttpServletResponse response)
    throws ServletException, IOException {
        Catalogus catalogus = (Catalogus) getServletContext().
                getAttribute(AanmaakCatalogus.CATALOGUS);
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Overzicht Boeken</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h1>Overzicht Boeken</h1>");
        if (catalogus != null) {
            Boek[] boeken = catalogus.getBoeken();
            out.println("Er zijn "+ boeken.length 
                    + " boeken beschikbaar");
            out.println("<ul>");
            for (int i = 0; i < boeken.length; i++) {
                out.println("<li>");
                out.println(boeken[i].getTitel());
                out.println("</li>");
            }
            out.println("</ul>");
        } else {
            out.println("Er zijn geen boeken beschikbaar.");
        }
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, 
            HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, 
            HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
