// TellerServlet.java (c) 2001 Veerle.Ongenae@hogent.be

package be.hogent.iii.servlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class TellerServlet extends HttpServlet {
    
    private static final String TELLER = "teller";
    
    public void doGet(HttpServletRequest request, 
            HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        
        out.println("<html>");
        out.println("<head><title>Teller</title></head>");
        out.println("<body>");
        out.println("Hallo!<br>");
        
        HttpSession sessie = request.getSession();
        Integer teller = (Integer)sessie.getAttribute(TELLER);
        if (teller == null) {
            out.println("Dit is een nieuwe sessie.");
            teller = new Integer(1);
        } else {
            teller = new Integer(teller.intValue() + 1);
            out.print("Welkom terug. ");
            out.print("Dit is uw ");
            out.print(teller);
            out.println("e bezoek");
        }
        sessie.setAttribute(TELLER,teller);
        
        out.close();
    }
}