package be.hogent.iii.xmlapp.bo.impl.DOM;


import be.hogent.iii.xmlapp.bo.impl.SAX.FoutAfhandeling;
import be.hogent.iii.xmlapp.bo.Auteur;
import be.hogent.iii.xmlapp.bo.Catalogus;
import be.hogent.iii.xmlapp.bo.Boek;
import be.hogent.iii.xmlapp.bo.impl.CatalogusUtil;
import be.hogent.iii.xmlapp.bo.impl.XMLCatalogus;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import java.io.File;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.ArrayList;


public class DOMCatalogus extends XMLCatalogus implements Catalogus {
    
    
    public DOMCatalogus(String bestand) throws ParserConfigurationException,
            SAXParseException, SAXException, IOException {
        super(bestand);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        parseBestand(bestand,factory);
    }
    
    public DOMCatalogus(String bestand, String schema)
    throws ParserConfigurationException, SAXParseException,
            SAXException, IOException {
        super(bestand);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setAttribute(CatalogusUtil.JAXP_SCHEMA_LANGUAGE,
                CatalogusUtil.W3C_XML_SCHEMA);
        factory.setAttribute(CatalogusUtil.JAXP_SCHEMA_SOURCE, new File(
                schema));
        parseBestand(bestand,factory);
        
    }
    private void parseBestand(String bestand, DocumentBuilderFactory factory) throws ParserConfigurationException, SAXParseException,
            SAXException, IOException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new FoutAfhandeling());
        Document document = builder.parse(new File(bestand));
        maakBoekenLijst(document);
    }
    
    private void maakBoekenLijst(Document document) {
        boeken = new ArrayList();
        NodeList boekKnopen = document.getElementsByTagName(CatalogusUtil.BOOK);
        for (int i = 0; i < boekKnopen.getLength(); i++) {
            Node boek = boekKnopen.item(i);
            boeken.add(maakBoekObject(boek));
        }
    }
    
    private Boek maakBoekObject(Node boekKnoop) {
        NodeList kinderen = boekKnoop.getChildNodes();
        String isbn = null, title = null;
        ArrayList<Auteur> auteurs = new ArrayList<Auteur>();
        for (int i = 0; i < kinderen.getLength(); i++) {
            Node kind = kinderen.item(i);
            if (kind.getNodeName().equals(CatalogusUtil.ISBN)) {
                isbn = kind.getFirstChild().getNodeValue();
            } else if (kind.getNodeName().equals(CatalogusUtil.TITLE)) {
                title = kind.getFirstChild().getNodeValue();
            } else if (kind.getNodeName().equals(CatalogusUtil.AUTEUR)) {
                auteurs.add(maakAuteurObject(kind));
            }
        }
        return new Boek(isbn, title, auteurs.toArray(new Auteur[0]));
    }
    
    private Auteur maakAuteurObject(Node auteurKnoop) {
        NodeList kinderen = auteurKnoop.getChildNodes();
        String name = null, initial = null;
        ArrayList<String> firstname = new ArrayList<String>();
        for (int i = 0; i < kinderen.getLength(); i++) {
            Node kind = kinderen.item(i);
            if (kind.getNodeName().equals(CatalogusUtil.NAME)) {
                name = kind.getFirstChild().getNodeValue();
            } else if (kind.getNodeName().equals(CatalogusUtil.INITIAL)) {
                initial = kind.getFirstChild().getNodeValue();
            } else if (kind.getNodeName().equals(CatalogusUtil.FIRSTNAME)) {
                firstname.add(kind.getFirstChild().getNodeValue());
            }
        }
        return new Auteur(name, initial, firstname.toArray(new String[0]));
    }
    
}