package be.hogent.iii.xmlapp.bo.impl.SAX;

import be.hogent.iii.xmlapp.bo.impl.CatalogusUtil;
import org.xml.sax.SAXException;
import org.xml.sax.ContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SAXCatalogusContentHandler extends SAXCatalogusHandler 
        implements ContentHandler {
    
    public SAXCatalogusContentHandler() {
        super();
    }
    
    public void setDocumentLocator(Locator locator) {
    }
    
    public void startDocument() throws SAXException {
    }
    
    public void endDocument() throws SAXException {
    }
    
    public void startPrefixMapping(String prefix, String uri)
    throws SAXException {
    }
    
    public void endPrefixMapping(String prefix) throws SAXException {
    }
    
    public void startElement(String namespaceURI, String localName,
            String qualifiedName, Attributes atts) throws SAXException {
        naamLaatsteElement = qualifiedName;
        if (qualifiedName.equals(CatalogusUtil.BOOK))
            startBoekElement();
        else if (qualifiedName.equals(CatalogusUtil.AUTEUR))
            startAuteurElement();
    }
    
    public void endElement(String namespaceURI, String localName,
            String qualifiedName) throws SAXException {
        if (qualifiedName.equals(CatalogusUtil.BOOK))
            endBoekElement();
        else if (qualifiedName.equals(CatalogusUtil.AUTEUR))
            endAuteurElement();
    }
    
    public void characters(char[] text, int start, int length)
    throws SAXException {
        if (naamLaatsteElement.equals(CatalogusUtil.ISBN))
            setIsbnTekst(text, start, length);
        else if (naamLaatsteElement.equals(CatalogusUtil.TITLE))
            setTitleTekst(text, start, length);
        else if (naamLaatsteElement.equals(CatalogusUtil.NAME))
            setNameTekst(text, start, length);
        else if (naamLaatsteElement.equals(CatalogusUtil.INITIAL))
            setInitialTekst(text, start, length);
        else if (naamLaatsteElement.equals(CatalogusUtil.FIRSTNAME))
            setFirstnameTekst(text, start, length);
    }
    
    public void ignorableWhitespace(char[] text, int start, int length)
    throws SAXException {
    }
    
    public void processingInstruction(String target, String data)
    throws SAXException {
    }
    
    public void skippedEntity(String name) throws SAXException {
    }
}