package be.hogent.iii.xmlapp.bo.impl;

import be.hogent.iii.xmlapp.bo.Auteur;
import be.hogent.iii.xmlapp.bo.Catalogus;
import be.hogent.iii.xmlapp.bo.Boek;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.util.ArrayList;
import java.util.Iterator;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

public abstract class XMLCatalogus implements Catalogus {
    protected ArrayList<Boek> boeken = new ArrayList<Boek>();
    
    private String bestand;
    
    public XMLCatalogus(String bestand) {
        this.bestand = bestand;
    }
    
    private void schrijfBoekenNaarDocument(Document document) {
        Iterator<Boek> loper = boeken.iterator();
        Element knoop = document.createElement(CatalogusUtil.BOOKS);
        document.appendChild(knoop);
        while (loper.hasNext()) {
            Boek boek = loper.next();
            document.getDocumentElement().
                    appendChild(maakBoekKnoop(boek, document));
        }
        
    }
    
    private Element maakBoekKnoop(Boek boek, Document document) {
        Element boekKnoop = document.createElement(CatalogusUtil.BOOK);
        
        Element isbnKnoop = document.createElement(CatalogusUtil.ISBN);
        isbnKnoop.appendChild(document.createTextNode(boek.getIsbn()));
        boekKnoop.appendChild(isbnKnoop);
        
        Element titleKnoop = document.createElement(CatalogusUtil.TITLE);
        titleKnoop.appendChild(document.createTextNode(boek.getTitle()));
        boekKnoop.appendChild(titleKnoop);
        
        Auteur[] auteurs = boek.getAuthor();
        for (int i = 0; i < auteurs.length; i++) {
            boekKnoop.appendChild(maakAuteurKnoop(auteurs[i], document));
        }
        
        return boekKnoop;
    }
    
    private Element maakAuteurKnoop(Auteur auteur, Document document) {
        Element auteurKnoop = document.createElement(CatalogusUtil.AUTEUR);
        
        Element nameKnoop = document.createElement(CatalogusUtil.NAME);
        nameKnoop.appendChild(document.createTextNode(auteur.getName()));
        auteurKnoop.appendChild(nameKnoop);
        
        if (auteur.getInitial() != null) {
            Element initialKnoop = document
                    .createElement(CatalogusUtil.INITIAL);
            initialKnoop.appendChild(document.createTextNode(auteur
                    .getInitial()));
            auteurKnoop.appendChild(initialKnoop);
        }
        
        String[] firstnames = auteur.getFirstname();
        for (int i = 0; i < firstnames.length; i++) {
            String firstname = firstnames[i];
            Element firstnameKnoop = document
                    .createElement(CatalogusUtil.FIRSTNAME);
            firstnameKnoop.appendChild(document.createTextNode((firstname)));
            auteurKnoop.appendChild(firstnameKnoop);
        }
        
        return auteurKnoop;
    }
    
    public void schrijfCatalogus(String bestand) throws IOException,
            TransformerConfigurationException, ParserConfigurationException,
            TransformerException {
        schrijfCatalogus(new FileOutputStream(bestand));
    }
    
    public void schrijfCatalogus(OutputStream out)
    throws TransformerConfigurationException,
            ParserConfigurationException, TransformerException {
        DocumentBuilderFactory factory = 
                DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        schrijfBoekenNaarDocument(document);
        TransformerFactory tFactory = 
                TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
    }
    
    public Boek[] geefBoeken() {       
        return boeken.toArray(new Boek[0]);
    }
    
    public void voegBoekToe(Boek boek) {
        boeken.add(boek);
    }
    
    public void sluitEnBewaar() throws IOException {
        try {
            schrijfCatalogus(bestand);
        } catch (TransformerException e) {
            throw new IOException(e.getMessage());
        } catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }
}