using System;
using System.Collections.Generic;
using System.Text;
using System.Data.Common;
using System.Configuration;
using System.Data;

namespace vbAdo
{
    class BestellingBeheer
    {
        const String TABEL_BESTELLING = "Bestellingen";
        const String DS_ORDERS = "klantOrders";
		private const string MIN="@min";

        private ConnectionStringSettings connStringSet;
        private DbProviderFactory factory;

        public BestellingBeheer(ConnectionStringSettings connStringSet)
        {
            this.connStringSet = connStringSet;
            factory = DbProviderFactories.GetFactory(connStringSet.ProviderName);
        }

        protected DbConnection GetConnection()
        {
            DbConnection connection = 
                factory.CreateConnection();
            connection.ConnectionString = 
                connStringSet.ConnectionString;

            return connection;
        }

        public DataSet GetBestellingenMetDataReader()
        {
            // structuur DataSet vastleggen
            DataSet klantDS = new DataSet(DS_ORDERS);
            DataTable tabelBestel = klantDS.Tables.Add(TABEL_BESTELLING);
            tabelBestel.Columns.Add("BestelID", typeof(Int32));
            tabelBestel.Columns.Add("Hoeveelheid", typeof(Int32));
            tabelBestel.Columns.Add("Firma", typeof(string));

            // verbinding met de gegevensbank
            DbConnection conn = GetConnection();
            // commando-object aanmaken
            DbCommand command = conn.CreateCommand();
            command.CommandText = 
                ConfigurationManager.AppSettings["SELECT_BESTELLINGEN"];
            // zoekopdracht uitvoeren
            conn.Open();
            try
            {
                DbDataReader reader = 
                    command.ExecuteReader();
                while (reader.Read())
                {
                    DataRow rij = tabelBestel.NewRow();
                    rij[0] = reader["BestelID"];
                    rij[1] = reader[1];
                    rij[2] = reader.GetString(2);
                    tabelBestel.Rows.Add(rij);
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.StackTrace);
            }
            finally
            {
                conn.Close();
            }
            return klantDS;
        }

        public DataSet GetBestellingenMetDataAdapter()
        {
            // verbinding met de gegevensbank
            DbConnection conn = GetConnection();
            // commando-object aanmaken
            DbCommand command = conn.CreateCommand();
            command.CommandText = 
                ConfigurationManager.AppSettings["SELECT_BESTELLINGEN"];

            // DataAdapter aanmaken
            DbDataAdapter adapter = 
                factory.CreateDataAdapter();
            adapter.SelectCommand = command;

            // DataSet aanmaken
            DataSet klantDS = new DataSet(DS_ORDERS);

            // DataSet opvullen
            adapter.Fill(klantDS,TABEL_BESTELLING);

            return klantDS;
        }

        public DataSet GetBestellingen(int minimumAantal)
        {
            // verbinding met gegevensbank
            DbConnection conn = GetConnection();
            // commando-object
            DbCommand opdracht = conn.CreateCommand();
            opdracht.CommandText = 
                ConfigurationManager
                    .AppSettings["SELECT_BESTELLINGEN_MIN"];
            // parameter aanmaken
            DbParameter parameter = 
                factory.CreateParameter();
            parameter.ParameterName = MIN;
            parameter.DbType = DbType.Int32;
            opdracht.Parameters.Add(parameter);
            // adapter aanmaken
            DbDataAdapter adapter = 
                factory.CreateDataAdapter();
            adapter.SelectCommand = opdracht;
            // parameter waarde geven
            opdracht.Parameters[MIN].Value = minimumAantal;
            // dataset opvullen
            DataSet klantDS = new DataSet(DS_ORDERS);
            adapter.Fill(klantDS, TABEL_BESTELLING);
            return klantDS;
        }
    }
}
