using System;
using System.Collections;
using System.ComponentModel;
using System.Web;
using System.Web.SessionState;
using System.Data.OleDb;
using System.Configuration;
using System.Data;

namespace gemeente 
{
	/// <summary>
	/// Summary description for Global.
	/// </summary>
	public class Global : System.Web.HttpApplication
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components = null;

		public Global()
		{
			InitializeComponent();
		}	
		
		protected void Application_Start(Object sender, EventArgs e)
		{
			OleDbDataAdapter adapter = MaakAdapter();
			Application["adapter"] = adapter;

		}
 
		protected void Session_Start(Object sender, EventArgs e)
		{

		}

		protected void Application_BeginRequest(Object sender, EventArgs e)
		{

		}

		protected void Application_EndRequest(Object sender, EventArgs e)
		{

		}

		protected void Application_AuthenticateRequest(Object sender, EventArgs e)
		{

		}

		protected void Application_Error(Object sender, EventArgs e)
		{

		}

		protected void Session_End(Object sender, EventArgs e)
		{

		}

		protected void Application_End(Object sender, EventArgs e)
		{

		}

		private OleDbDataAdapter MaakAdapter() 
		{ 
			String connString = 
                ConfigurationManager.AppSettings["connString"];
			OleDbConnection conn = 
                new OleDbConnection(connString);
            String query = 
                ConfigurationManager.AppSettings["query"];
			OleDbCommand command = 
                new OleDbCommand(query, conn);
			OleDbDataAdapter adapter = 
                new OleDbDataAdapter(command);

			adapter.MissingSchemaAction = 
                MissingSchemaAction.AddWithKey;
			adapter.UpdateCommand = 
                MaakUpdateCommand(conn);
			adapter.DeleteCommand = 
                MaakDeleteCommand(conn);
			return adapter;
		}

		private OleDbCommand MaakUpdateCommand(OleDbConnection conn) 
		{
			String update = 
                ConfigurationManager.AppSettings["update"];
			OleDbCommand command = 
                new OleDbCommand(update, conn);
			OleDbParameter param = 
                command.Parameters
                .Add("@naam", DbType.String);
			param.SourceColumn = "naam";
			param.SourceVersion = 
                DataRowVersion.Current;
			param = command.Parameters
                .Add("@aantal", DbType.Int32);
			param.SourceColumn = "aantalinwoners";
			param.SourceVersion = 
                DataRowVersion.Current;
			param = command.Parameters
                .Add("@postcode", DbType.Int32);
			param.SourceColumn = "postcode";
			param.SourceVersion = 
                DataRowVersion.Original;
			return command;
		}

		
		private OleDbCommand MaakDeleteCommand(OleDbConnection conn ) 
		{ 
			String delete = 
                ConfigurationManager.AppSettings["delete"];
			OleDbCommand command = 
                new OleDbCommand(delete, conn);
			OleDbParameter param = command.Parameters
                .Add("@postcode", DbType.Int32);
			param.SourceColumn = "postcode";
			param.SourceVersion = 
                DataRowVersion.Original;
			return command;
		}

			
		#region Web Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.components = new System.ComponentModel.Container();
		}
		#endregion
	}
}

