/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/auth/RCS/authload.c,v 1.3 1997/01/14 19:15:27 rick Exp $";
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<ndbm.h>
#include	<syslog.h>

#include	"firewall.h"
#include	"auth.h"

static	int	ln = 0;
static	Cfg	*confp;
static	int	tin;

main(ac,av)
int	ac;
char	*av[];
{
	Auth	ab;
	char	user[128];
	int	recs = 0;

	tin = isatty(2);
	if((confp = cfg_read("authsrv")) == (Cfg *)-1) {
		fprintf(stderr,"Warning: cannot read configuration file\n");
		confp = (Cfg *)0;
	}

	if(auth_dbconfig(confp) || auth_dbopen()) {
		fprintf(stderr,"Cannot open auth database\n");
		exit(1);
	}

	while(getarec(user,&ab)) {
		if(auth_dbputu(user,&ab)) {
			fprintf(stderr,"Cannot write record\n");
			exit(1);
		}
		recs++;
		if(tin)
			fprintf(stderr,".");
	}

	auth_dbclose();
	if(tin)
		fprintf(stderr,"\n%d records loaded\n",recs);
	exit(0);
}


static	char *
nlgets(b,bs,fd)
char	*b;
int	bs;
FILE	*fd;
{
	char		*p;
	extern	char	*rindex();

	if(fgets(b,bs,fd) == (char *)0)
		return((char *)0);
	if((p = rindex(b,'\n')) != (char *)0)
		*p = '\0';
	return(b);
}


getarec(u,a)
char	*u;
Auth	*a;
{
	char	buf[512];

	/* leading newline */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(buf[0] != '\0') {
		fprintf(stderr,"bad format: missing blank line, line %d\n",ln);
		return(0);
	}


	/* user */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"user=",5)) {
		fprintf(stderr,"bad format: missing user=, line %d\n",ln);
		return(0);
	}
	strncpy(u,&buf[5],128);
	u[127] = '\0';


	/* longname */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"longname=",9)) {
		fprintf(stderr,"bad format: missing longname=, line %d\n",ln);
		return(0);
	}
	strncpy(a->ln,&buf[9],AUTH_LNSIZ);
	a->ln[AUTH_LNSIZ-1] = '\0';


	/* group */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"group=",6)) {
		fprintf(stderr,"bad format: missing group=, line %d\n",ln);
		return(0);
	}
	strncpy(a->gp,&buf[6],AUTH_GSIZ);
	a->gp[AUTH_GSIZ-1] = '\0';


	/* password */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"pass=",5)) {
		fprintf(stderr,"bad format: missing pass=, line %d\n",ln);
		return(0);
	}
	strncpy(a->pw,&buf[5],AUTH_PWSIZ);
	a->pw[AUTH_PWSIZ-1] = '\0';


	/* flags */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"flags=",6)) {
		fprintf(stderr,"bad format: missing flags=, line %d\n",ln);
		return(0);
	}
	sscanf(&buf[6],"%o",&(a->flgs));


	/* bcnt */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"bad_count=",10)) {
		fprintf(stderr,"bad format: missing bad_count=, line %d\n",ln);
		return(0);
	}
	sscanf(&buf[10],"%d",&(a->bcnt));


	/* proto */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"proto=",6)) {
		fprintf(stderr,"bad format: missing proto=, line %d\n",ln);
		return(0);
	}
	a->atyp = buf[6];


	/* last */
	if(nlgets(buf,sizeof(buf),stdin) == (char *)0)
		return(0);
	ln++;
	if(strncmp(buf,"last=",5)) {
		fprintf(stderr,"bad format: missing last=, line %d\n",ln);
		return(0);
	}
	a->last = atol(&buf[5]);
	return(1);
}
