/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/auth/RCS/cliio.c,v 1.7 1997/01/19 15:13:53 rick Exp $";
#include	<stdio.h>
#include	<syslog.h>
#include	<sys/signal.h>

#include	"firewall.h"
#include	"auth.h"


static	int	rem_authfd = -1;

auth_open(confp)
Cfg	*confp;
{
	int	authport = AUTH_DEFAULTPORT;
	char	*authserver = AUTH_DEFAULTSERVER;
	Cfg	*cf;

	if(rem_authfd != -1)
		return(0);

	if(confp != (Cfg *)-1 && confp != (Cfg *)0) {
		if((cf = cfg_get("authserver",confp)) != (Cfg *)0) {
			if(cf->argc < 1) {
				syslog(LLEV,"fwtkcfgerr: authserver not provided, line %d",cf->ln);
				return(1);
			}
			authserver = cf->argv[0];
			if(cf->argc > 1) {
				authport = atoi(cf->argv[1]);
				if(authport <= 0) {
					syslog(LLEV,"fwtkcfgerr: invalid authport %.512s, line %d",cf->argv[1],cf->ln);
					return(1);
				}
			}
		}
	}
	if(authserver == (char *)0) {
		syslog(LLEV,"fwtkcfgerr: no authserver defined! cannot authenticate!");
		return(1);
	}
	if(authport == -1) {
		syslog(LLEV,"fwtkcfgerr: no authport defined! cannot authenticate!");
		return(1);
	}

	rem_authfd = conn_server(authserver,authport,0,(char *)0);
	if(rem_authfd < 0)
		return(-1);
	signal(SIGPIPE,SIG_IGN);
	return(0);
}




auth_close()
{
	if(rem_authfd != -1)
		close(rem_authfd);
	rem_authfd = -1;
	return(0);
}

auth_send(buf)
char	*buf;
{
	int	x;

	if(rem_authfd < 0)
		return(1);

#ifdef	DEBUG
	syslog(LLEV,"auth_send %.512s\n",buf);
#endif
	x = strlen(buf);
	if(write(rem_authfd,buf,x) != x || write(rem_authfd,"\n",1) != 1)
		return(1);
	return(0);
}


auth_recv(buf,siz)
char	*buf;
int	siz;
{
	int	x = 0;
	int	i;

	if(rem_authfd < 0)
		return(1);

	while(1) {
		if(x + 1 == siz) {
			syslog(LLEV,"fwtksyserr: auth_recv: buffer overflow");
			return(1);
		}
		i = read(rem_authfd,&buf[x],1);
		if (i < 0)
			syslog(LLEV,"fwtksyserr: auth_recv: read error: %m");
		if (i <= 0)
			return(1);
		if(buf[x] == '\n')
			break;
		x++;
	}
	buf[x] = '\0';

#ifdef	DEBUG
	syslog(LLEV,"auth_recv %.512s\n",buf);
#endif
	return(0);
}




auth_perm(confp, name, oper, dest, op)
Cfg	*confp;
char	*name;
char	*oper;
char	*dest;
char	**op;
{

	char	sbuf[1024];
	int	hadtoopen = 0;

	if( !name || *name == '\0'){
			syslog(LLEV,"fwtksyserr: auth_perm: NULL username");
			return 1;
	}
	/* Check to see if the auth database needs to be opened */
	if(rem_authfd < 0) {
		if(auth_open(confp)) {
			return(1);
		}
		hadtoopen = 1;
		if(auth_recv(sbuf,sizeof(sbuf)))
			goto lostconn;
		if(strncmp(sbuf,"Authsrv ready",13)) {
			auth_close();
			return(1);
		}
	}


	/*
	Build the string for authsrv resultant string should look like:
	operation user smith telnet-gw relay.tis.com
	*/
	sbuf[0] = '\0';

	if(!op || *op == NULL)
		sprintf(sbuf,"operation user %.24s %.100s %.512s", name,oper,dest);
	else {	char *p;
		char **opptr;
		int n;

		opptr = op;
		sprintf(sbuf,"operation user %.24s %s %.100s %.512s",name,oper,dest,*opptr);
		opptr++;
		n = strlen(sbuf);
		/*
		 * append the rest of the operations
		 */
		while(*opptr){
			p = sbuf + n;
			n = n + strlen(*opptr) + 1;
			if (n > sizeof(sbuf)-1) {
				syslog(LLEV,"fwtksyserr: operation string buffer overflow");
				goto lostconn;
			}
			*p++ = ' ';
			strcpy(p, *opptr);
			opptr++;
		}
	}

	if(auth_send(sbuf))
		goto lostconn;

	if(auth_recv(sbuf,sizeof(sbuf)))
		goto lostconn;

	if(hadtoopen)
		auth_close();

	if(!strncmp(sbuf,"ok",2))
		return(0);

	if(!strncmp(sbuf,"Perm",4))
		return(1);
	return(-1);

lostconn:
	if(hadtoopen)
		auth_close();
	return(-1);
}
