/*-
 * Copyright (c) 1993, 1996 Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/* part of the http-gw
 *
 * The code if this module talks to FTP servers
 *
 */

#include "http-gw.h"

/* The following variables are used to determine if there is 
 * potentially any interesting info in the 'banner'
 */
int ftp_siteinfo = -1;
int ftp_repcnt;		/* count of the extra response lines */
int ftp_gensitedir;

/* parse_ftp
 *
 * NOTE! This modifies the buffer passed in.
 * It also sets up the following..
 *	ftp_server	the real ftp server.
 *	rem_server	what we are connecting to
 *	ftp_user	USER username  (username@host if proxying)
 *	ftp_pass	PASS http-gw@here
 */

int parse_ftp(path)
char *path;
{	char *p;

	p = index(path, '@');
	if( p == NULL){
		return TYPE_UNKNOWN;
	}
	*p++ = '\0';
	strncpy(rem_server, &path[4], MAXHOSTNAMELEN-1);
	rem_server[sizeof(rem_server)-1] = '\0';

	bcopy(p, path, strlen(p)); /* move up what's left */

	if( ftp_proxy[0]){
		sprintf(ftp_user,"USER anonymous@%s",rem_server);
		strcpy(ftp_server, rem_server);
		strncpy(rem_server, ftp_proxy, sizeof(rem_server)); /* Use proxy */
		rem_server[sizeof(rem_server)-1] = '\0';
	}else {
		sprintf(ftp_user,"USER anonymous");
		strcpy(ftp_server, rem_server);
	}
	sprintf(ftp_pass,"PASS http-gw@%s", ourname);
	return TYPE_FTP|TYPE_DIR;
}



int parse_ftp_login(path)
char *path;
{	char *p;

	p = strrchr(path, '@');
	if( p == NULL){
		strcpy(ftp_server, path);
	}else{
		*p++ = '\0';
	
		strcpy(ftp_server, p);
	
		p = strrchr(path, ':');
		if( p != NULL){
			*p++ = '\0';
			sprintf(ftp_pass,"PASS %s", p);
			sprintf(ftp_user,"USER %s", path);
		}else{
			sprintf(ftp_user,"USER %s", path);
			sprintf(ftp_pass,"PASS http-gw@%s", ourname);
		}
	}

	return 0;
}

char * port_cmd_for(sockfd, rfd)
int rfd,sockfd;
{	static char portbuf[80];
	int port;
	unsigned char haddr[4];

	portbuf[0] = '\0';

	port= port_num(sockfd, rfd, haddr);
	if( port == 0)
		return portbuf;

	sprintf(portbuf,"PORT %d,%d,%d,%d,%d,%d",
		(((int)haddr[0])&0xff),(((int)haddr[1])&0xff),
		(((int)haddr[2])&0xff),(((int)haddr[3])&0xff),
		(port/256)&0xff, port&0xff);
	return portbuf;
}

static char ftp_reply_buf[1024];

int	get_ftp_reply(rfd)
int rfd;
{
	fd_set	rdy;
	int cnt;
	int ret =0;

	sprintf(ftp_reply_buf,"501 Unknown ftp problem");
	ftp_repcnt = 0;

	cnt = getline(rfd, ftp_reply_buf, sizeof(ftp_reply_buf)-1);
	if( cnt <= 0 || ftp_reply_buf[0] == '5'){
		return '5';		/* code 5 is error? */
	}

/* Look for continuation lines... */
	if( ftp_reply_buf[3] == '-'){
		while(1){
			cnt = getline(rfd, errbuf, sizeof(errbuf)-1);
			if( cnt <= 0)
				break;
			ftp_repcnt++;
			if( ftp_siteinfo >= 0){
				say(ftp_siteinfo, errbuf);
			}
			if( cnt >= 4){
				if( errbuf[3] == ' ' &&
					!strncmp(errbuf, ftp_reply_buf, 3)){
					break;
				}
			}
		}
	}
	return ftp_reply_buf[0];
}


/* Translate the ftp type reply into a gopher type reply
 */

int trans_ftp_reply(stem, buf)
char *stem;
char *buf;
{	char path[MAX_URL_LEN];
	char x, *p;
	char *fs = "";

	strncpy(path, buf, MAX_URL_LEN-1);
	path[MAX_URL_LEN-1] = '\0';

	if( stem == NULL)
		stem = "";

	x = guess_gopher_type(path);

	if( *stem && *stem != '/' && stem[1] == '/')
		stem++;			/* skip the gopher type character */
	if( *stem == '/')
		stem++;
/* pjc 7/28/95 strip trailing '*' */
	for(p = path; *p; p++);
	if( p != path && p[-1] == '*'){
		*--p = '\0';
	}

	for(p = stem; *p; p++);
	if( p != stem && p[-1] != '/'){
		fs = "/";
	}

	if( ftp_user[0]){
		if( ftp_pass[0] == '\0'){
			sprintf(ftp_pass,"PASS http-gw@%s", ourname);
		}
		sprintf(buf,"%c%s\t%c/%s%s%s\t%s:%s@%s\t%u", x, path,
			x, stem, fs, path,
			&ftp_user[5], &ftp_pass[5], ftp_server, rem_port);
	}else{
		sprintf(buf,"%c%s\t%c/%s%s%s\t%s\t%u", x, path,
			x, stem, fs, path, ftp_server, rem_port);
	}
	return 0;
}


/* ftp_login
 *
 * returns a string of the form
 * [user[:password]@]hostname[:port]
 * as taken from the WWW rfc1630.
 */
char *ftp_login(host, port)
char *host,*port;
{
	static char login_buf[MAXHOSTNAMELEN+80];

	if( port == NULL)
		port = "";
	if( *port && strcmp(port, "21")){
		sprintf(login_buf,"%s:%s", host, port);
	}else{
		strcpy(login_buf, host);
	}
	return login_buf;
}

int ftp_setup(sockfd, rfd, ftp_listen)
int sockfd, rfd, *ftp_listen;
{	int siteinfo = ftp_siteinfo;

	ftp_siteinfo = -1;
	if( get_ftp_reply(rfd) != '2')
		goto broken;

	if( ftp_user[0] == '\0')
		say(rfd,"USER anonymous");
	else
		say(rfd, ftp_user);
	if( get_ftp_reply(rfd) != '3')
		goto broken;

	if( ftp_pass[0] == '\0')
		sprintf(ftp_reply_buf,"PASS http-gw@%s", ourname);
	else
		strcpy(ftp_reply_buf, ftp_pass);
	say(rfd, ftp_reply_buf);

	ftp_siteinfo = siteinfo;

	if( get_ftp_reply(rfd) != '2')
		goto broken;

	if( ftp_repcnt > 2){
		ftp_gensitedir = 1;
	}

	ftp_siteinfo = -1;
	*ftp_listen = make_conn(0);
	if( *ftp_listen < 0)
		goto broken;

	if( listen(*ftp_listen, 2))
		goto broken;
	say(rfd, port_cmd_for(rfd, *ftp_listen));
	if( get_ftp_reply(rfd) != '2')
		goto broken;

	ftp_siteinfo = siteinfo;
	return 0;
broken:
	ftp_siteinfo = siteinfo;
	return 1;
}


int forward_ftp(sockfd, buf, host)
int sockfd;
char *buf, *host;
{	int port, cnt;
	char *p, *q;
	int ftp_control, ftp_listen, ftp_data;
	struct sockaddr_in serv_addr;
	int length = sizeof( serv_addr);
	char ftp_command[MAX_URL_LEN+40];
	char gt[2];
	int errnum, dir_flag=1, pre=0;
	char errnum_buf[4];
	static	char	mtype[10];
	int	mflag = 0;

	ftp_control = ftp_listen = ftp_data = -1;

	port = FTPPORT;
	port = get_port(host, port);
	rem_port = port;


	if( (!strcasecmp(host, ourname) && port == ourport) || 
		!strcmp(host,"-internal-")){
		if( send_internal(sockfd, buf, 0))
			return 0;
	}


	if( (rfd = conn_server(host, port, 0, errbuf)) < 0){
		go_error(sockfd, 404, "Requested Information");
		go_error(sockfd, 404, "path=%s", buf);
		go_error(sockfd, 404, "could not be fetched.");
		go_error(sockfd, 404, "Failed to connect to %sserver %s (%d)",(rem_type & TYPE_FTP)? "ftp ":"", host, port);
		syslog(LLEV,"failed to connect to server %.512s (%d)", host, port);
		return 0;
	}

	p = rem_path;
	if( *p != '/' && p[1] == '/')
		p++;

	if( (rem_type & TYPE_TEXT) && !strncmp(p, "/-internal-ftp-info-", 20)){
		if( (rem_type & (TYPE_HTTP|TYPE_TEXT)) == (TYPE_HTTP|TYPE_TEXT)){
			gostarthtml(sockfd);
			pre = 1;
		}
		say(sockfd,"Information message from FTP server");
		say(sockfd,"-----------------------------------");
		ftp_siteinfo = sockfd;
	}

	ftp_control = rfd;

	if( ftp_setup(sockfd, rfd, &ftp_listen)){
		goto broken2;
	}

	if( ftp_siteinfo >= 0){
		if( pre ){
			goendhtml(sockfd);
		}

		return 0;
	}
	sprintf(ftp_command,"SYST");
	say(ftp_control, ftp_command);
	if( '2' == get_ftp_reply(ftp_control)){
		strncpy(mtype, &ftp_reply_buf[4], 8);
		mtype[8] = '\0';
/* this is all a bit bogus... */
		if( !strncasecmp(mtype,"vms", 3)){
			mflag = 1;
		}
	}else{
		mflag = -1;
	}
/* Walk the directory tree */
	while(1){
		if( *p == '/')
			p++;
		q = strchr(p,'/');
		if( q != NULL && q[1] != '\0'){
			*q = '\0';
			sprintf(ftp_command,"CWD %s", p);
			*q = '/';
			p = q;
			p++;
			say(ftp_control,ftp_command);
			if( get_ftp_reply(ftp_control) != '2')
				goto broken2;
		}else{
			break;
		}
	}

	if( (rem_type & TYPE_DIR)== 0){
		gt[0] = guess_gopher_type(rem_path);
		gt[1] = '\0';
#ifdef ASSUME_TEXT
		if( check_req(sockfd, gt) & TYPE_BINARY){
			say(rfd,"TYPE I");
			if( get_ftp_reply(ftp_control) != '2')
				goto broken2;
		}
#else
		say(rfd,"TYPE I");	/* 7/28/95 pjc always use binary mode */
		if( get_ftp_reply(ftp_control) != '2')
			goto broken2;
#endif	
	
		rem_typech = chk_type_ch;

		if( mflag == 1 && *p == '/')
			p++;

		sprintf(ftp_command,"RETR %s", p);
		say(ftp_control, ftp_command);
		if( get_ftp_reply(ftp_control) != '1'){
			if( ftp_reply_buf[0] != '5'){
				goto broken2;
			}
		}else {
			dir_flag = 0;
		}
	}

	if( dir_flag){

		if( *p == '/')
			p++;
		if( *p ){
			q = strchr(p,'/');
			if( q != NULL){
				*q = '\0';
			}
			sprintf(ftp_command,"CWD %s", p);
			say(ftp_control,ftp_command);
			if( q != NULL){
				p = &q[1];
			}else{
				p = "";
			}
			if( get_ftp_reply(ftp_control) != '2')
				goto broken2;
		}

		if( mflag == 0 ){
			sprintf(ftp_command,"NLST -LF %s", p);
		}else{
			if(p==NULL || *p == '\0')
				sprintf(ftp_command,"NLST");
			else
				sprintf(ftp_command,"NLST %s", p);
		}
		say(ftp_control, ftp_command);
		if( get_ftp_reply(ftp_control) != '1')
			goto broken2;
	}
	(void) signal(SIGALRM, net_timeout);
	(void) alarm(timeout.tv_sec);

	ftp_data = accept(ftp_listen, (struct sockaddr *)&serv_addr, &length);
	close(ftp_listen);

	(void) alarm(0);
	(void) signal(SIGALRM, SIG_IGN);

	if( ftp_data < 0){
		close(ftp_control);
		goto broken;
	}
	rfd = ftp_data;

	if( dir_flag){
		if( !translate_reply(sockfd, rfd))
			goto broken;
	}else if( rem_typech == 'h'){	/* assume html so needs translation */
		trans_html_file(sockfd, rfd, "ftp", -1);
	}else{
		copyfiletype(sockfd, rfd);
	}

	return 1;

broken2:
	strncpy(errnum_buf, ftp_reply_buf, 3);
	errnum_buf[3] = '\0';
	errnum = atoi(errnum_buf);
	go_error(sockfd,errnum, "%s", ftp_reply_buf);
	while( ftp_control >= 0 && ftp_reply_buf[3] == '-'){
		cnt = getline(ftp_control, errbuf, 1023);
		if( cnt <= 0)
			break;
		go_error(sockfd, errnum, "%s", errbuf);
		if( errbuf[3] == ' ')
			break;
	}

broken:
	return 0;
}


