/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */
/* Gopher/Http IO module
 * By P.J.Churchyard
 * Copyright (c) 1994
 * All rights reserved.
 */

#include "http-gw.h"

#include "gio.h"

#ifndef GBLOCK_SIZE
#define GBLOCK_SIZE 1024
#endif

GBUF *new_gbuf()
{	GBUF *ret;

	ret = (GBUF *)malloc(sizeof(GBUF));

	if( ret == NULL){
		syslog(LLEV,"new_gbuf out of memory");
		return NULL;
	}

	ret->next = ret->prev = NULL;

	ret->data = NULL;
	ret->length = ret->flag = ret->pos = 0;

	return ret;
}

GFILE *new_gfile()
{	GFILE *ret;

	ret = (GFILE *)malloc(sizeof(GFILE));

	if( ret == NULL){
		syslog(LLEV,"new_gfile out of memory");
		return NULL;
	}

	ret->next = NULL;
	ret->driver = NULL;
	ret->data = NULL;
	ret->flag = 0;

	return ret;
}


/* top level routines */

int g_read(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	GBUF *ret;

	if( gf == NULL || gbp == NULL){
		return -1;
	}

	if( gf->driver == NULL || gf->driver->g_read == NULL){
		return -1;
	}

	return (*gf->driver->g_read)(gf, gbp);
}


int g_write(gf, gbp)
GFILE *gf;
GBUF **gbp;
{

	if( gf == NULL || gbp == NULL){
		return -1;
	}

	if( gf->driver == NULL || gf->driver->g_write == NULL){
		return -1;
	}

	return (*gf->driver->g_write)(gf, gbp);
}


/* basic network read/write stuff */

struct gnet_rec {
int	fd;
};


int g_netread(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gnet_rec *gnr;
	GBUF *buf;
	int cnt;

	buf = new_gbuf();
	buf->data = (char *)malloc(GBLOCK_SIZE);

	gnr = (struct gnet_rec *)gf->data;

	cnt = read(gnr->fd, buf->data, GBLOCK_SIZE);
	if( cnt > 0){
		buf->length = cnt;
		*gbp = buf;
	}else{
		free(buf->data);
		free(buf);
		*gbp = NULL;
	}
	return cnt;
}

int g_netwrite(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gnet_rec *gnr;
	GBUF *buf;
	int cnt;

	gnr = (struct gnet_rec *)gf->data;

	buf = *gbp;

	cnt = write(gnr->fd, buf->data, buf->length);

	free(buf->data);
	free(buf);
	*gbp = NULL;
	return cnt;
}

GDEV gnetdev={
g_netread,
g_netwrite
};

GFILE *gnet_open(fd)
int fd;
{	GFILE *ret = new_gfile();
	struct gnet_rec *gnr;

	if( ret == NULL){
		return NULL;
	}

	gnr = (struct gnet_rec *)malloc(sizeof(struct gnet_rec));
	if( gnr == NULL){
		free(ret);
		ret = NULL;
	}else{
		ret->data = (char *)gnr;
		gnr->fd = fd;
	}

	return ret;

}



/* basic file read/write stuff */

struct gfiledev_rec {
int	fd;
};


int g_fileread(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gfiledev_rec *gnr;
	GBUF *buf;
	int cnt;

	buf = new_gbuf();
	buf->data = (char *)malloc(GBLOCK_SIZE);

	gnr = (struct gfiledev_rec *)gf->data;

	cnt = read(gnr->fd, buf->data, GBLOCK_SIZE);
	if( cnt > 0){
		buf->length = cnt;
		*gbp = buf;
	}else{
		free(buf->data);
		free(buf);
		*gbp = NULL;
	}
	return cnt;
}

int g_filewrite(gf, gbp)
GFILE *gf;
GBUF **gbp;
{	struct gfiledev_rec *gnr;
	GBUF *buf;
	int cnt;

	gnr = (struct gfiledev_rec *)gf->data;

	buf = *gbp;

	cnt = write(gnr->fd, buf->data, buf->length);

	free(buf->data);
	free(buf);
	*gbp = NULL;
	return cnt;
}

GDEV gfiledev={
g_fileread,
g_filewrite
};

GFILE *gfile_open(fd)
int fd;
{	GFILE *ret = new_gfile();
	struct gfiledev_rec *gnr;

	if( ret == NULL){
		return NULL;
	}

	gnr = (struct gfiledev_rec *)malloc(sizeof(struct gfiledev_rec));
	if( gnr == NULL){
		free(ret);
		ret = NULL;
	}else{
		ret->data = (char *)gnr;
		gnr->fd = fd;
	}

	return ret;

}

/* basic memory read stuff */

struct net_rec {
char *data;
int off, len;
struct net_rec *next;
};

struct net_rec *net_fds[16];

int net_flags[16];

struct net_rec *new_netrec()
{	struct net_rec *nr;

	nr = (struct net_rec *)malloc( sizeof(struct net_rec));
	if( nr ){
		nr->data = NULL;
		nr->off = 0;
		nr->len = 0;
		nr->next = NULL;
	}else {
		syslog(LLEV, "Out of memory: %m");
		exit(1);
	}
	return nr;
}

int new_netdata(nr, cnt)
struct net_rec *nr;
int cnt;
{	
	if( nr == NULL)
		return 0;
	if( nr->data )
		free(nr->data);
	nr->data = (char *)malloc(8192);
	if( nr->data == NULL){
		syslog(LLEV,"Out of memory: %m");
		exit(1);
	}
	return 8192;
}



int net_read(fd, buf, len)
int fd, len;
char *buf;
{	struct net_rec *nr;
	int ret, i;
	char *p;
	fd_set rdset;
	struct timeval timeval;

	if( fd >= 0 && fd < 16){
		if( net_flags[fd]){
			syslog(LLEV,"Network error: net_flags[%d] set (read)", fd);
			http_exit(1);
		}

		nr = net_fds[fd];
		if( nr){
			ret = nr->len- nr->off;
			if(ret > len)
				ret = len;
			len -= ret;
			p = &nr->data[nr->off];
			nr->off += ret;
			for(i=0; i < ret; i++)
				*buf++ = *p++;
			if(  nr->off >= nr->len){
				net_fds[fd] = nr->next;
				free(nr->data);
				free(nr);
			}
			return ret;
		}
	}else{
		syslog(LLEV,"Network error: socket %d out of range", fd);
		http_exit(1);
	}

/* need to read data... */
	FD_ZERO(&rdset);
	FD_SET(fd, &rdset);
	timeval.tv_usec = 0;
	timeval.tv_sec = proxy_timeout;

	ret = select(fd+1, &rdset, (fd_set *)0, (fd_set *)0, &timeval);
	if( ret > 0){
		ret = read(fd, buf, len);
		if( ret <= 0){
			net_flags[fd] = 1;
		}
	}else{
		syslog(LLEV,"Timeout during read after %d seconds", proxy_timeout);
		http_exit(0);
	}
	return ret;
}

int net_unread(fd, buf, len)
int fd, len;
char *buf;
{	struct net_rec *nr = (struct net_rec *)0, *nrn;
	char *p;

	if( fd >= 0 && fd < 16){
		nr = new_netrec();
	}
	if( nr ){
		nr->data = (char *)malloc( len);
		if( nr->data){
			nr->len = len;
			nr->off = 0;
			nr->next = (struct net_rec *)0;
			nrn = net_fds[fd];
			if( nrn == (struct net_rec *)0){
				net_fds[fd] = nr;
			}else {
				while(nrn->next )nrn = nrn->next;
				nrn->next = nr;
			}

			p = nr->data;
			while(len > 0){
				len--;
				*p++ = *buf++;
			}
		}else{
			free(nr);
		}
	}
	return 0;
}


int net_connect(host, port, priv, rbuf)
char *host;
int port;
int priv;
char *rbuf;
{	int ret;
	int cnt;
	static char buf[256];
	fd_set infd;
	struct timeval tv;

#ifdef TELNET_HACK
	sprintf(buf, "c %s %d\n", host, port);
	ret = conn_server("relay.tis.com", 23, priv, rbuf);

	if( ret >= 0){
		write(ret, buf, strlen(buf));
	}
	while(1){
		getline(ret, buf, 255);
		if( !strncmp("Trying", buf, 6))
			break;
		if( !strncmp("Connect", buf, 7))
			break;
	}
	while(1){
		FD_ZERO(&infd);
		FD_SET(ret, &infd);
		tv.tv_sec = 5;
		tv.tv_usec = 0;

		cnt = select(ret+1, &infd, (fd_set *)0, (fd_set *)0, &tv);
		if( cnt <= 0)
			break;

		if( read(ret, buf, 1) != 1){
			close(ret);
			return -1;
		}
		if( (buf[0] & 0xff) == 0xff){
			if( read( ret, buf, 2) != 2){
				close(ret);
				return -1;
			}
			continue;
		}else {
			net_unread(ret, buf, 1);
			break;
		}
	}

#else
	ret = conn_server(host, port, priv, rbuf);
#endif
	
	return ret;
}


int net_write(fd, buf, len)
int fd;
char *buf;
int len;
{	fd_set wrset;
	int ret;
	struct timeval timeval;

	if( fd < 0 || fd >= 16){
		syslog(LLEV,"Network error: socket %d out of range (write)", fd);
		http_exit(1);
	}
	if( net_flags[fd]){
		syslog(LLEV,"Network error: net_flags[%d] set (write)", fd);
		http_exit(1);
	}

	if (len == 0) return 00;
	if (len < 0) {
		syslog(LLEV,"Network error: attempt to write %d bytes", len);
		http_exit(1);
	}

	FD_ZERO(&wrset);
	FD_SET(fd, &wrset);
	timeval.tv_usec = 0;
	timeval.tv_sec = proxy_timeout;

	ret = select(fd+1, (fd_set *)0, &wrset,  (fd_set *)0, &timeval);
	if( ret > 0){
		ret = write(fd, buf, len);
		if( ret < 0){
			net_flags[fd] = 1;
		}
	}else{
		syslog(LLEV,"Timeout during write after %d seconds", proxy_timeout);
		http_exit(0);
	}
	return ret;
}


