/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 *		Peter J. Churchyard, Trusted Information Systems, Inc.
 *
 *	22-Aug-1994	Started to add the Gopher+ stuff. (pjc)
 *	29-Jan-1995	Tidy up various things (pjc)
 *	13-Jun-1996	Implement Java and JavaScript screening (cvc)
 *	27-Jul-1996	Implement ActiveX screening (cvc)
 */

static	char	RcsId[] = "$Header: /home/rmurphy/fwtk/fwtk/http-gw/RCS/hmain.c,v 1.12 1998/02/06 23:32:11 rmurphy Exp $";

	int	nojava=0;	/* set on to block Java */
	int	nojavascript=0;	/* set on to block JavaScript */
	int	noactivex=0;	/* set on to block ActiveX */

#define DEFINE_DATA

#include <sys/wait.h>
#include "http-gw.h"

#ifndef SSLPORT
#define SSLPORT 443
#endif

struct str_arg_rec {
char	*name;
char	*buf;
int	length;
};

struct str_arg_rec string_arg_tab[] = {
{ "directory", 		go_directory, 		MAX_URL_LEN-1},
{ "default-gopher",	def_server,		MAXHOSTNAMELEN+5},
{ "default-httpd",	def_httpd,		MAXHOSTNAMELEN+5},
{ "icon-source",	default_icon_url,	MAXHOSTNAMELEN+5},
{ "ftp-proxy",		ftp_proxy,		MAXHOSTNAMELEN+5},
{ NULL,	NULL,	0}
};


char *maphostname();

int fwtk_get_string_args( tab)
struct str_arg_rec *tab;
{	int flag = 0;
	Cfg	*cf;

	while(tab && tab->name != NULL){
		if((cf = cfg_get(tab->name,confp)) != (Cfg *)0) {
			if(cf->argc != 1) {
				syslog(LLEV,"%.100s must have one parameter, line %d",tab->name, cf->ln);
				flag = 1;
			}else {
				strncpy(tab->buf, cf->argv[0], tab->length);
			}
		}
		
		tab++;
	}
	return flag;
}

void add_browser_type(browser_name, trusted_for)
char * browser_name;
char * trusted_for;
{
	char 	**tab_ptr;
	int	*cnt_ptr;
	char	*tmp_ptr;

	if (!strcmp("java",trusted_for)) {
		tab_ptr = javaSafe;
		cnt_ptr = &javaSafe_len;
	} else if (!strcmp("javascript",trusted_for)) {
		tab_ptr = livescriptSafe;
		cnt_ptr = &livescriptSafe_len;
	} else {
		tab_ptr = activexSafe;
		cnt_ptr = &activexSafe_len;
	}

	if (*cnt_ptr >= MAXBROWSERS) {
		syslog(LLEV,"cant add, already have max entries in browser table");
		return;
	}

	if ( !(tab_ptr[*cnt_ptr] = strdup(browser_name)) ) {
		syslog(LLEV,"failed to get storage for browser entry %m");
		exit(1);
	}

	(*cnt_ptr)++;

	tab_ptr[*cnt_ptr] = NULL;

	return;
}

void http_exit(ret)
int ret;
{
	syslog(LLEV,"exit host=%.512s/%.20s code=%d", rladdr, riaddr, ret);
	exit(ret);
}


int do_chroot_etc()
{

	if( go_directory[0]){
		chdir("/");
		if( chdir(go_directory)){
			syslog(LLEV,"chdir %.512s: %m", go_directory);
			http_exit(1);
		}
	
		if( chroot(go_directory)){
			syslog(LLEV,"chroot %.512s: %m", go_directory);
			http_exit(1);
		}
		chdir("/");
	}
	
	if(rungid != -1 && setgid(rungid)) {
		syslog(LLEV,"cannot setgid %d: %m",rungid);
		http_exit(1);
	}

	if(runuid != -1 && setuid(runuid)) {
		syslog(LLEV,"cannot setuid %d: %m",runuid);
		http_exit(1);
	}
	return 0;
}

char *makestring(str)
char *str;
{	int leng;
	char *ret;

	if( str == NULL)
		return NULL;

	leng = strlen(str);
	ret = (char *)malloc( leng+1);

	if( ret != NULL){
		strncpy(ret, str, leng);
		ret[leng] = '\0';
	}
	return ret;
}


/* Start of main code */
extern void trap_neterr();

main(ac,av)
int	ac;
char	*av[];
{
	Cfg		*cf;
	int		x;
static struct sockaddr_in serv_addr;
	int		length = sizeof(serv_addr);

	if( ac == 2 && !strcmp(av[1], "-version")){
		printf("http-gw:   %s\n", ver_str);
		exit(0);
	}
	livescriptSafe[0] = NULL;
	javaSafe[0] = NULL;
	activexSafe[0] = NULL;
	activexSafe_len = 0;
	javaSafe_len = 0;
	livescriptSafe_len = 0;	

#ifndef	LOG_DAEMON
	openlog("http-gw",LOG_PID);
#else
	openlog("http-gw",LOG_PID|LOG_NDELAY,LFAC);
#endif

	if( ac > 1 && !strcmp(av[1], "-daemon")){
		x = str_to_port( av[2]);
		syslog(LLEV,"Starting daemon mode on port %d", x);

		ac -= 2;
		av += 2;
		do_daemon( x);
	}

	time(&start_time);
	signal(SIGPIPE,trap_neterr);

	authuser[0] = '\0';
	strcpy(autheduser,"unauth");

		
	while(ac > 1){
		ac--;
		av++;

		switch(av[0][1]) {
#ifdef DODEBUG
		case 'D':
			DEBUG |= 1;
			debugf = stderr;
			break;

		case 'd':
			DEBUG |= 2;
			debugf = fopen(optarg, "a");
			if( debugf == NULL){
				DEBUG = 0;
				syslog(LLEV,"failed to append to file %.512s", optarg);
			}
			setvbuf(debugf, NULL, _IONBF, (size_t)0);
			break;
#endif
		default:
			syslog(LLEV,"bad command line option -%c",av[0][1]);
			exit(1);
		}
	}
	

#ifdef	DEBUG

	if( DEBUG && ac > 1){
		ac--;
		av++;
		goport = atoi(av[0]);
	}

	if(DEBUG&1){
		debugbind();
	}
#endif
	confp = cfg_read("http-gw");

	if( confp == NULL || confp == (Cfg *)-1){
		syslog(LLEV,"Failed to get any netperm-table entries");
		exit(1);
	}

	if(gethostname(ourname,sizeof(ourname)))
		strcpy(ourname,"unknown");
#ifndef NO_GETHOSTBYNAME
	ourhe = gethostbyname ( ourname);
	if( NULL != ourhe){
		strcpy(ourname, ourhe->h_name);
	}
#endif


	if( getsockname(0, (struct sockaddr *) &serv_addr, &length)){
		syslog(LLEV,"cannot get our port");
		exit(1);
	}
	ourport = ntohs(serv_addr.sin_port);

	if(peername(0,rladdr,riaddr,sizeof(riaddr))) {
		syslog(LLEV,"cannot get peer name");
		exit(1);
	}


	if((cf = cfg_get("groupid",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"groupid must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		if((rungid = mapgid(cf->argv[0])) == -1) {
			syslog(LLEV,"cannot map %.100s to gid",cf->argv[0]);
			http_exit(1);
		}
	}

	if((cf = cfg_get("userid",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"userid must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		if((runuid = mapuid(cf->argv[0])) == -1) {
			syslog(LLEV,"cannot map %.100s to uid",cf->argv[0]);
			http_exit(1);
		}
	}


	if( fwtk_get_string_args( string_arg_tab)){
		http_exit(1);
	}
/* get the list of browsers considered safe to pass Java, JavaScript
   or ActiveX when the host permission rule specifies -safejava or 
   -safejavascript.  If the host permission has nojava... or java.... 
   then the browser type is not consulted. Multiple entries are 
   concatenated on the lists.
	http-gw: browser xxxxxx 
		-safejava = this browser considered safe for Java execution
		-safejavascript = this browser considered safe for LiveScript
		-safeactivex = this browser considered safe for ActiveX
 */

	if( (cf = cfg_get("browser", confp)) != (Cfg *)0){
		while(cf != (Cfg *)0){
			if( cf->argc < 1){
				syslog(LLEV,"browser directive takes at least 2 arguments, line %d", cf->ln);
			}else {
			    for(x=1; x < cf->argc; x++){
				if (!strcasecmp(cf->argv[x],"-safejava")) {
					add_browser_type(cf->argv[0],"java");
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safejavascript")) {
					add_browser_type(cf->argv[0],"javascript");
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safeactivex")) {
					add_browser_type(cf->argv[0],"activex");
					continue;
				}
				syslog(LLEV,"browser directive unrecognized argument, line %d", cf->ln);
			    }
			}
			cf = cfg_get("browser", (Cfg *)0);
		}
	}
/* suggested by Daniel W. Woycke <woycke@mitre.org */
	if((cf = cfg_get("url-filter",confp)) != (Cfg *)0) {

		if(cf->argc != 1) {
			syslog(LLEV,"url-filter must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		unesc(default_url_filter, cf->argv[0], 0);
	}

/* get the default-policy keywords
	-java = allow java for everyone
	-nojava = disable java applets for everyone
	-safejava = enable java applets for safe browsers only
	-javascript = allow javascript for everyone
	-nojavascript = deny javascript for everyone 
	-safejavascript = allow javascript for safe browsers only 
	-activex = allow ActiveX for everyone
	-noactivex = disable ActiveX applets for everyone
	-safeactivex = enable ActiveX applets for safe browsers only
 these defaults can be overriden by the hosts entries, or policy statement */

	if( (cf = cfg_get("default-policy", confp)) != (Cfg *)0){
		while(cf != (Cfg *)0){
			if( cf->argc < 1){
				syslog(LLEV,"default-policy takes at least 1 argument, line %d", cf->ln);
			}else for(x=0; x < cf->argc; x++){
				if (!strcasecmp(cf->argv[x],"-nojava")) {
					nojava = 1;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-java")) {
					nojava = 0;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safejava")) {
					nojava = 2;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-nojavascript")) {
					nojavascript = 1;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-javascript")) {
					nojavascript = 0;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safejavascript")) {
					nojavascript = 2;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-noactivex")) {
					noactivex = 1;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-activex")) {
					noactivex = 0;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safeactivex")) {
					noactivex = 2;
					continue;
				}
				syslog(LLEV,"default-policy unrecognized argument, line %d", cf->ln);
			}
			cf = cfg_get("default-policy", (Cfg *)0);
		}
	}
	/* see if this is someone we are even willing to converse with */
	if(!oktotalkto()) {
		sprintf(nouse_msg,"Sorry, Access denied for %s (%s)",rladdr,riaddr);
	}

	timeout.tv_usec = 0;
	if((cf = cfg_get("timeout",confp)) != (Cfg *)0) {
		if(cf->argc != 1) {
			syslog(LLEV,"timeout must have one parameter, line %d",cf->ln);
			http_exit(1);
		}
		if((timeout.tv_sec = atoi(cf->argv[0])) <= 0) {
			syslog(LLEV,"timeout %.100s invalid, line %d",cf->argv[0],cf->ln);
			http_exit(1);
		}
	} else
		timeout.tv_sec = PROXY_TIMEOUT;
	proxy_timeout = timeout.tv_sec;

/* get the policy keywords
	-java = allow java for everyone
	-nojava = disable java applets for everyone
	-safejava = allow java applets for safe browsers
	-javascript = allow javascript for everyone
	-nojavascript = deny javascript for everyone 
	-safejavascript = allow javascript for safe browsers 
	-activex = allow ActiveX for everyone
	-noactivex = disable ActiveX applets for everyone
	-safeactivex = allow ActiveX applets for safe browsers */

	if( (cf = cfg_get("policy", confp)) != (Cfg *)0){
		while(cf != (Cfg *)0){
			if( cf->argc < 1){
				syslog(LLEV,"policy takes at least 1 argument, line %d", cf->ln);
			}else for(x=0; x < cf->argc; x++){
				if (!strcasecmp(cf->argv[x],"-nojava")) {
					nojava = 1;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-java")) {
					nojava = 0;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safejava")) {
					nojava = 2;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-nojavascript")) {
					nojavascript = 1;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-javascript")) {
					nojavascript = 0;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safejavascript")) {
					nojavascript = 2;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-noactivex")) {
					noactivex = 1;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-activex")) {
					noactivex = 0;
					continue;
				}
				if (!strcasecmp(cf->argv[x],"-safeactivex")) {
					noactivex = 2;
					continue;
				}
				syslog(LLEV,"policy unrecognized argument, line %d", cf->ln);
			}
			cf = cfg_get("policy", (Cfg *)0);
		}
	}

/* load the noproxy list */

	if( (cf = cfg_get("noproxy", confp)) != (Cfg *)0){
		while(cf != (Cfg *)0){
			if( cf->argc < 3){
				syslog(LLEV,"noproxy takes atleast 3 arguments, line %d", cf->ln);
			}else{
				if( strcmp("-ident", cf->argv[cf->argc-2])){
					syslog(LLEV,"noproxy: should be ... -ident NAME, line %d", cf->ln);
				}else if( !strcmp(ident, cf->argv[cf->argc-1])){
					for(x=0; x < cf->argc-2; x++){
						add_noproxy(cf->argv[x]);
					}
				}
			}
			cf = cfg_get("noproxy", (Cfg *)0);
		}
	}

	if( (cf = cfg_get("forward", confp)) != (Cfg *)0){
		while(cf != (Cfg *)0){
			if( cf->argc < 5){
				syslog(LLEV,"forward takes atleast 5 arguments, line %d", cf->ln);
			}else{
				if( strcmp("-tohost", cf->argv[cf->argc-2]) ||
				    strcmp("-protocol", cf->argv[cf->argc-4])){
					syslog(LLEV,"forward: should be ... -protocol PROTO -tohost HOSTNAME, line %d", cf->ln);
				}else {
					for(x=0; x < cf->argc-4; x++){
						add_forward(cf->argv[x], cf->argv[cf->argc-3], cf->argv[cf->argc-1]);
					}
				}
			}
			cf = cfg_get("forward", (Cfg *)0);
		}
	}


/* read the request */
	if( getline(0, go_request, MAX_URL_LEN-1) >= 0) {
		if (nouse_msg[0] == '\0' && !strncasecmp(go_request, "secure ", 7)) {
			do_shttp(0, go_request);
		} else if (nouse_msg[0] == '\0' && !strncasecmp(go_request, "connect ", 8)) {
			do_ssl(0, go_request);
		} else {
			process_request(0, go_request);
		}
	}

	time(&end_time);
	syslog(LLEV,"exit host=%.512s/%.20s cmds=1 in=%d out=%d user=%.100s duration=%d",
		rladdr,riaddr,inbytcnt, outbytcnt,autheduser, end_time - start_time);
	go_error(0, 0, NULL);	/* flush error messages */
	exit(0);
}


void 
net_timeout()
{
	syslog(LLEV,"Network timeout signal after %d seconds", timeout.tv_sec);
	http_exit(1);
}

void
trap_neterr()
{
	syslog(LLEV,"Network connection closed during write");
	http_exit(1);
}

/* Check to see if we even talk to this client! */

oktotalkto()
{
	Cfg	*cf;
	int	x;

	permissions = G_ALL;		/* Start with all */

	cf = cfg_get("hosts",confp);
	if( cf == (Cfg *)0){
		syslog(LLEV,"No http-gw 'hosts' rules found");
		syslog(LLEV,"deny host=%.512s/%.20s use of gateway",rladdr,riaddr);
		return 0;
	}
	while(cf != (Cfg *)0) {
		if(cf->argc < 1)
			goto skip;
		for(x = 0; x < cf->argc; x++) {
			if(cf->argv[x][0] == '-')
				break;
			if(hostmatch(cf->argv[x],riaddr)) {
				if(cf->flags & PERM_DENY) {
					syslog(LLEV,"deny host=%.512s/%.20s use of gateway",rladdr,riaddr);
					return(0);
				}
				syslog(LLEV,"permit host=%.512s/%.20s use of gateway (%.100s)",rladdr,riaddr, ver_str);
				return(acceptrule(cf) == 0);
			}
		}

skip:
		cf = cfg_get("hosts",(Cfg*)0);
	}
	syslog(LLEV,"deny host=%.512s/%.20s use of gateway (%.100s)",rladdr,riaddr, ver_str);
	return(0);
}


static	void
accept_setdest(v,c)
char	*v;
int	c;
{
	int	dests = 0;

	if(validests == (char **)0)
		validests = (char **)malloc(sizeof(char *) * 2);
	else {
		for(dests = 0; validests[dests] != (char *)0; dests++)
			;
		validests = (char **)realloc(validests,(dests + 2) * sizeof(char *));
	}
	if(validests == (char **)0)
		return;
	validests[dests] = v;
	validests[dests + 1] = (char *)0;
}


/* Gopher specific options processing
 */
struct pars_opts{
char *name;
int type;
}p_opts[] = {
{"all", G_ALL},
{"dir", G_DIR},
{"read",G_READ},
{"exec",G_EXEC},
{"wais",G_WAIS},
{"plus",G_PLUS},
{"write",G_WRITE},
{"ftp" ,G_FTP},
{"http",G_HTTP},
{"gopher",G_GOPHER},
/* Now come some of the ftp-gw style options */
{"retr",G_READ},
{"stor",G_WRITE},
/* for logging only */
{"type",G_CONTYPE},
{ NULL, G_NOPERM}
};


int	parse_options(s)
char *s;
{	struct pars_opts *t = p_opts;

	while(t->name){
		if( !strcasecmp(s, t->name))
			return t->type;
		t++;
	}
	return G_NOPERM;
}

static void accept_options(v, c)
char *v;
int	c;
{
	permissions |= parse_options(v);
}

static void
deny_options(v, c)
char *v;
int	c;
{	int x;

	x = parse_options(v);
	if( x != G_NOPERM){
		permissions &= ~x;
	}
}

static void
filter_options(v, c)
char *v;
int	c;
{
	filter_replies |= parse_options(v);
}



static void
log_options(v, c)
char *v;
int	c;
{
	logging |= parse_options(v);
}


static void
auth_options(v, c)
char *v;
int	c;
{
	auth_funcs |= parse_options(v);
	return;
}

acceptrule(c)
Cfg	*c;
{
	int	x, y;
	void	(*op)();

	for(x = 1; x < c->argc; x++) {
		/* skip nonoptions */
		if(c->argv[x][0] != '-')
			continue;

		/* options that take no parameters */
		if(!strcmp(c->argv[x],"-nooutput")) {
			permissions &= ~G_WRITE;	/* No write */
			blockoutput = 1;
			continue;
		}
		if(!strcmp(c->argv[x],"-noinput")) {
			permissions &= ~G_READ;		/* No read */
			blockinput = 1;
			continue;
		}
		if(!strcmp(c->argv[x],"-authall")){
			auth_funcs = G_ALL;
			continue;
		}
		if(!strcmp(c->argv[x],"-nojava")){ 	/* block java applets */
			nojava=1;
			continue;
		}
		if(!strcmp(c->argv[x],"-java")){ 	/* allow java applets */
			nojava=0;
			continue;
		}
		if(!strcmp(c->argv[x],"-safejava")){ 	/* selective java applets */
			nojava=2;
			continue;
		}
		if(!strcmp(c->argv[x],"-nojavascript")){ /* block javascript */
			nojavascript=1;
			continue;
		}
		if(!strcmp(c->argv[x],"-javascript")){ /* allow javascript */
			nojavascript=0;
			continue;
		}
		if(!strcmp(c->argv[x],"-safejavascript")){ /* selective javascript */
			nojavascript=2;
			continue;
		}
		if(!strcmp(c->argv[x],"-noactivex")){ 	/* block ActiveX applets */
			noactivex=1;
			continue;
		}
		if(!strcmp(c->argv[x],"-activex")){ 	/* allow ActiveX applets */
			noactivex=0;
			continue;
		}
		if(!strcmp(c->argv[x],"-safeactivex")){	/* selective ActiveX applets */
			noactivex=2;
			continue;
		}

		if(!strcmp(c->argv[x],"-gopher")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -gopher needs an argument.", c->ln);
				return 0;
			}
			strncpy(def_server, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}
		if(!strcmp(c->argv[x],"-httpd")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -httpd needs an argument.", c->ln);
				return 0;
			}
			strncpy(def_httpd, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}
		if(!strcmp(c->argv[x],"-name")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -name needs an argument.", c->ln);
				return 0;
			}
			strncpy(ourname, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}
		if(!strcmp(c->argv[x],"-ident")){
			if( x+1 >= c->argc){
				syslog(LLEV,"config line %d: -ident needs an argument.", c->ln);
				return 0;
			}
			strncpy(ident, c->argv[x+1], MAXHOSTNAMELEN+5);
			x++;
			continue;
		}

		/* options that take parameters and lists */
		op = 0;
		if(!strcmp(c->argv[x],"-dest"))
			op = accept_setdest;
		else if(!strcmp(c->argv[x],"-permit")){
			permissions = G_NOPERM;
			op = accept_options;
		}
		else if(!strcmp(c->argv[x],"-deny"))
			op = deny_options;
		else if(!strcmp(c->argv[x],"-filter")){
			filter_replies = G_NOPERM;
			op = filter_options;
		}
		else if(!strcmp(c->argv[x],"-log")){
			logging = G_NOPERM;
			op = log_options;
		}else if(!strcmp(c->argv[x],"-auth")){
			op = auth_options;
		}

		if(op == 0) {
			syslog(LLEV,"bad option line %d: %.512s",c->ln,c->argv[x]);
			continue;
		}
		if(++x >= c->argc) {
			syslog(LLEV,"malformed line %d: missing option",c->ln);
			continue;
		}
		if(!strcmp(c->argv[x],"{")) {
			while(1) {
				if(++x >= c->argc) {
					syslog(LLEV,"malformed line %d: missing option",c->ln);
					continue;
				}
				if(!strcmp(c->argv[x],"}"))
					break;
				(*op)(c->argv[x],c->ln);
			}
		} else
			(*op)(c->argv[x],c->ln);
	}
	return(0);
}

/* read a line from the connection */

getline(fd,buf,siz)
int		fd;
unsigned char	*buf;
int		siz;
{
	int	x = 0;
	int	ret = -1;

	while(1) {
		if(html_read(fd,(char *)&buf[x],1) != 1)
			goto done;

		/* get \r\n - read a char and throw it away */
		if(buf[x] == '\r') {
			if(html_read(fd,(char *)&buf[x],1) != 1)
				goto done;
			buf[x] = '\0';
			ret = x;
			goto done;
		}

		if(buf[x] == '\n') {
			buf[x] = '\0';
			ret = x;
			goto done;
		}

		if(buf[x] == IAC) {
			unsigned char	j;
			unsigned char	jbuf[4];

			if(html_read(fd,&j,1) != 1)
				goto done;

			switch(j) {
			case WILL:
			case WONT:
				if(html_read(fd,(char *)&j,1) != 1)
					goto done;
				jbuf[0] = IAC;
				jbuf[1] = DONT;
				jbuf[2] = j;
				if(net_write(fd,(char *)jbuf,3) != 3)
					goto done;
				continue;
			case DO:
			case DONT:
				if(html_read(fd,(char *)&j,1) != 1)
					goto done;
				jbuf[0] = IAC;
				jbuf[1] = WONT;
				jbuf[2] = j;
				if(net_write(fd,(char *)jbuf,3) != 3)
					goto done;
				continue;
			case IAC:
				x = 0;
				continue;
			case IP:
				if(html_read(fd,(char *)&j,1) != 1)
					goto done;
				if(j == DM)
					x = 0;
				continue;
			}
		}

		if(++x >= siz) {
			syslog(LLEV,"getline: buffer overrun");
			goto done;
		}
	}
done:
	return ret;
}


say_sub(fd,s)
int	fd;
char	*s;
{	int	n;
	n = strlen(s);

	return(net_write(fd,s,n) != n);
}

say(fd,s)
int	fd;
char	*s;
{
	return(sayn(fd,s,strlen(s)));
}



sayn(fd,s,n)
int	fd;
char	*s;
int	n;
{
	if(net_write(fd,s,n) != n)
		return(1);
	return(net_write(fd,"\r\n",2) != 2);
}



#ifdef	DEBUG

debugbind()
{
	static	int	x;
	int	nread;


	if( x == 0){
		x = make_conn(goport);
		if(listen(x,5) < 0) {
			syslog(LLEV,"Listen failed: %m");
			perror("listen");
			http_exit(1);
		}
	}
	if((nread = accept(x,0,0)) < 0) {
		syslog(LLEV,"Accept failed:%m");
		perror("accept");
		http_exit(1);
	}
	close(0);
	dup(nread);
	close(1);
	dup(nread);
}


#endif

/* shttp and ssl support (minimal implementation */

int do_shttp(fd, cmd)
int fd;
char *cmd;
{	char *p, *q, *namp;
	static	char	buf[8192];
	int cnt, rfd, ch;
	fd_set rdset;
	struct timeval timeval;

	rem_port = HTTPPORT;
	p = &cmd[7];
	if( strncasecmp(p,"shttp://", 8)){
		syslog(LLEV,"Non shttp request specified with SECURE method. Got %.80s", p);
		http_exit(1);
	}
	
	p = &p[8];
	
	cnt = -1;
	while(cnt < MAXHOSTNAMELEN-16){
		cnt++;
		if( *p == ' ' || *p == '\0' || *p == '/')
			break;
		rem_server[cnt] = *p++;
		ch = rem_server[cnt];
	}
	rem_server[cnt] = '\0';
	q = p;			/* start of path */
	p = rem_server;
	while(*p && *p != ':')p++;
	if( *p == ':'){
		*p++ = '\0';
		rem_port = atoi(p);
	}

	if (check_dest(0)) {
		return(1);
	}

	if((namp = maphostname(rem_server)) != (char *)0) {
		syslog(LLEV,"permit host=%.512s/%.20s destination=%.512s/%.20s port=%d",rladdr,riaddr,rem_server, namp, rem_port);
	} else
		syslog(LLEV,"permit host=%.512s/%.20s destination=%.512s port=%d",rladdr,riaddr,rem_server, rem_port);


	if((rfd = conn_server(rem_server,rem_port,0,buf)) < 0) {
                syslog(LLEV,"failed to connect to server %.512s (%d), %.512s", rem_server, rem_port, buf);
		return(1);
	}

        if( net_write(rfd,"SECURE ", 7) != 7){
		return 1;
	}
	outbytcnt += 7;
		
	cnt = strlen(q);
	if( net_write(rfd,q, cnt) != cnt){
		return 1;
	}
	outbytcnt += cnt;
	
	if( net_write(rfd, "\r\n", 2) != 2){
		return 1;
	}
	outbytcnt += 2;

	while(1){
		FD_ZERO(&rdset);
		FD_SET(0, &rdset);
		FD_SET(rfd, &rdset);
		timeval.tv_usec = 0;
		timeval.tv_sec = timeout.tv_sec;

		if( select(rfd+1, &rdset, (fd_set *)0, (fd_set *)0, &timeval) <= 0){
			syslog(LLEV,"select %m");
			return(1);
		}
		if( FD_ISSET(0, &rdset)){
			cnt = html_read(0, buf, 8192);
			if( cnt == 0)
				break;
			if( cnt < 0){
				break;
			}
			cnt = net_write(rfd, buf, cnt);
			if( cnt < 0){
				break;
			}
			outbytcnt += cnt;
		}
		if( FD_ISSET(rfd, &rdset)){
			cnt = html_read(rfd, buf, 8192);
			if( cnt == 0)
				break;
			if( cnt < 0){
				break;
			}
			cnt = net_write(0, buf, cnt);
			if( cnt < 0){
				break;
			}
			inbytcnt += cnt;
		}
	}
	return 0;
}


int do_ssl(fd, cmd)
int fd;
char *cmd;
{	char *p, *namp;
static	char		buf[8192];
	int cnt, rfd, ch;
	fd_set rdset;
	struct timeval timeval;

	p = &cmd[8];
	if(*p == '/')p++;
	if( *p == '/')p++;

	cnt = -1;
	while(cnt < MAXHOSTNAMELEN-16){
		cnt++;
		if( *p == ' ' || *p == '\0')
			break;
		rem_server[cnt] = *p++;
		ch = rem_server[cnt];
	}
	rem_server[cnt] = '\0';
	p = rem_server;
	while(*p && *p != ':')p++;
	if( *p == ':'){
		*p++ = '\0';
		rem_port = atoi(p);
	}else rem_port = SSLPORT;

	if (check_dest(0)) {
		return(1);
	}

	if((namp = maphostname(rem_server)) != (char *)0) {
		syslog(LLEV,"permit host=%.512s/%.20s destination=%.512s/%.20s port=%d",rladdr,riaddr,rem_server, namp, rem_port);
	} else
		syslog(LLEV,"permit host=%.512s/%.20s destination=%.512s port=%d",rladdr,riaddr,rem_server, rem_port);


	if((rfd = conn_server(rem_server,rem_port,0,buf)) < 0) {
                syslog(LLEV,"failed to connect to server %.512s (%d), %.512s", rem_server, rem_port, buf);
		return(1);
	}

	{ int xstate = 0;
/* simple state machine. */
		while (1) {
			if (html_read(0, buf, 1) != 1) return;
			if ((xstate == 0 || xstate ==1) && buf[0] == '\n') {
				break;
			} else if (xstate == 0 && buf[0] == '\r') {
				xstate = 1;
			} else if (xstate == 2 && buf[0] == '\n') {
				xstate = 0;
			} else xstate = 2;
		}
	}

        if( 19 != net_write(0,"HTTP/1.0 200 OK\r\n\r\n", 19)){
		return 1;
	}
	outbytcnt += 19;

	while(1){
		FD_ZERO(&rdset);
		FD_SET(0, &rdset);
		FD_SET(rfd, &rdset);
		timeval.tv_usec = 0;
		timeval.tv_sec = timeout.tv_sec;

		if( select(rfd+1, &rdset, (fd_set *)0, (fd_set *)0, &timeval) <= 0){
			syslog(LLEV,"select %m");
			return(1);
		}
		if( FD_ISSET(0, &rdset)){
			cnt = html_read(0, buf, 8192);
			if( cnt == 0)
				break;
			if( cnt < 0){
				break;
			}
			cnt = net_write(rfd, buf, cnt);
			if( cnt < 0){
				break;
			}
			outbytcnt += cnt;
		}
		if( FD_ISSET(rfd, &rdset)){
			cnt = html_read(rfd, buf, 8192);
			if( cnt == 0)
				break;
			if( cnt < 0){
				break;
			}
			cnt = net_write(0, buf, cnt);
			if( cnt < 0){
				break;
			}
			inbytcnt += cnt;
		}
	}
	return 0;
}

/* If list of valid destinations exist then check the destination */

int check_dest(sockfd)
int sockfd;
{	char **xp;
	int x;
	char *p;

	if( validests != NULL){
		p = rem_server;
		while(*p && *p!= ':')p++;
		if( *p == ':'){
			*p = '\0';
		}else
			p = NULL;

		for(xp = validests; *xp != NULL; xp++){
			if( **xp == '!' && hostmatch(*xp+1, rem_server)){
				goto denied;
			}else{
				if(hostmatch(*xp, rem_server))
					break;
			}
		}
		if( *xp == NULL){
			goto denied;
		}
		if(p)
			*p = ':';	/* put the colon back */
	}

	return 0;

denied:
	go_error(sockfd, 403, "Access denied to host %s", rem_server);
	syslog(LLEV,"deny host=%.512s/%.20s connect to %.512s", rladdr, riaddr, rem_server);
	return 1;
}
