/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 *		Peter J. Churchyard, Trusted Information Systems, Inc.
 *
 *	22-Aug-1994	Started to add the Gopher+ stuff. (pjc)
 *	13-Jun-1996	Screening functions for Java, JavaScript. (carl@hdshq.com)
 *	27-Jun-1996	Added screening for ActiveX. (carl@hdshq.com)
 */
static	char	RcsId[] = "$Header: /home/rmurphy/fwtk/fwtk/http-gw/RCS/http-gw.c,v 1.17 1998/02/06 23:32:20 rmurphy Exp $";

#include "http-gw.h"

#include "gio.h"

extern	int	nojava;
extern	int	nojavascript;
extern	int	noactivex;
void	seek_and_destroy();
static char http_buffer[8192];
static char reason[8192];
static	int	checkBrowserType = 1;

static void do_logging()
{	char *proto = "GOPHER";
	char *cmd = "get";

	if( rem_type & TYPE_FTP)
		proto = "FTP";
	else if( rem_type & TYPE_HTTPREQ)
		proto = "HTTP";

	if( rem_type & TYPE_DIR)
		cmd = "dir";
	else if( rem_type & TYPE_WRITE)
		cmd = "put";
	else if( rem_type & TYPE_WAIS)
		cmd = "search";
	else if( rem_type & TYPE_EXEC)
		cmd = "exec";

	if( in_perm_set(rem_type, logging)){
		syslog(LLEV,"log host=%.512s/%.20s protocol=%.100s cmd=%.100s dest=%.512s path=%.100s", rladdr, riaddr, proto, cmd, rem_server, rem_path);
	}
}

/* guess_gopher_type
 * Used to guess the GOPHER type of the object given a filename.
 *
 */

#define DEFINE_DATA
#include "ict.h"
#undef DEFINE_DATA

void cpystr(dst, src, len)
char *dst;
char *src;
int len;
{
	if (len == 0)  {
		syslog(LLEV, "fwtksyserr: cpystr called with zero size");
	} else {
		while (len > 1 && *src != '\0') {
			*dst++ = *src++;
			--len;
		}
		*dst = '\0';
	}
}

static	char	*html_readptr;
static	int	html_len;
static	char	*html_headers;
static	int	html_hlen;

int html_read(rfd, buf, cnt)
int rfd, cnt;
char *buf;
{	int ret;
	int x;

	if( rfd == -1){
		if(html_headers != NULL) {
			if(html_hlen < cnt)
				cnt = html_hlen;
			if(cnt != 0) {
				for (x=0; x < cnt; x++)
					*buf++ = *html_headers++;
				html_hlen -= cnt;
				if(html_hlen <= 0)
					html_headers = NULL;
				return cnt;
			}
			html_headers = NULL;
		}
		if( html_len <= 0)
			return 0;
		if( html_len < cnt)
			cnt = html_len;
		if( cnt == 0)
			return 0;
		if( html_readptr == NULL)
			return 0;
		for(x=0; x < cnt; x++)
			*buf++ = *html_readptr++;
		html_len -= cnt;
		return cnt;
	}
	ret = net_read(rfd, buf, cnt);

	return ret;
}

int send_internal(sockfd, buf, ishtml)
int sockfd;
char *buf;
int	ishtml;
{	char *p;
	struct intern_file *t = internal_files;
	int cnt, len;

	p = buf;
	if( *p == '/')p++;

	if( !strncmp(p, "-http-gw-internal-/", 19)){
		p+= 19;
		while(t->name){
			if( !strcmp(t->name, p)){
				len = *(t->size);
				p = (char *) t->data;

				if( ishtml){
					static char response[512];
					char *p1;

					p1 = strrchr(t->name, '.');
					if (p1 && !strncmp(p1, ".gif", 4)) {
						sprintf(response,
"HTTP/1.0 200 OK\r\nContent-type: image/gif\r\nContent-length: %d\r\n\r\n", len);
					} else {
						sprintf(response,
"HTTP/1.0 200 OK\r\nContent-type: text/html\r\nContent-length: %d\r\n\r\n", len);
					}
					html_headers = response;
					html_hlen = strlen(response);
					html_readptr = p;
					html_len = len;
					return 2;
				}else {
					while(len > 0){
						if( len >= 4096){
							cnt = net_write(sockfd, p, 4096);
						}else {
							cnt = net_write(sockfd, p, len);
						}
						if( cnt <= 0)
							break;
						outbytcnt += cnt;
						p += cnt;
						len -= cnt;
					}
				}
				return 1;
			}
			t++;
		}
	}

	return 0;
}



struct ext_table {
char	*ext;
int	type;
char	**mime;
}ext_tab[] = 
{
	{ "gif", 'g', &IMGIF},
	{ "zip", '5', NULL}, { "zoo", '5', NULL}, { "arj", '5', NULL}, { "arc",'5', NULL}, { "lzh", '5', NULL},	/* common dos archive formats */
	{ "exe", '9', NULL}, { "com", '9', NULL}, { "dll", '9', NULL}, { "lib",'9', NULL}, { "sys",'9', NULL},	/* Dos- windows extensions... */
	{ "jpg", 'I', &IMJPG}, { "jpeg", 'I', &IMJPG}, {"pict", 'I', NULL}, {"pct",'I', NULL},
	{ "tiff",'I', NULL}, { "tif", 'I', NULL}, { "pcx", 'I', NULL},
	{ "tar", '9', NULL}, { "z", '9', NULL}, { "gz", '9', NULL},
	{ "hqx", '4', NULL},		/* MAC binhex */
	{ "au", 's' , &AUBAS}, { "snd", 's', NULL}, { "wav", 's', NULL},	/* sounds */
	{ "doc", '9', NULL}, { "wri", '9', NULL}, { "pdf", '9', NULL},
	{ "html", 'h', &TXHTML},{ "htm", 'h', &TXHTML},	/* its html */
	{ "ps", '9', NULL},	/* for postscript use binary mode */
	{ "txt", '0', &TXPLN},
/* well known VMS types */
	{ "dir", '1', NULL},
	{ NULL,	'0', NULL}	/* This must be the last entry */
};

int guess_gopher_type(path)
char *path;
{	char *p;
	char *pend;
	char *ext;
	struct ext_table *t;

	if( path == NULL || *path == '\0')
		return '1';		/* null so must be a dir*/

	pend = path + strlen(path);
	switch (pend[-1]) {
	    case '*':
	    case '=':
	    case '@':
	    case '|':
		pend--;
	}
	p = rindex(path,'/');
	if( p != NULL && p + 1 == pend)
		return '1';		/* It is a directory */
/* check for well known file extensions... */
	if( p == NULL)
		p = path;
	ext = rindex(p, '.');
	if( ext != NULL){
		ext++;
		for(t = ext_tab; t->ext;t++)
			if( !strncasecmp(t->ext, ext, pend - ext))
				break;
		return t->type;
	}
	return '0';
}

char *gopher2mime(ch)
int ch;
{	struct ext_table *t;

	for(t = ext_tab; t->ext; t++)
		if( ch == t->type && t->mime != NULL)
			return *(t->mime);
	return NULL;
}



/* return a gopher type character given a URL type string.
 * used by the html URL translation stuff 
 */
struct gopher_type_rec {
char *proto;
int	len;
int	func;
char	type;
} gopher_type_tab[] = {
{ "gopher://",	9, 0, '1'},
{ "ftp://",	6, 2, '1'},
{ "file://",	7, 2, '1'},
{ "telnet://",	9, 1, '8'},
{ "ptelnet://",	10, 1, '8'},
{ NULL,		0, 0, '0'}
};

int gopher_type(buf)
char *buf;
{	int typech = '0';
	char *p;
	struct gopher_type_rec *t = gopher_type_tab;


	while(t && t->proto != NULL){
		if( !strncasecmp(buf, t->proto, t->len)){
			switch(t->func){
			default:
			case 0:
				p = &buf[t->len];
				p = index(p, '/');
				if( p){
					if( p[1])
						typech = p[1];
					else
						typech = t->type;
				}
				return typech;

			case 1:
				return t->type;
			
			case 2:
				p = &buf[t->len];
				if (index(p, '/') != NULL)
					p = index(p, '/') + 1;
				typech = t->type;
				if( p){
					p++;
					typech = guess_gopher_type(p);
				}
				return typech;
			}
		}
		t++;
	}

	return typech;
}




/* reply parse
 *
 * return a pointer to a static array of pointers to the tab seperated
 * fields of the buffer.
 *
 * NOTE! This routine over writes the tabs in the buffer with '\0's.
 *
 * returns NULL if it thinks something is wrong!
 */

static char *parse_vec[10];

char **reply_parse(buf)
char *buf;
{	char **pv;
	char *p;
	int cnt,x;

	pv = parse_vec;
	cnt = 0;
	*pv = NULL;

	while(buf && *buf && cnt < 9){
		*pv++ = buf;
		*pv = NULL;
		cnt++;
		while(*buf && *buf != '\t')buf++;
		if( *buf == '\t')
			*buf++ = '\0';
	}
	if( cnt >= 4)
		return parse_vec;
/* undo the mods */
	for(x=0; x < cnt; ){
		p = parse_vec[x];
		while(*p)p++;
		x++;
		if( x == cnt)
			*p = '\0';
		else
			*p = '\t';
	}
	return NULL;
}


/* parse a URL and return the results in the 'gopher' format
 */
static char url_parse_buf[MAX_URL_LEN];
static char url_host[MAXHOSTNAMELEN+1];

char **url_parse(str)
char *str;
{	char **pv;
	char *p, *q;
	int cnt;
	static char url_port[12];


	for(cnt=0; cnt < 10;cnt++)
		parse_vec[cnt] = NULL;
	if( str == NULL)
		str = "";

	cpystr(url_parse_buf, str, MAX_URL_LEN-1);
	str = url_parse_buf;

	p = str;
	while(*p && *p != ':' && *p != '/'){
		p++;
	}
	if( *p == ':'){
		*p++ = '\0';
		parse_vec[0] = str;	/* setup protocol */


		if( *p == '/' && p[1] == '/' ){	/* get host part */
			p += 2;
		}
		if( *p ) {
			int savch;

			parse_vec[2] = p;

			p++; /* Always use the first character (even when
				it is a '/' because there must be a hostname
				according to the URL specs */
			while(*p && *p != '/')p++;
			if( *p && *p == '/' ){
				savch = *p;
				*p = '\0';
				cpystr(url_host, parse_vec[2], MAXHOSTNAMELEN);
				parse_vec[2] = url_host;
				*p = savch;
			}

		}
		q = parse_vec[2];
		if( q != NULL){
			while(*q)q++;	/* skip to end */
			while( q != parse_vec[2] && *q != ':' && *q != '@')q--;
			if( *q == ':'){		/* found the colon first */
				*q++ = '\0';
				parse_vec[3] = q;
			}
		}
	}
	if( *p == '/' ){
		parse_vec[1] = p;
	}

	if( parse_vec[0] == NULL)
		parse_vec[0] = "http";

	if( parse_vec[1] == NULL)
		parse_vec[1] = "/";
	if( parse_vec[2] == NULL){
		parse_vec[2] = rem_server;
		if( rem_server[0] == '\0')
			parse_vec[2] = ourname;
	}
	if( parse_vec[3] == NULL){
		if( ourport && !strcmp(parse_vec[2], ourname)){
			sprintf(url_port,"%d", ourport);
			parse_vec[3] = url_port;
		}else if( !strcasecmp(parse_vec[0], "gopher"))
			parse_vec[3] = "70";
		else
			parse_vec[3] = "80";
	}

	return parse_vec;
}



/* This is the main guts of the gopher proxy
 * 
 * Here we process the request from the client and
 * pass it on to the server.
 */

int process_request(sockfd, buf)
int sockfd;
char *buf;
{	Cfg	*cf;
	int x;
	char *p;

/* Check to see if request is a proxy special. 
 * If not, try to hand off else it is an error */

	rem_type = proxy_form(sockfd, buf);
	if( (rem_type & TYPE_HTTPREQ) == 0){
		rem_type |= TYPE_GOPHER;
	}

	if( (MASK_BASE & rem_type) == TYPE_UNKNOWN){
	/*(NOT A SPECIAL FORM)*/

		if((rem_type & TYPE_LOCAL)== 0){
/*  See if it can be forwarded */

			if( can_forward(buf)){
				authenticated = 1;
			}else if( (rem_type & TYPE_HTTP) ){
/* default actions from a WWW client */
				def_port = def_hport;
				if( def_httpd[0]){
					cpystr(rem_server, def_httpd, MAXHOSTNAMELEN-1+6);
					strcpy(forward_host, rem_server);
					def_port = get_port(forward_host, def_port);
				}else{
					strcpy(rem_server, "-internal-");
					strcpy(buf,"-http-gw-internal-/noserver.html");
				}
				rem_type |= TYPE_HTTPREQ;
				if( *buf == '\0')
					buf = "/";
/* 27/11/94 pjc */
				if( *buf != '/'){
					strcpy(rem_path, buf);
					buf[0] = '/';
					strcpy(&buf[1], rem_path);
					rem_path[0] = '\0';
				}

			}else if(  def_server[0]){
/* default action from a GOPHER client */
				cpystr(rem_server, def_server, MAXHOSTNAMELEN-1+6);
				strcpy(forward_host, rem_server);
				def_port = get_port(forward_host, def_port);
			}else{
				rem_type = (rem_type & ~MASK_BASE) | check_req(sockfd, buf);
				go_error(sockfd, 404, "No default server configured to handle your request");
				go_error(sockfd, 404, "%s", buf);
				return 1;
			}
		}else{
			if( buf[0] == 'p' || buf[0] == 'P'){
				struct reproxy_rec *t = reproxy_list;

				while(t){
					x = strlen(t->protocol);
					if( !strncasecmp(buf, t->protocol, x)){
						do_plug(sockfd, buf, t);
						return 1;
					}
					t = t->next;
				}
			}
		}

		rem_type = check_req(sockfd, buf) | (rem_type & ~MASK_BASE);
		if( (MASK_BASE&rem_type) == TYPE_UNKNOWN){
			go_error(sockfd, 404, "Invalid path specified!");
			go_error(sockfd, 404, "%s", buf);
			return 1;
		}
		cpystr(rem_path, buf, MAX_URL_LEN-1);
	}

	do_chroot_etc();

	rem_typech = chk_type_ch;

/* check to see if we were denied with a reason */
	if( nouse_msg[0]){
		go_error(sockfd, 403, "%s", nouse_msg);
		return 0;
	}

/* Now look for gopher+ information in the request */
	rem_type = check_plus(sockfd, rem_path,rem_type);

	if( check_dest(0)) {
		syslog(LLEV,"deny host=%.512s/%.20s connect to %.512s:%d user=unknown" , rladdr, riaddr, rem_server, rem_port );
		go_error(sockfd, 403, "Access denied to destination %s:%d", rem_server, rem_port);
		return 1;
	}

	if( logging != G_NOPERM){	/* some logging flags are on */
		do_logging();
	}

	if( !can_do(sockfd, rem_type)){
		return 1;
	}

	if( rem_type & TYPE_HTTPREQ){
		forward_http(sockfd, rem_path, rem_server);
		return 0;
	}
	if( (rem_type & TYPE_HTTP) ){
		int hlen = 0;
		if( http_protocol[0] != '\0'){
 			copy_http_headers( -1, sockfd, 0, &hlen, G_NOPERM);
		}
	}
	if( rem_type & TYPE_FTP){
		forward_ftp(sockfd, rem_path, rem_server);
	}else{
		forward_gopher(sockfd, rem_path, rem_server);
	}
	return 0;
}

/* proxy form
 *
 * Test the path to see if it is one of our special formats.
 */

int proxy_form(sockfd, path)
int sockfd;
char *path;
{	char *p, *q;
	char lpath[2];
	char **pv;
	int ret, len;
	struct reproxy_rec *t = reproxy_list;

/* first look for http requests */
	ret = 0;
	if( (ret = http_form(path, &q)) ){
		p = strrchr(q, ' ');
		if( p){
			cpystr(http_protocol, p, 79);
			*p = '\0';
		}
		p = q;
		if( *p == '/')	/* if from normal WWW client */
			p++;
		else
			ret |= TYPE_PROXYCLIENT;
		unesc(rem_path, p, TYPE_HTTP);

		strcpy(path, rem_path);	/* copy it back */
		rem_path[0] = '\0';	/* re init since may be dirty */

		ret &= ~(TYPE_TEXT|TYPE_BINARY|TYPE_DIR); /* pjc 10/10/94 */
	}

	copy_with_escapes(orig_request, path, MAX_URL_LEN*3, 0);

	if( path[0] == 'p' || path[0] == 'P'){
		t = reproxy_list;

		while(t ){
			len = strlen(t->protocol);
			if( !strncasecmp(&path[1], t->protocol, len)){
				return ret | TYPE_LOCAL;
			}
			t = t->next;
		}
	}


	if( !strncmp(path,"-http-gw-internal-",18)){
		ret |= TYPE_LOCAL;
		sprintf(rem_server,"%s:%d", ourname, ourport);
	}

/* Now look for our special formats (URL's) */
	if( !strncmp(path, "gopher://", 9)){
		ret &= ~MASK_BASE;
		pv = url_parse(path);

		strcpy(rem_server, pv[2]);
		rem_port = atoi(pv[3]);
		def_port = rem_port;
		if( pv[1][0] == '/' ){
			if( pv[1][1]){
				ret = ret | check_req(sockfd, &pv[1][1]);
				strcpy(rem_path, &pv[1][2]);
			}else{
				ret = ret | check_req(sockfd, pv[1]);
				strcpy(rem_path, &pv[1][1]);
			}
		}else{
			ret = ret | check_req(sockfd, pv[1]);
			strcpy(rem_path, pv[1]);
		}
		return ret;
	}else if( !strncmp(path, "http://", 7)){
		ret &= ~MASK_BASE;
		pv = url_parse(path);

		strcpy(rem_server, pv[2]);
		rem_port = atoi(pv[3]);
		def_port = rem_port;
		strcpy(rem_path, pv[1]);
		ret |= TYPE_HTTPREQ;
		return ret | check_req(sockfd, rem_path);

	}else if( !strncmp(path, "ftp://", 6) || !strncmp(path, "file://", 7)){
		ret &= ~MASK_BASE;
		pv = url_parse(path);

		strcpy(rem_server, pv[2]);
		rem_port = atoi(pv[3]);
		def_port = rem_port;
		strcpy(rem_path, pv[1]);

		parse_ftp_login(rem_server);
		strcpy(rem_server, ftp_server);

		return check_req(sockfd, rem_path)|TYPE_FTP|ret;
	}
	return ret;
}


/* Look for HTTP methods... */
struct tag_http {
char	*method;
int	len;
int	type;
} http_methods[] = 
{
	{"GET ",	4, TYPE_READ|TYPE_HTTP},
	{"POST ",	5, TYPE_WRITE|TYPE_HTTP},
	{"HEAD ",	5, TYPE_READ|TYPE_HTTP|TYPE_HEAD},
	{NULL, 0, 0}
};

int http_form(path, ptr)
char *path, **ptr;
{	struct tag_http *t = http_methods;

	while(t->method != NULL){
		if( strncmp(path, t->method, t->len) == 0){
			*ptr = &path[t->len];
			bcopy(path, http_method, t->len);
			http_method[t->len] = '\0';
			return t->type;
		}
		t++;
	}
	return 0;
}

/* check request
 * 
 */

int check_req(sockfd, buf)
int sockfd;
char *buf;
{	char lbuf[2];
	char *p;
	char *tab;
	int ret;

	ret = TYPE_UNKNOWN;
	chk_type_ch = buf[0];	/* save it away */
	tab = index(buf, '\t');
	if(tab )
		*tab = '\0';

	switch(buf[0]){
	case '\0':
	case '\t':
	case '1':
		ret = TYPE_DIR;
		break;

	case '+':
		if( buf[1]){
			p = &buf[1];
			if( !strncmp(buf,"+INFO:", 6)){
				p = &buf[6];
				while(*p == ' ' || *p == '\t')p++;
			}
			ret = check_req(sockfd, p);
			if( (ret & MASK_BASE) != TYPE_UNKNOWN)
				break;
		}
		ret = TYPE_PLUS|TYPE_DIR;
		break;

	case 'I':
	case '9':
	case 's':
	case '5':
	case 'g':
	case ';':
		ret = TYPE_BINARY;
		break;

	case 'e':
		if(strncmp(buf, "exec:", 5)== 0){
			ret = TYPE_EXEC;
		}
		break;

	case 'f':
		if(strncmp(buf, "ftp:", 4) == 0){
			ret = parse_ftp(buf);
		}
		break;

	case 'w':
		if(strncmp(buf, "waissrc:", 8)== 0){
			ret = TYPE_WAIS|TYPE_DIR;
		}
		if( strncmp(buf, "waisdocid:", 10) == 0){
			ret = TYPE_WAIS;
		}
		break;

	case '7':
		ret = TYPE_WAIS|TYPE_DIR;
		break;
	
	case 'T':				/* TELNET / TN3270 */
	case '8':
		ret = TYPE_EXEC;
		break;

	case '2':
		ret = TYPE_EXEC;		/* CSO */
		break;

	case '/':
		lbuf[0]= guess_gopher_type(buf);
		lbuf[1]= '\0';
		ret = check_req(sockfd, lbuf);
		break;

	default:
		if( rem_type & TYPE_HTTPREQ){
			chk_type_ch = 'h';
		}
		ret = TYPE_TEXT;
		break;
	}
	if( tab)
		*tab = '\t';
	return ret;
}



int make_conn(port)
int port;
{	int x;
	int	reuse = 1;
	struct linger linger;
	struct	sockaddr_in	mya;

	(void) signal(SIGALRM, net_timeout);
	(void) alarm(timeout.tv_sec);

	if((x = socket(AF_INET,SOCK_STREAM,0)) < 0) {
		syslog(LLEV,"Socket failed:%m");
		goto broke;
	}

	if(setsockopt(x, SOL_SOCKET, SO_REUSEADDR, (char *) &reuse, sizeof(reuse)) < 0){
		syslog(LLEV,"setsockopt reuseaddr failed: %m");
		goto broke;
	}

	mya.sin_family = AF_INET;
	bzero(&mya.sin_addr,sizeof(mya.sin_addr));
	mya.sin_port = htons(port);
	if(bind(x,(struct sockaddr *)&mya,sizeof(mya))) {
		syslog(LLEV,"Bind failed: %m");
		goto broke;
	}

	linger.l_onoff = linger.l_linger = 0;
	if( setsockopt(x, SOL_SOCKET, SO_LINGER, (char *)&linger, sizeof(linger)) < 0){
		goto broke;
	}
	
	(void) alarm(0);
	(void) signal(SIGALRM, SIG_IGN);

	return x;

broke:
	return -1;
}

/* sockfd = connection to ftp server */

int port_num(sockfd, rfd, haddr)
int sockfd, rfd;
unsigned char *haddr;
{	struct sockaddr_in serv_addr;
	struct sockaddr_in data_addr;
	int length = sizeof(struct sockaddr_in );
	int port, err;
	unsigned char *addr;
	struct ifreq freq;
	char ifname[17];


	if( (err = getsockname(sockfd, (struct sockaddr *)&serv_addr, &length))!= 0){
		return 0;
	}

	length = sizeof(struct sockaddr_in );
	if( (err = getsockname(rfd, (struct sockaddr *)&data_addr, &length))!= 0){
		return 0;
	}


	port = ntohs(data_addr.sin_port);
	addr = (unsigned char *)&serv_addr.sin_addr;
	haddr[0] = addr[0];
	haddr[1] = addr[1];
	haddr[2] = addr[2];
	haddr[3] = addr[3];
	return port;
}


/* This routine checks the request type against the set of permission
 * bits to see if it is ok or not. Used by filter and logging. Can_do
 * is used to check permissions.
 */

int in_perm_set(req_type, set)
int req_type, set;
{	int base_type;

	base_type = req_type;

	if( (base_type & (TYPE_TEXT|TYPE_BINARY|TYPE_READ)))
		return( set & G_READ);

	if( (base_type & (TYPE_DIR)))
		return( set & G_DIR);

	if( (base_type & (TYPE_EXEC)))
		return( set & G_EXEC);

	if( (base_type & (TYPE_WRITE)))
		return( set & G_WRITE);

	if( (base_type & (TYPE_WAIS)))
		return( set & G_WAIS);

	return 0;
}



/* get_port
 *
 * returns the port from a string of the form
 * host:port
 */

int get_port(host,def_port)
char *host;
{	int port;
	char *p;

	port = def_port;
	if((p = rindex(host, ':'))!= NULL){
		*p++ = '\0';
		if( *p){
			port = atoi(p);
		}
	}
	return port;
}


/* forward_dir
 *
 * pass on a basic gopher menu (directory ) request.
 * and translate the reply.
 *
 */


int forward_dir(sockfd, buf, host)
int sockfd;
char *buf, *host;
{	int port;
	char *p, *q;
	int ftp_control, ftp_listen, ftp_data;
	struct sockaddr_in serv_addr;
	int length = sizeof( serv_addr);

	ftp_control = ftp_listen = ftp_data = -1;

	port = def_port;
	if( port == 0)
		port = GOPORT;
	if( rem_type & TYPE_FTP)
		port = FTPPORT;
	else if( rem_type & TYPE_HTTPREQ)
		port = HTTPPORT;

	port = get_port(host, port);
	rem_port = port;

	Debug( (debugf,"forward: %s to %s (%u)\n", buf, host, port))

	if( (!strcasecmp(host, ourname) && port == ourport) || 
		!strcmp(host,"-internal-")){
		if( send_internal(sockfd, buf, 0))
			return 0;
	}


	/* 20-oct-94 */
/* This is a mega kludge, check for search string, if not get one.. */
	if( (rem_type&(TYPE_WAIS|TYPE_HTTP)) == (TYPE_WAIS|TYPE_HTTP)){
		p = index(buf, '?');
		if( p ){
			*p = '\t';
		}else{
			q = rindex(buf,'\t');
			if( q != NULL){
/* looks like Gopher+ stuff, so re-request it without */
				*q = '\0';
				
				say(sockfd,"HTTP/1.0 302 Found");
				copy_with_escapes(orig_request, buf, MAX_URL_LEN*3, 0);
				sprintf(errbuf, "Location: http://%s:%u/gopher://%s:%d/7%s", ourname, ourport, host, port, orig_request);
				say(sockfd, errbuf);
				say(sockfd, "");
				return 0;
			}
			starthtml(sockfd," Searchable Index");
			say(sockfd,"<ISINDEX>");
			say(sockfd,"Enter the query string for the inquiry<br>");
			say(sockfd,buf);
			goendmenu(sockfd);
			return 0;
		}
	}

	if( (rfd = net_connect(host, port, 0, reason)) < 0){
		go_error(sockfd, 404, "Requested Information");
		go_error(sockfd, 404, "%s", buf);
		go_error(sockfd, 404, "is unavailable. Failed to connect to server");
		go_error(sockfd, 404, "%s (%d)", host, port);
		go_error(sockfd, 404, "reason: %s", reason);
		syslog(LLEV,"failed to connect to server %.512s (%d)", host, port);
		return 0;
	}

	say(rfd,buf);

	if(rem_type & TYPE_PLUS){
		if(rem_type & TYPE_WRITE){
			if( getline(sockfd, go_request, MAX_URL_LEN-1) < 0){
				goto broken;
			}
			if( can_do(sockfd, rem_type)){
				if( putblock(sockfd, rfd, go_request))
					goto broken;
			}else {
				putblock(sockfd, -1, go_request);
				goto broken;
			}
		}
	}

	if( !translate_reply(sockfd, rfd)){
		goto broken;
	}

	return 1;
broken:
	go_error(sockfd, 404, "Requested Information not available");
	return 0;
}


int forward_file(sockfd, buf, host)
int sockfd;
char *buf, *host;
{	int port;
	char *p;

	port = def_port;
	if( rem_type & TYPE_HTTPREQ)
		port = HTTPPORT;

	port = get_port(host, port);
	rem_port = port;

Debug( (debugf,"forward file: %s from %s (%u), %s:%d\n", buf, host, port, ourname, ourport))

	if( (!strcasecmp(host, ourname) && port == ourport) || 
		!strcmp(host,"-internal-")){
		if( send_internal(sockfd, buf, 0))
			return 0;
	}


	if( (rfd = net_connect(host, port, 0, reason)) < 0){
		go_error(sockfd, 404, "Requested Information");
		go_error(sockfd, 404, "%s", buf);
		go_error(sockfd, 404, "is unavailable. Failed to connect to server");
		go_error(sockfd, 404, "%s (%d)", host, port);
		go_error(sockfd, 404, "reason: %s", reason);
		syslog(LLEV,"failed to connect to server %.512s (%d)", host, port);
		return 0;
	}

	say(rfd,buf);

	if(rem_type & TYPE_PLUS){
		if(rem_type & TYPE_WRITE){
			if( getline(sockfd, go_request, MAX_URL_LEN-1) < 0){
				goto broken;
			}
			if( can_do(sockfd, rem_type)){
				if( putblock(sockfd, rfd, go_request))
					goto broken;
			}else {
				putblock(sockfd, -1, go_request);
				goto broken;
			}
		}
	}

	if( rem_typech == 'h'){	/* assume html so needs translation */
		trans_html_file(sockfd, rfd, "ftp", -1);
	}else{
		copyfiletype(sockfd, rfd);
	}

	return 1;

broken:
	return 0;
}


int forward_http(sockfd, buf, host)
int sockfd;
char *buf, *host;
{	int port, n, cnt;
	char *p;
	struct sockaddr_in serv_addr;
	int length = sizeof( serv_addr);
	int saved = sockfd;
	int	flag = 0;

	if( rem_port == 0){
		port = HTTPPORT;

		port = get_port(host, port);
		rem_port = port;
	}else{
		port = rem_port;
	}

	if( rem_typech == 'h' || rem_typech == 'H' || rem_typech == '1'){
		flag = 1;
	}


	copy_with_escapes(orig_request, buf, MAX_URL_LEN*3, TYPE_HTTP);

	if( default_url_filter[0] != '\0' && 
	    strpbrk(buf, default_url_filter) != NULL){
		go_error(sockfd, 404, "Requested URL is not valid");
		go_error(sockfd, 404, "failed to connect to http server %s (%d)", host, port);
		syslog(LLEV,"URL with invalid characters, %.512s (%d)", host, port);
		syslog(LLEV,"(%.1024s)", orig_request);
		return 0;
		
	}
	buf = orig_request;

	if( (!strcasecmp(host, ourname) && port == ourport) ||
		!strcmp(host,"-internal-")){
		n = send_internal(sockfd, buf, 1);
		if( n == 2){
			rfd = -1;
			goto frominternal;
		}
		if( n ){
			return 0;
		}
	}

	if( (rfd = net_connect(host, port, 0, reason)) < 0){
		go_error(sockfd, 404, "Requested Information");
		go_error(sockfd, 404, "%s", buf);
		go_error(sockfd, 404, "is unavailable. Failed to connect to server");
		go_error(sockfd, 404, "%s (%d)", host, port);
		go_error(sockfd, 404, "reason: %s", reason);
		syslog(LLEV,"failed to connect to http server %.512s (%d)", host, port);
		return 0;
	}

	if( http_method[0] == '\0')
		strcpy(http_method, "GET ");

	if( permissions & G_PLUS){
		sprintf(go_request,"%s%s%s", http_method, buf, http_protocol);
	}else{
		sprintf(go_request,"%s%s", http_method, buf);
	}
	if( rfd != -1)say(rfd, go_request);

frominternal:
	if( http_protocol[0]){	/* Was there http protocol info? */
		int hlen = 0;
		int rsaved = rfd;

		if( (permissions & G_PLUS) == 0)
			rfd = -1;
 		if( copy_http_headers(rfd, sockfd, (rem_type&TYPE_WRITE), &hlen, G_NOPERM) &&
			(rem_type&TYPE_WRITE)){
			rfd = rsaved;
			trans_html_file(rfd, sockfd, "http", hlen);
		}
		checkBrowserType = 0;
		if( rsaved != -1 && rfd == -1){
			go_error(sockfd,403,"Write operation not allowed!");
			return 0;
		}
		rfd = rsaved;
	}

/* Get possible response line (maybe an old server)*/
	if( get_http_response(sockfd, rfd)){

		if( copy_http_headers(sockfd, rfd, 1, NULL, logging)){
			trans_html_file(sockfd, rfd, "http", -1);
		}
	}else if( rem_type & TYPE_HEAD){
		return 1;
	}else{
		if( (rem_typech == 'h' || rem_typech == 'H' || rem_typech == '1')){
			trans_html_file(sockfd, rfd, "http", -1);
		}else{
			while( 1){
				cnt = sizeof(http_buffer);
				if( (n = html_read(rfd, http_buffer, cnt)) > 0){
					inbytcnt += n;
					if( sockfd != -1 && n != net_write(sockfd, http_buffer, n))
						goto broken;
				}else
					break;
			}
		}
	}

	return 1;

broken:
	return 0;
}

int copy_http_headers(sockfd, rfd,expect_data, lptr, logging)
int sockfd, rfd;
int expect_data, *lptr, logging;
{	int len, cnt;
	char *p;
	int n;
	static char content_len[80];
	static char content_type[513];
	int	tmpX;
	char	*tmpP;

	content_len[0] = '\0';
	content_type[0]= '\0';

	if( lptr)
		*lptr = 0;

	while(1){
		if( getline(rfd, go_request, MAX_URL_LEN-1) < 0){
			goto broken;
		}
		if( go_request[0] == '\0'){
			break;
		}
		if( !strncasecmp(go_request, "content-length:", 15)){
			cpystr(content_len, go_request, 79);
			content_len[79] = '\0';
			if( lptr){
				*lptr = atoi(content_len);
			}
		}else if( checkBrowserType &&
		      !strncasecmp(go_request, "user-agent:", 11) ) {
			if( sockfd != -1){
				 say(sockfd, go_request);
			}
			if (nojava == 2)
			    for (tmpX=0;
				tmpP=javaSafe[tmpX];
				tmpX++) 
					if (!strncmp(&go_request[12],
						tmpP,strlen(tmpP))) nojava = 0;
			if (nojavascript == 2)
			    for (tmpX=0;
				tmpP=livescriptSafe[tmpX];
				tmpX++) 
					if (!strncmp(&go_request[12],
						tmpP,strlen(tmpP))) nojavascript = 0;
			if (noactivex == 2)
			    for (tmpX=0;
				tmpP=activexSafe[tmpX];
				tmpX++) 
					if (!strncmp(&go_request[12],
						tmpP,strlen(tmpP))) noactivex = 0;
		}else if( !strncasecmp(go_request, "content-type:", 13)){
			cpystr(content_type, go_request, 512);
			content_type[511] = '\0';
			if( sockfd != -1){
				 say(sockfd, go_request);
			}
			if( logging & G_CONTYPE){
				syslog(LLEV,"content-type=%.512s", &go_request[13]);
			}
		}else if( !strncasecmp(go_request, "location:", 9) ){
			if(nojavascript) seek_and_destroy(go_request);
			p = &go_request[9];
			while(*p == ' ' || *p == '\t')p++;
			if( dont_touch(p) == 0){
				sprintf(errbuf, "Location: http://%s:%u/%s", ourname, ourport, p);
				if( sockfd != -1){
					say(sockfd, errbuf) ;
				}
			}else{
				if( sockfd != -1){
                                	 say(sockfd, go_request) ;
				}
			}
		}else if( !strncasecmp(go_request, "connection:", 11)){
			continue;
		}else if( !strncasecmp(go_request, "proxy-connection:", 17)){
			continue;
		}else {
			if( sockfd != -1){
                                 say(sockfd, go_request) ;
			}
		}
	}
	len = -1;
	if( content_len[0]){
		p = index(content_len, ':');
		if(p ){
			p++;
			while(*p == ' ' || *p == '\t')p++;
			len = atoi(p);
		}
	}
	if( lptr){
		*lptr = len;
	}
	if( content_type[0] ){
		p = index(content_type, ':');
		if( p == NULL){
			goto broken;
		}
		p++;
		while(*p == ' ' || *p == '\t')p++;

		if( !strncasecmp(p, "text/html", 9)){
			goto ishtml;
		}
/* not an html file? so just block copy */
		if( content_len[0]){
			if( sockfd != -1){
                                 say(sockfd,content_len) ;
			}
		}
		if( sockfd != -1){
                         say(sockfd,"") ;
		}

		if(expect_data && (rem_type & TYPE_HEAD)==0){
			while( len == -1 || len > 0){
				cnt = sizeof(http_buffer);
				if( len > 0 && cnt > len)
					cnt = len;
				if( (n = html_read(rfd, http_buffer, cnt)) > 0){
					inbytcnt += n;
					if( sockfd != -1)net_write(sockfd, http_buffer, n);
					if( len > 0)
						len -= n;
				}else
					break;
			}
		}
		return 0;
	}
ishtml:
	if( lptr){	/* its a POST so need content-length: */
		if(content_len[0] && sockfd != -1){
			 say(sockfd, content_len) ;
		}
	}
	if( sockfd != -1){
		say(sockfd,"") ;
	}
	if( rem_type & TYPE_HEAD){
		return 0;	/* flag as done */
	}

	return 1;

broken:
	return 0;
}

/* Look for the http response line.
 *
 * 29-jan-95
 * delay the output till have buffer or line of data
 */

int get_http_response(sockfd, rfd)
int sockfd, rfd;
{	int	x = 0;
	int	ret = -1;
	char 	*p;

	p = go_request;
	while(1) {
		if(html_read(rfd, p,1) != 1)
			goto done;
		x++;
		if( (*p & 0x80) )
			goto done;
		if( x > 0 && *p == '\n'){
			break;
		}
		p++;
		if( x == MAX_URL_LEN-2)
			goto done;
	}
	if( strncasecmp(go_request, "http", 4)){
		goto done;
	}
/* ok it is most likely to be a response line */
	if( x != 0){
		net_write(sockfd, go_request, x);
	}

	p[-1] = '\0';
	
	return 1;

/* Come here on error or odd response line */
done:
	{	char *mt = gopher2mime(rem_typech);

		if( mt != NULL)
			set_mime_type(mt);

/* the following is ifdef'ed out since it seems to nolonger be needed pjc. */
#ifdef NOTANYMORE
		if( http_protocol[0]){
			say(sockfd, "HTTP/1.0 200 OK");
			say(sockfd, "MIME-Version: 1.0");
			sprintf(errbuf,"Content-type: %s", mime_type);
			say(sockfd,errbuf);
			say(sockfd,"Content-Encoding: binary");
			say(sockfd,"Content-Transfer-Encoding: binary");
			say(sockfd,"");
		}
#endif
	}
	if( x != 0){
		net_write(sockfd, go_request, x);
	}

	return 0;
}


/* translate_reply
 *
 * translate returned gopher items into new format!
 * use gopher://xxx or ftp://xxx forms depending on whether
 * we used the gopher or ftp protocols.
 *
 * uses:	global variables rem_type, rem_port, ourname, ourport.
 * modifies:	go_request
 */

int translate_reply(sockfd, rfd)
int sockfd, rfd;
{	char **parse_vec;
	static char new_reply[MAX_URL_LEN];
	char *p;
	int i,type_rep;
	int port;
	static char ftp_port_str[10];
	extern int ftp_gensitedir;
	int gensitedir=0;

	port = rem_port;

	gostartmenu(sockfd);

	while(1){
		if( ftp_gensitedir &&
			(rem_path[0] == '\0' ||
				(rem_path[0] == '/' && rem_path[1] == '\0')
			) ){
			strcpy(go_request,"-internal-ftp-info-");
			gensitedir = 1;
		}else if( getline(rfd, go_request, MAX_URL_LEN-1) < 0){
			break;
		}
		if( rem_type & TYPE_FTP){
			trans_ftp_reply(rem_path, go_request);
		}

		parse_vec = reply_parse(go_request);
		if( gensitedir){
			parse_vec[0] = "0FTP Server Welcome Message";
			gensitedir = 0;
		}
		ftp_gensitedir = 0;
		if( parse_vec != NULL){
			type_rep = check_req(sockfd, parse_vec[0]);

			if( in_perm_set(type_rep, filter_replies)){
				continue;
			}
/* If the path points to a ftp: type then we want to translate it into an ftp URL */
			p = NULL;
			if( !strncasecmp(parse_vec[1], "ftp:", 4))
				p = parse_vec[1];
			else if( !strncasecmp(&parse_vec[1][1], "ftp:", 4))
				p = &parse_vec[1][1];
			if( p && p[4] != '/' && p[5] != '/'){
				type_rep |= TYPE_FTP;
				parse_vec[2] = &p[4];	/* the new host name */
				p = index(p, '@');
				if( p == NULL)
					p = "/";
				else
					*p++ = '\0';
				parse_vec[1] = p;	/* the new path */
	
				i = get_port(parse_vec[2], FTPPORT);
				sprintf(ftp_port_str, "%u", i);
				parse_vec[3] = ftp_port_str;
			}
	
			if( (rem_type & TYPE_FTP) || (type_rep & TYPE_FTP) ){
				p = parse_vec[1];	/* skip the type char and / */
				if( *p != '/' && p[1] == '/')
					p++;
				if( *p == '/')
					p++;
	
				if( forward_host[0] && !strcasecmp(forward_host, parse_vec[2])){
					sprintf(new_reply,"%s\t/%s\t%s\t%u",
						parse_vec[0], p,
						ourname, ourport);
				}else{
					sprintf(new_reply,"%s\tftp://%s/%s\t%s\t%u",
						parse_vec[0], 
						ftp_login(parse_vec[2], parse_vec[3]),
						p,
						ourname, ourport);
				}
			}else {
				switch(chk_type_ch){
				case '8':
					sprintf(new_reply,"%s\tptelnet://%s:%s/%s\t%s\t%u",
						parse_vec[0], parse_vec[2],
						parse_vec[3], parse_vec[1],
						ourname, ourport);
					parse_vec[4] = NULL;
					break;

				case '2':
					sprintf(new_reply,"%s\tpcso://%s:%s/22/%s\t%s\t%u",
						parse_vec[0], parse_vec[2],
						parse_vec[3], parse_vec[1],
						ourname, ourport);
					parse_vec[4] = NULL;
					break;
					
				default:
				    if( forward_host[0] && !strcasecmp(forward_host, parse_vec[2])){
				    	    sprintf(new_reply,"%s\t%s\t%s\t%u",
				    		    parse_vec[0], 
						    parse_vec[1],
				    		    ourname, ourport);
				    }else{
					    sprintf(new_reply,"%s\tgopher://%s:%s/%c%s\t%s\t%u",
						    parse_vec[0], parse_vec[2],
						    parse_vec[3], chk_type_ch,
						    parse_vec[1],
						    ourname, ourport);
				    }
					break;
				}
			}
			p = new_reply;
			while(*p)p++;
	
			for(i=4; parse_vec[i]; i++){
				*p++ = '\t';
				strcpy(p, parse_vec[i]);
				while(*p)p++;
			}
/* now apply any html mods to the new selector */
			if( rem_type & TYPE_HTTP){
				gopher_to_html(sockfd, rfd, new_reply, chk_type_ch);
			}else{
				say(sockfd, new_reply);
			}
		}else{
			
			if( rem_type & TYPE_HTTP){
				gopher_to_html(sockfd, rfd, go_request,' ');
			}else{
				say(sockfd, go_request);
			}
		}
	}
	if( rem_type & TYPE_HTTP){
		flush_gopher_to_html(sockfd);
	}
	goendmenu(sockfd);
	return 1;
}



/* copyfiletype
 */

int copyfiletype(sockfd, rfd)
int sockfd, rfd;
{	int pre = 0;
	int	cnt;
	int	first = 1;
	int	x;
	char	*bp;
	int	sentheader = 0;

#ifdef Notdef
	if( (rem_type & (TYPE_HTTP|TYPE_TEXT)) == (TYPE_HTTP|TYPE_TEXT)){
		gostarthtml(sockfd);
		pre = 1;
		first = 0;
	}
#endif
	if( (rem_type & TYPE_HTTP) && http_protocol[0] != '\0'){
		char *mt = gopher2mime(rem_typech);

		if( mt)
			set_mime_type(mt);

		if( mime_type[0]){
			say(sockfd, "HTTP/1.0 200 OK");
			say(sockfd, "MIME-Version: 1.0");
			sprintf(go_request,"Content-type: %s", mime_type);
			say(sockfd,go_request);
			say(sockfd,"Content-Encoding: binary");
			say(sockfd,"Content-Transfer-Encoding: binary");
			sentheader = 1;
		}
	}
	while(1){
		bp = errbuf;
		
		cnt = html_read(rfd, errbuf, sizeof(errbuf));

		if( first && (rem_type & TYPE_PLUS)){
			first = 0;
			if( errbuf[0] == '+'){
				int length = 0;

				for(x=1; x < cnt; x++){
					if( errbuf[x] == '\r')
						errbuf[x] = '\0';
					if( errbuf[x] == '\n'){
						x++;
						break;
					}
				}
				if( sentheader){
					length = atoi(&errbuf[1]);
/* 7/28/95 pjc Only add content-length if greater than 0 */
					if( length > 0){
						sprintf(go_request,"Content-length: %d", length);
						say(sockfd, go_request);
					}
				}
				
				cnt -= x;
				bp += x;
				if( cnt == 0){
					if( sentheader){
						sentheader = 0;
						say(sockfd, "");
					}
					continue;
				}
			}
		}
		if( sentheader){
			sentheader = 0;
			say(sockfd, "");
		}
		if( cnt == 0)
			break;
		if( cnt < 0)
			goto broke;
		if(net_write(sockfd, bp, cnt) != cnt){
			goto broke;
		}
		inbytcnt += cnt;
	}
	if( pre ){
		goendhtml(sockfd);
	}

	return 0;
broke:
	syslog(LLEV,"connection broke");
	http_exit(1);
	return 0;
}


/* check request type against permissions */
struct req_perm {
int	type;
int	perm;
char	*msg;
}req_perm_table[] = 
{	
	{	TYPE_DIR,	G_DIR,	"Not permitted to list directories"},	
	{	TYPE_TEXT,	G_READ, "Not permitted to read files"},		
	{	TYPE_BINARY,	G_READ, "Not permitted to read files"},		
	{	TYPE_EXEC,	G_EXEC, "Not permitted to exec commands"},
	{	TYPE_WAIS,	G_WAIS,	"Not permitted to do search commands"},	
	{	TYPE_PLUS,	G_PLUS, "Not permitted to do Gopher+ requests"},
	{	TYPE_FTP,	G_FTP,	"Not permitted to do ftp requests"},
	{	TYPE_HTTPREQ,	G_HTTP,	"Not permitted to do http requests"},
	{	TYPE_GOPHER,	G_GOPHER,"Not permitted to do gopher requests"},
	{	TYPE_WRITE,	G_WRITE,"Not permitted to write data"},
	{	TYPE_UNKNOWN,	G_NOPERM,"Not permitted to perform request"},		
	{	0,		G_NOPERM,"OOPs, proxy error! contact <pjc@tis.com>"},		
};


int can_do_sub(sockfd, req)
int sockfd, req;
{	int x;

	for(x=0; x < sizeof req_perm_table;x++){
		if( (req_perm_table[x].type & req) == req_perm_table[x].type)
			break;
	}
	if(permissions & req_perm_table[x].perm){
		if( authenticated || (auth_funcs & req_perm_table[x].perm)==0){
			return 1;
		}
	}
/* Not allowed to do it. */
	if( req_perm_table[x].msg == NULL ){
		can_do(sockfd, TYPE_UNKNOWN);
		return 0;
	}

	go_error(sockfd, 403, "%s", req_perm_table[x].msg);
	return 0;
}


/* First check by protocol then by function */

int can_do(sockfd, req)
int sockfd, req;
{	int x;

	x = req & ~MASK_BASE;

	if( x && !can_do_sub(sockfd, x)){
		return 0;
	}
	return can_do_sub(sockfd, req & MASK_BASE);
}


/* set_mime_type
 */

int set_mime_type(str)
char *str;
{	char *p, *q;

	cpystr(mime_type, str, 127);
	p = index(mime_type, '\t');
	if( p )*p = '\0';

	p = index(mime_type, '/');
	if( p == NULL){
Debug((debugf,"Odd mime type %s ignored\n", mime_type))
		mime_type[0] = '\0';
	}
	return 0;
}




/* check plus
 *
 * check the selector for Gopher+ forms
 * If a mime type is specified, set the mime_type variable.
 */

int check_plus(sockfd, buf, type)
int sockfd;
char *buf;
int type;
{	char *p;
	
	p = index(buf, '\t');
	if( p){
		if(rem_typech == '7' || rem_typech == 'w' || rem_typech == 'W')
			p = index(&p[1], '\t');
	}
	if( p){
		p++;
		type |= TYPE_PLUS;

		if( *p == '+' && p[1] != '\t'){
			set_mime_type(&p[1]);
		}
		
/* look for the more data flag */
		p = index(p, '\t');
		if( p ){
			if( p[1] == '1')
				type |= TYPE_WRITE;
			else{
				if( p[1] == '.')
					*p = '\0';
			}
		}
	}
	
	return type;
}


/* put block
 *
 * Put a gopher+ block.
 *
 * eob specifies how the block will be terminated.
 */

int putblock(sockfd, rfd, eob)
int sockfd, rfd;
char *eob;
{	int	length;		/* length or -1 or -2 */

	say(rfd, eob);		/* pass on the length stuff */
	if(*eob == '+')
		eob++;
	if(*eob == '-')
		length = -atoi(&eob[1]);
	else
		length = atoi(eob);

	if( length > 0){
		while(length){
			int cnt = length;
			
			if( cnt > sizeof(http_buffer))
				cnt = sizeof(http_buffer);
			cnt = html_read(sockfd, http_buffer, cnt);
			if( cnt <= 0)
				break;
			if( rfd != -1){		/* allow write? */
				if( net_write(rfd, http_buffer, cnt) != cnt)
					break;
				outbytcnt += cnt;
			}
			length -= cnt;
		}
	}else {

		while(1){
			if( getline(sockfd, go_request, MAX_URL_LEN-1) < 0)
				break;
			if( rfd != -1){
				say(rfd, go_request);
				outbytcnt += strlen(go_request)+2;
			}
			if( go_request[0] == '.' && go_request[1] == '\0')
				break;
		}
	}
	return 0;
}

/* some HTTP specific stuff */
int alpha(ch)
int ch;
{
	if( (ch >= 'a' && ch <= 'z') ||
	    (ch >= 'A' && ch <= 'Z'))
		return 1;
	return 0;
}

int alphanum(ch)
int ch;
{
	if( alpha(ch))return 1;
	if( ch >= '0' && ch <= '9')return 1;
	return 0;
}

/* Routine trans_html_file translates incoming html -
 * Scans HTML datastreams for the purpose of rewriting certain
 * sections. 
 * 
 * Maintains html parsing state; The context is critical to proper
 * handling of special characters and tags. 
 *
 * Will locate tags of <A>, <IMG> and <FORM> and rewrite the tags 
 * to prepend our http-gw address. This allows browsers that are not 
 * proxy aware, or not configured, to utilize this program. 
 *
 * Additionally, this routine implements policy decisions to deny 
 * JAVA, ActiveX and/or JavaScript applets to pass to the client.
 * The policy is indicated by new keywords on the hosts permissions
 * entry, and by the new policy and default-policy entries in the 
 * netperm-table files' http-gw section. See hmain.c for details.
 *
 * Carl V. Claunch
 * Hitachi Data Systems
 * carl@hdshq.com
 */
 

int trans_html_file(sockfd, rfd, protocol, length)
int sockfd;				/* client side socket */
int rfd;				/* server side socket */
int length;				/* length to copy or -1 */
char *protocol;				/* protocol to pass to trans_anchor */
{	int cnt = 0;			/* length of html processed so far */
	int new_cnt = 0;		/* modified html length */	
	int ch;				/* int representation of input char */
	char buf[2];			/* input buffer */
	static char element[80];	/* name of this element */
	static char attribute[80];	/* name of the attribute */
	static char value[1028];	/* attribute value */
	char *p;			/* march thru above fields with this */
	int quoted = 0;			/* current quote character or 0 */
	int in_blocked = 0;		/* 1 if we are blocking part of HTML */
	int got_close;			/* 1 if found a slash so match is close */
	int check_now = 0;		/* 1 if done with field, time to check */
	char bad_tag[8];		/* remembers script or applet */
	char bad_msg[50];		/* message to replace offending stuff */
	int prev;			/* int representation of previous char */
	enum {				/* state of html parsing */
		IN_BODY,		/* normal body of html */
		IN_TAG,			/* inside <....> */
		IN_BEGIN_COMMENT,	/* inside <! . . . > */
		IN_COMMENTS,		/* inside <!-- . . . -- -- . . . --> */
		IN_END_COMMENT,		/* looking for closing > */
		IN_ELEMENT,		/* inside first word of tag */
		IN_WS_1,		/* whitespace before attribute name */
		IN_ATTRIBUTE,		/* inside <.. xxx [= yyy] > */
		IN_WS_2,		/* whitespace after attribute name */
		IN_WS_3,		/* whitespace after = detected */
		IN_VALUE		/* inside value part of attribute */
		} state = IN_BODY;	/* initial state is normal body */
#define iselement(ch) ( isalpha(ch) || isdigit(ch) || (ch == '.') || (ch == '-') )

	buf[1] = 0;
	bad_tag[0] = 0;

	while( 1 ){
		/* look for end of input, based on content_length: header */
		if( cnt == length) {
			break;
		}

		if( html_read(rfd, buf, 1) <= 0) {
			break;	
		}

		inbytcnt++;
		cnt++;
		if(!in_blocked) new_cnt++;

		ch = buf[0];

		/* now we scan based on context (state) */
		switch (state) {
		    case IN_BODY:
			/* only meaningful character in this state is < */
			if (ch == '<') {
				got_close = 0;
				state = IN_TAG;
			}
			break;
		    case IN_TAG:
			switch (ch) {
			    /* ! after < starts comment block */
			    case '!':
				if ((prev == '<') && (!got_close)) 
					state = IN_BEGIN_COMMENT;
				break;

			    /* close tag found */
			    case '/':
				if ((prev == '<') && (!got_close)) {
					got_close = 1;
					/* next pass prev will be < */
					ch = prev;
				}
				break;

			    /* end of tag found */
			    case '>':
				state = IN_BODY;
				got_close = 0;
				break;

			    /* begin element or attribute */
			    default:
				if (!isalpha(ch)) break; /* must be alpha */
				if (prev != '<') break; /* no space before */
				state = IN_ELEMENT;
				p = element;
				*p++ = ch;
				*p = 0;
				break;
			}
			break;

		    case IN_ELEMENT:
			switch (ch) {
			    case '>':
			        /* end of element, time to check */
				state = IN_BODY;
				check_now = 1;
				break;

			    case '=':
			        /* invalid so retard state */
				state = IN_BODY;
				check_now = 1;
				break;

			    case ' ':
			    case '\t':
			    case '\r':
			    case '\n':
			        /* whitespace so begin skipping */
				state = IN_WS_1;
				check_now = 1;
				break;

			    default:
				/* only valid chars are alpha, digits, ., _ */
				if (!iselement(ch)) {
					state = IN_BODY;
					check_now = 1;
				} else {
					*p++ = ch;
					*p = 0;
					if ((p - element) > 80) p--;
				}
				break;
			}
			/* see if we are ready to check the field yet */
			if (!check_now) break;
			check_now = 0;

			/* now we check the element for matches
			   first look for close of blocking */
			if (in_blocked && 
			    got_close && 
			    !strcasecmp(bad_tag,element)) {
				state = IN_BODY;
				got_close = 0;
				in_blocked = 0;
				net_write(sockfd,"fwtk removed ",13);
				net_write(sockfd,bad_tag,strlen(bad_tag));
				net_write(sockfd," at firewall></fwtk",19);
				new_cnt += strlen(bad_tag) + 32;
				element[0] = 0;
				break;
			}

			/* dont write out if we are skipping now */
			if (in_blocked) break;

			/* now look for the JAVA, ActiveX or JavaScript */
			if ( (nojava && !strcasecmp(element,"applet")) 
					    ||
			     (nojavascript && !strcasecmp(element,"script"))
					    ||
			     (noactivex && !strcasecmp(element,"object"))) {
				strcpy(bad_tag,element);
				in_blocked = 1;
				break;
			}

			/* now write out saved field element */
			got_close = 0;
			net_write(sockfd,element,strlen(element));
			break;

		    case IN_WS_1:
			switch (ch) {
			    case '>':
				state = IN_BODY;
				break;

			    case ' ':	
			    case '\t':	
			    case '\r':	
			    case '\n':	
				break;

			    default:
				if (!isalpha(ch)) {
					state = IN_TAG;
					break;
				}
				state = IN_ATTRIBUTE;
				p = attribute;
				*p++ = ch;
				*p = 0; 
				break;
			}
			break;

		    case IN_ATTRIBUTE:
			   
			switch (ch) {

			    /* end of value, time to check */
			    case '>':
				state = IN_BODY;
				check_now = 1;
				break;

			    case ' ':
			    case '\t':
			    case '\r':
			    case '\n':
				state = IN_WS_2;
				check_now = 1;
				break;

			    case '=':
				state = IN_WS_3;
				check_now = 1;
				break;

			    default:
				/* only valid chars are alpha, digits, ., _ */
				if (!iselement(ch)) {
					state = IN_TAG;
					check_now = 1;
				} else {
					*p++ = ch;
					*p = 0;
					if ((p - attribute) > 80) p--;
				}
				break;
			}

			/* test only when field is completed */
			if (!check_now) break;
			check_now = 0;

			/* look for onxxxxx= JavaScript and rewrite */
			if (nojavascript && !strncasecmp(attribute,"on",2)) {
				attribute[0] = 'n';
				attribute[1] = 'o';
			}

			/* now write out the field */
			if (!in_blocked)
				net_write (sockfd,attribute,strlen(attribute));
			break;

		    case IN_WS_2:
			switch (ch) {
			    case '>':
				state = IN_BODY;
				break;

			    case ' ':	
			    case '\t':	
			    case '\r':	
			    case '\n':	
				break;

			    case '=':
				state = IN_WS_3;
				break;

			    default:
				if (!isalpha(ch)) {
					state = IN_TAG;
					break;
				}
				state = IN_ATTRIBUTE;
				p = attribute;
				*p++ = ch;
				*p = 0; 
				break;
			}
			break;

		    case IN_WS_3:
			switch (ch) {
			    case '>':
				state = IN_BODY;
				break;

			    case ' ':	
			    case '\t':	
			    case '\r':	
			    case '\n':	
				break;

			    case '"':
			    case '\'':
				quoted = ch;
				state = IN_VALUE;
				p = value;
				*p++ = ch;
				*p = 0;
				break;

			    default:
				state = IN_VALUE;
				p = value;
				*p++ = ch;
				*p = 0; 
				break;
			}
			break;

		    case IN_VALUE:

			/* quotes significant in this field */
			if (quoted) {
				*p++ = ch;
				*p = 0;
				if ((p - value) > 1026) p--;
				if (ch == quoted) {
					quoted = 0;
					state = IN_WS_1;
					check_now = 1;
				}
			} else
			switch (ch) {

			    /* end of tag */
			    case '>':
				state = IN_BODY;
				check_now = 1;
				break;

			    case ' ':
			    case '\t':
			    case '\r':
			    case '\n':
				state = IN_WS_1;
				check_now = 1;
				break;

			    /* save another character */
			    default:
				*p++ = ch;
				*p = 0;
				if ((p - value) > 1026) p--;
				break;
			}

			/* check following only when field complete */
			if (!check_now) break;
			check_now = 0;
			/* we care only about HREF, SRC or ACTION 
			   whose value is a URL that we may rewrite */
			if (!strcasecmp(attribute,"href") ||
			    !strcasecmp(attribute,"src") ||
			    !strcasecmp(attribute,"action")) 
				trans_anchor(attribute,value,protocol);

			/* we look for the <META HTTP-EQUIV..CONTENT= and 
			   rewrite any javascript: URL */
			if ( 	    nojavascript
					&&
			    (!strcasecmp(element,"meta")) 
					&&
			    (!strcasecmp(attribute,"content"))) 
				    seek_and_destroy(value);

			/* Quote at end removed to avoid double write*/
			p = value + strlen(value) - 1;
			if ((*p == '"') || (*p == '\'')) *p = 0;

			/* write out the saved (or rewritten) field now */
			if (!in_blocked)
				net_write(sockfd,value,strlen(value));
			break;

		    case IN_BEGIN_COMMENT:
			switch (ch) {
			    /* two -- in row start a comment block */
			    case '-':
				if (prev == '-') {
					state = IN_COMMENTS;
					ch = 0;
				}
				break;

			    /* > will close the comment group */
			    case '>':
				state = IN_BODY;
				break;

			    default:
				break;
			}
			break;

		    case IN_COMMENTS:
			switch (ch) {
			    case '-':
				if (prev == '-') {
					state = IN_END_COMMENT;
					ch = 0;
				}
				break;

			    default:
				break;
			}
			break;

		    case IN_END_COMMENT:
			switch (ch) {
			    case '>':
				state = IN_BODY;
				break;

			    case ' ':
			    case '\n':
			    case '\t':
			    case '\r':
			    case '-':
				ch = 0;
				break;

			    default:
				state = IN_COMMENTS;
				ch = 0;
				break;
			}
			break;

		    default:
			break;
		}

		/* copy over except while we are building the
		 * elements in a tag, or when we are rewriting
		 * blocked javascript activeX or java applets */
		if (!in_blocked && (
			(state != IN_ELEMENT)
				&&
			(state != IN_ATTRIBUTE)
				&&
			(state != IN_VALUE))) {
			write(sockfd, buf, 1);
		}
		prev = ch;
	}
	/* if we ended due to EOF or content_length but were building up
	   one of our fields, dump it out and go away */
	if (in_blocked) {
		net_write(sockfd,"fwtk removed ",13);
		net_write(sockfd,bad_tag,strlen(bad_tag));
		net_write(sockfd," at firewall></fwtk></html>",27);
		new_cnt += (strlen(bad_tag) + 40);
	} else if(state == IN_ELEMENT) {
		net_write(sockfd,element,strlen(element));
		new_cnt += strlen(element);
	} else if(state == IN_ATTRIBUTE) {
		net_write(sockfd,attribute,strlen(attribute));
		new_cnt += strlen(attribute);
	} else if(state == IN_VALUE) {
		net_write(sockfd,value,strlen(value));
		new_cnt += strlen(value);
	}

	/* return size of new html - never referenced by callers */
	return new_cnt;
}

/* Translate an anchor */
/* has to deal with relative
 * and absolute forms...
 *
 * Don't change xxx://yyy 
 */
static char newbuf[1024];

char *new_anchor(buf, protocol)
char *buf;
char *protocol;
{
	char *p, *q, *path,*path2;
	int cnt, ch, len, ch2;

	p = index(buf,':');
	if( p ){
		sprintf(newbuf, "%s", buf);
		return newbuf;
	}

/* not an absolute anchor */
	if( !strncmp(buf, "//", 2)){
		sprintf(newbuf, "%s:%s", protocol, buf);
		return newbuf;
	}

	if( buf[0] == '/'){
		sprintf(newbuf,"%s://%s:%u%s", protocol, rem_server, rem_port, buf);
		return newbuf;
	}

	p = strrchr(rem_path, '/');
	if( p){
		p++;
		ch = *p;
		*p = '\0';
		sprintf(newbuf, "%s://%s:%u%s%s", protocol, rem_server, rem_port, rem_path, buf);
		*p = ch;
		return newbuf;
	}

	return buf;
}

/* maybe_plug_it *
 * see if this URL needs to use plug gateway interface.
 */


char *maybe_plug_it(oldurl)
char *oldurl;
{	char *ret;
	struct reproxy_rec *t = reproxy_list;
	int len;

	ret = oldurl;
	while( t && t->protocol != NULL){
		len = strlen(t->protocol);
		if( !strncasecmp(oldurl, t->protocol, len)){
			sprintf(newbuf,"p%s", oldurl);
			return newbuf;
		}
		t = t->next;
	}

	return ret;
}

int filter_anchor(attrib, oldurl)
char *attrib, *oldurl;
{	int ret = 0;
	char abuf[2];
	int url_type;

	abuf[0] = gopher_type(oldurl);
	abuf[1] = '\0';

	url_type = check_req(0, abuf);

	if( in_perm_set(url_type, filter_replies)){
Debug((debugf,"Remove it...\n"))
		return 1;
	}
	return ret;
}

/* Dont touch things that are INTERNAL things like Mosaic ICONS */
char *no_touch_tab[] = {
"internal-gopher-menu",
"internal-gopher-binary",
"internal-gopher-text",
NULL
};

int dont_touch(url)
char *url;
{	char **t = no_touch_tab;

	if( tflag){
		return 1;
	}

	if( rem_type & TYPE_PROXYCLIENT){
		return 1;
	}

	if( forward_host[0]){
		if( dont_proxy(url))
			return 0;	/* handled later */
		return 1;
	}

	while(*t){
		if( !strcasecmp(url, *t)){
			return 1;
		}
		t++;
	}

	if( url[0] == '#')
		return 1;
	return 0;
}


char *un_proxy( p)
char *p;
{	char **pv;

	pv = url_parse(p);

	if( def_server[0] && hostmatch(def_server, pv[2])){
Debug((debugf, "UN_PROXY: %s\n", p))
	}

	return p;
}

/* may modify p */

int dont_proxy(p)
char *p;
{	char **pv;

	pv = url_parse(p);

/* don't proxy if from forwarded server */
	if( hostmatch(forward_host, pv[2]) ){
		if( atoi(pv[3]) == forward_port){
			strcpy(p, pv[1]);
			return 1;
		}
	}

	return 0;
}

/* Trans_anchor will now update the URL as needed when
   called from trans_html_file. It is passed an attribute
   name and the value field. It will accomplish the following:
	recognize protocols to be handled by plug-gw connection
	filter URLs based on netperm-table entries
	skip filtering for proxy aware clientsr
	skip filtering for internal use URLs
	convert relative to absolute form
	add protocol prefix to URL when needed
	skip proxying for case with this host
	if desired, use gopher to handle gopher:, ftp: and file: protocols
   This routine is stripped down since trans_html_file now does the 
   basic parsing.
 */

int trans_anchor(attribute, value, protocol)
char *attribute;			/* contents of attribute name */
char *value;				/* contents of attribute value */
char *protocol;				/* protocol used */
{	int ch;				/* used to hold a character */
	int typech;			/* gopher type character */
	char *p;			/* general pointer */
	char *oldurl;			/* general pointer */
	static char newurl[1200];	/* field for rewriting */
	int quotes = 0;			/* remember quotes for URL */

	/* strip off quotes if wrapping URL, and remember */
	if ((*value == '"') || (*value == '\'')) {
		quotes = *value;
		value++;
		value[strlen(value) - 1] = 0;
	}

	/* if handled by plug-gw, prefix p to URL */
	oldurl = maybe_plug_it(value);

	/* remove javascript: URLs if we are screening */
	if ( 		   nojavascript 
				&& 
	       ( (!strncasecmp(oldurl,"javascript:",11))
				||
		 (!strncasecmp(oldurl,"livescript:",11)) ) ) {
			sprintf(newurl,"filtered://-removed-");

	/* match and remove URLs we are restricting */
	} else if( filter_anchor(attribute, oldurl)){
		sprintf(newurl,"filtered://-removed-");

	/* internal use URLs should not be modified */
	}else if( dont_touch(oldurl)){
		sprintf(newurl,"%s", oldurl);

	/* proxy aware client already does the right thing */
	}else if( rem_type & TYPE_PROXYCLIENT){
		sprintf(newurl,"%s", oldurl);

	/* lets rewrite */
	}else{
		/* convert relative to absolute, add protocols */
		p = new_anchor(oldurl, protocol);

		/* seems not to accomplish anything */
		p = un_proxy( p); /* if its our def server, point at us! */

		/* if forwarding to host, dont handle */
		if( dont_proxy( p)){
			sprintf(newurl,"%s", p);
#ifdef USEGOPHER
		/* we want to use gopher to handle these protocols */
		}else if( !strncasecmp(p, "gopher", 6) ||
		    !strncasecmp(p, "ftp", 3) ||
		    !strncasecmp(p, "file", 4)){
			typech = gopher_type(p);;
			sprintf(newurl,"gopher://%s:%u/%c%s",
			 ourname, ourport, typech, p);
#endif
		/* so rewrite with our address in the URL first */
		}else{
			sprintf(newurl,"http://%s:%u/%s",
			 ourname, ourport,p);
		}
	}

	/* return the new URL into the value field */
	if (quotes) {
		value--;
		*value++ = quotes;
		cpystr(value,newurl,1022);
		p = value + strlen(value);
		*p++ = quotes;
		*p = 0;
	} else 
		cpystr(value,newurl,1024);

	return 0;
}

/* do the plug-gw stuff */

int do_plug(sockfd, buf, rt)
int sockfd;
char *buf;
struct reproxy_rec *rt;
{	int plug_fd, plugdata;
	int port, rem_fd;
	struct sockaddr serv_addr;
	int length;
	int cnt;
	char *p, protocol[16];
	struct timeval *tp = NULL;
	unsigned char haddr[4];
	struct reproxy_rec *t = reproxy_list;

	strcpy(tmp_auth_buf, buf);
	buf = tmp_auth_buf;

	plug_fd = make_conn(0);
	if( plug_fd < 0)
		goto broken;

	if( listen(plug_fd, 2))
		goto broken;

	port = port_num(sockfd, plug_fd, haddr);
	if( port == 0)
		goto broken;

	cpystr(protocol, buf, 15);
	p = index(protocol, ':');
	if( p)
		*p = '\0';
	
	p = index(buf, ':');
	if( p == NULL)
		goto broken;
	p++;
	if( *p == '/')p++;
	if( *p == '/')p++;

	strcpy(errbuf, p);
	p = index(p, '@');
	if( p ){
		p++;
		strcpy(rem_server, p);
		p = index(errbuf,'@');
		*p = '\0';
		p = index(rem_server,'/');
		if( p )
			*p = '\0';
	}else{
		strcpy(rem_server, errbuf);
		p = rem_server;
		p = index(p, '/');
		if( p == NULL)
			goto broken;
		*p++ = '\0';
		if(*p == '8')p++;
		strcpy(errbuf, p);
	}

	while(t ){
		if( !strcasecmp(&protocol[1], t->protocol))
			break;
		t = t->next;
	}
	if( t == NULL)
		goto broken;
	

	if( !strcasecmp(protocol, "ptelnet")){
		sprintf(go_request,"Location: %s://%s@%s:%u/", &protocol[1], errbuf, ourname, port);
	}else{
		sprintf(go_request,"Location: %s://%s:%u/", &protocol[1], ourname, port);
	}

	say(sockfd,"HTTP/1.0 302 Found");
	say(sockfd, go_request);
	say(sockfd, "");

	rem_port = 23;
	rem_port = get_port(rem_server, rem_port);
	
	close(sockfd);
	close(1);
	close(2);
	sockfd = -1;

	timeout.tv_sec = 120;

	(void) signal(SIGALRM, net_timeout);
	(void) alarm(timeout.tv_sec);

	length = sizeof(struct sockaddr );
	plugdata = accept(plug_fd, (struct sockaddr *)&serv_addr, &length);
	if( plugdata < 0){
		goto broken;
	}

	if(peername(plugdata,prladdr,priaddr,sizeof(priaddr))) {
		syslog(LLEV,"cannot get peer name");
		http_exit(1);
	}

	if( strcmp(prladdr, rladdr) || strcmp(priaddr, riaddr)){
		syslog(LLEV,"deny host=%.512s/%.20s should have been %.512s/%.20s",
			prladdr, priaddr, rladdr, riaddr);
		http_exit(1);
	}

	(void) alarm(0);
	(void) signal(SIGALRM, SIG_IGN);


	syslog(LLEV,"start host=%.512s/%.20s dest=%.512s path=%.20s", rladdr, riaddr, rem_server, buf);
	return 0;

broken:
	if( sockfd != -1){
		go_error(sockfd, 404, "Could not open connection for telnet");
	}
	return 0;
}

int forward_gopher(sockfd, rem_path, rem_server)
int sockfd;
char *rem_path, *rem_server;
{
	if( rem_type & TYPE_DIR){
		forward_dir(sockfd, rem_path, rem_server);
	}else{
		forward_file(sockfd, rem_path, rem_server);
	}
	return 0;
}

/* This routine will seek through a string looking for a javascript: 
   substring. It will replace that with filterfwtk: so it becomes 
   non-functional. This is only called when screening for javascript */
void
seek_and_destroy(jScan)
char *jScan;
{
	char	jTest[12];
	char	jChar;
	char	*jEnd;

	jEnd = jScan + strlen(jScan);
	while(jChar = *(jScan++)) {
		if (((jChar == 'j') || (jChar == 'J')) && ((jEnd-jScan)>9)) {				
			cpystr(jTest,jScan-1,11);
			*(jTest+11) = 0;
			if (!strncasecmp(jTest,"javascript:",11)) {
				bcopy("filterfwtk:",jScan-1,11);
				break;
			}
			if (!strncasecmp(jTest,"livescript:",11)) {
				bcopy("filterfwtk:",jScan-1,11);
				break;
			}
		}
	}
}
