/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 * 10/27 pjc modified listen to use SOMAXCONN
 *           added sleep on bind failure.
 */

#include	<sys/signal.h>
#include	<syslog.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#ifdef SYSV
#include	<sys/sockio.h>
#endif
#include	<sys/wait.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<sys/time.h>
#include	<sys/resource.h>
#ifndef AIX
#include	<sys/fcntl.h>
#else
#include	<fcntl.h>
#endif

#include	"firewall.h"

static	char	RcsId[] = "$Header: /home/rmurphy/fwtk/fwtk/lib/RCS/daemon.c,v 1.10 1998/02/06 00:01:31 rmurphy Exp $";

daemonize()
{
	(void)signal(SIGHUP,SIG_IGN);
	(void)signal(SIGALRM,SIG_IGN);
	if(fork())
		exit(0);
#ifdef	HAVE_SETSID
	(void)setsid();
#endif
	syslog(LLEV,"daemon running");
}

/* routines to allow proxies to be run as daemons */


int str_to_port( portstr )
char *portstr;
{	int portid;

	if(isalldigits(portstr))
		portid = atoi(portstr);
	else {
		struct servent	*sp;

		if((sp = getservbyname(portstr,"tcp")) != (struct servent *)0)
			portid = ntohs(sp->s_port);
		else {
			syslog(LLEV,"fwtkcfgerr: cannot decode %.100s as port",portstr);
			exit(1);
		}
	}
	return portid;
}


void waitwaitwait()
{	int cstat;

#ifdef SYSV
	while ( waitpid(-1, &cstat, WNOHANG) > 0)
#else
	while( wait3(&cstat, WNOHANG, (struct rusage *)0) > 0 )
#endif
		;
	signal(SIGCHLD, waitwaitwait);
}

void hup_exit()
{
	syslog(LLEV,"caught signal");
	exit(1);
}


int do_daemon( port)
int port;
{	struct sockaddr_in sa;
	int sock,sockl;
	pid_t pid;
	int boundok = 1;
	int reuse = 1;
	int devnull;

#ifdef	HAVE_SETSID
	(void) setsid();
#endif
	if ((pid = fork()) == -1)
		return (-1);
	if (pid)
		exit(0);	/* parent exits */
	devnull = open("/dev/null", O_RDWR, 0);
	if (devnull != -1) {
		(void) dup2(devnull, 0);
		(void) dup2(devnull, 1);
		(void) dup2(devnull, 2);
		if (devnull > 2)
			(void) close(devnull);
	}
	sa.sin_family = AF_INET;
	bzero( (char *)&sa.sin_addr, sizeof(sa.sin_addr));
	sa.sin_port = htons(port);
	sock = socket(AF_INET, SOCK_STREAM, 0);
	if( sock < 0){
		syslog(LLEV,"Failed to create socket, %m");
		exit(1);
	}
	setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&reuse, sizeof(reuse));
	while( bind(sock, (struct sockaddr *)&sa, sizeof(sa))){
		syslog(LLEV,"Failed to bind port %d, %m", port);
		syslog(LLEV,"Sleeping for 2 minutes");
		sleep(120);
		boundok=0;
	}
#ifndef SOMAXCONN
#define SOMAXCONN 4
#endif
	if( listen(sock, SOMAXCONN) < 0){
		syslog(LLEV,"Failed to listen, %m");
		exit(1);
	}

	if( boundok == 0){
		syslog(LLEV,"Now ready on port %d", port);
	}
	signal(SIGCHLD,waitwaitwait);
	signal(SIGHUP, hup_exit);
	signal(SIGINT, hup_exit);
	signal(SIGTERM,hup_exit);

	while(1){
		int cstat;

		sockl = accept(sock, (struct sockaddr *)0, (int *)0);
		if( sockl < 0){
			if( errno == EINTR)
				continue;
			syslog(LLEV,"Accept failed, %m");
			continue;
		}
		pid = fork();
		if( pid < 0){
			syslog(LLEV,"Fork failed, %m");
/* 9/8/95 pjc. Make fork failure non-fatal, just throw connection for now */
			close(sockl);
			continue;
		}
		if( pid == 0)
			break;	/* We are the child */
		close(sockl);
	}
#ifdef	HAVE_SETSID
	(void)setsid();
#endif
	close(0);
	close(1);
	close(2);
	dup(sockl);
	dup(sockl);
	dup(sockl);
	close(sockl);
	close(sock);
}


