/*-
 * Copyright (c) 1995, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Rick Murphy, Trusted Information Systems, Inc.
 */
static  char    RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/lib/RCS/getp.c,v 1.3 1997/01/08 16:22:00 rick Exp $";

#include <unistd.h>
#include <stdio.h>
#include <termios.h>
#include <fcntl.h>
#ifndef sun
#include <sys/ioctl.h>
#endif

#if defined (SCO5)
/* This is a kludge; SCO's ifdefs exclude these */
#define	TCGETS	(TIOC|13)
#define	TCSETS	(TIOC|14)
#define	TCSETSW	(TIOC|15)
#define	TCSETSF	(TIOC|16)
#endif

#define TTY "/dev/tty"

/* Issue prompt and read reply with echo turned off */
char *getpassword(prompt)
char *prompt;
{
    struct termios ttyb, ttysav;
    char *cp;
    int c;
    FILE *tty;
    static char pbuf[128];

/*
 * Following doesn't work with login-sh
 * so assume stdin
 * 
 *   if ((tty = fdopen(open(TTY,O_RDWR),"r")) == NULL)
 *	tty = stdin;
 *   else
 *	setbuf(tty, (char *) NULL);
 */
    tty = stdin;
    tcgetattr(fileno(tty), &ttyb);
    tcgetattr(fileno(tty), &ttysav);

    ttyb.c_lflag &= ~(ECHO|ISIG);
    tcsetattr(fileno(tty), TCSADRAIN, &ttyb);

    fflush(stdout);
    fprintf(stderr, "%s", prompt);
    fflush(stderr);

    cp = pbuf;
    for (;;) {
	c = getc(tty);
	if(c == '\r' || c == '\n' || c == EOF)
	    break;
	if(cp < &pbuf[127])
	    *cp++ = c;
    }
    *cp = '\0';
    fprintf(stderr,"\r\n");
    fflush(stderr);

    tcsetattr(fileno(tty), TCSADRAIN, &ttysav);
    if (tty != stdin)
	fclose(tty);

    return(pbuf);
}

