/*-
 * Copyright (c) 1993, 1996, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 *	Added "?" wildcard matching from William Gianopoulos, gianowa@eo.ray.com
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/lib/RCS/nama.c,v 1.11 1997/04/02 16:09:46 rick Exp $";

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<syslog.h>
#include	<ctype.h>

extern	char	*inet_ntoa();
extern	long	inet_addr();


#include	"firewall.h"

extern char *strchr();

/* pjc - allow matching of character sets [a-z] etc */
char *
set_match(pat, ch, both)
char *pat;
int ch, both;
{	int notflag = 0;
	static char	bits[32];
	int i, first, last, n;
	char *savedpat = pat;

	for(i=0; i < 32; i++)
		bits[i] = 0;

	if( *pat == '^'){
		notflag = 1;
		pat++;
	}

	if( *pat == ']'){
		pat++;
		n = (']'>> 3)&0x1f;
		bits[n] |= (1 << (']' & 7));
	}

	while(*pat && *pat != ']'){
		first = *pat++ & 0xff;
		if( *pat == '-'){
			pat++;
			last = *pat & 0xff;
			if(last && last != ']' && first <= last ){
				pat++;
				do {
					n = (first >> 3)&0x1f;
					bits[n] |= (1 << (first & 7));
					if( both){
						int saved = first;

						if( first >= 'A' && first <= 'Z')
							first += 0x20;
						else if( first >= 'a' && first <= 'z')
							first -= 0x20;
						n = (first >> 3)&0x1f;
						bits[n] |= (1 << (first & 7));
						first = saved;
					}
					first = 0xff & (first +1);
				}while(first != last);
			}else {
				break;
			}
		}else{
			n = (first >> 3)&0x1f;
			bits[n] |= (1 << (first & 7));
			
			if( both){
				if( first >= 'A' && first <= 'Z')
					first += 0x20;
				else if( first >= 'a' && first <= 'z')
					first -= 0x20;
				n = (first >> 3)&0x1f;
				bits[n] |= (1 << (first & 7));
			}
		}
	}

	if( *pat == ']'){
		if( notflag){
			for(i=0; i < 32; i++){
				bits[i] = bits[i] ^ 0xff;
			}
		}
		if( ((1<< (ch &7))& bits[(ch >> 3)&0x1f]) )
			return pat;	/* ok */
		return (char *)0;	/* failed */
	}
syslog(LLEV,"bad pattern [%.100s", savedpat);
	return savedpat;
}


		
		

/* ripped bloody and kicking from some code by Guido Van Rossum */
int
namatch(pattern,string)
char	*pattern;
char	*string;
{
	register char c;
	while(1)
		switch(c = *pattern++) {
		case '\0':
			return(*string == '\0');
		case '*':
			c = *pattern;
			while(c == '*')
				c = *++pattern;
			if(c == '\0')
				return(1);
			/* general case, use recursion */
			while(*string != '\0') {
				if(namatch(pattern,string))
					return(1);
				++string;
			}
			return(0);
		case '?':
			if(*string++ == '\0')
				return(0);
			break;
		default:
			if(c != *string++)
				return(0);
			break;
		}
}

/* case insensitive version */
int
nacasematch(pattern,string)
char	*pattern;
char	*string;
{	char	ch;
	register char c;

	while( (c = *pattern++) )
		switch(c ) {
		case '*':
			c = *pattern;
			while(c == '*')
				c = *++pattern;
			if(c == '\0')
				return(1);
			/* general case, use recursion */
			while(*string != '\0') {
				if(nacasematch(pattern,string))
					return(1);
				++string;
			}
			goto no_match;

		case '[':
			if( (pattern = set_match(pattern, *string++, 1)) == (char *) 0)
				goto no_match;
			pattern++;
			break;

		default:
			ch = *string++;
			if( ch >= 'A' && ch <= 'Z')
				ch += 0x20;
			if( c >= 'A' && c <= 'Z')
				c += 0x20;
			if(c != ch)
				goto no_match;
			break;
		}

	return(*string == '\0');
no_match:
	return 0;
}





/*
all singing and dancing host name match code. this is more complex
than I'd like it to be but it's somewhat unavoidable. the model is
that we're given a pattern and either and address or a host name
to match it against. we need to look at the type of the pattern,
and depending on the pattern, we convert what we're given, then
match on that. generally, IP addresses are better to use, and
generally should be matched with addresses.
*/


/* pjc 3/15/95
 * given two numeric forms, where pat may have optional
 * :mask compare them.
 *
 * if pat has a * then use namatch.
 */

int maskmatch(pat, num)
char *pat, *num;
{	char mask[4], pataddr[4], *p, *p1;
	int i;

	p = strchr(pat, '*');
	if( p != NULL)
		return namatch(pat, num);

	mask[0] = 0;
	mask[1] = 0;
	mask[2] = 0;
	mask[3] = 0;

	pataddr[0] = 0;
	pataddr[1] = 0;
	pataddr[2] = 0;
	pataddr[3] = 0;

	p = pat;
	i = 0;
	while(*p && *p != ':' && i < 4){
		p1 = p;
		while(*p != '\0' && *p != '.' && *p != ':')p++;
		if( *p != '\0'){
			char saved= *p;
			*p = '\0';
			pataddr[i] = atoi(p1);
			*p = saved;
			if( saved == '.')
				p++;
		}else{
			pataddr[i] = atoi(p1);
		}
		mask[i] = 0xff;
		i++;
	}
	if( *p == ':'){	/* get mask */
		p++;
		i = 0;
		while(*p  && i < 4){
			p1 = p;
			while(*p != '\0' && *p != '.')p++;
			if( *p == '.'){
				*p = '\0';
				mask[i] = atoi(p1);
				*p++ = '.';
			}else{
				mask[i] = atoi(p1);
			}
			i++;
		}
		
	}
/* sanity check */
	for(i=0; i < 4; i++){
		if( (mask[i] & pataddr[i]&0xff) != (0xff & pataddr[i])){
			syslog(LLEV,"fwtkcfgerr: pat:mask can never match anything, %.100s", pat);
			return 0;
		}
	}

	i = 0;
	p = num;
	while(*p  && i < 4){
		p1 = p;
		while(*p != '\0' && *p != '.')p++;
		if( *p == '.'){
			*p = '\0';
			if( (mask[i] & atoi(p1) & 0xff) != (pataddr[i] & 0xff) )
				goto nomatch;
			*p++ = '.';
		}else{
			if( (mask[i] & atoi(p1) & 0xff) != (pataddr[i] & 0xff) )
				goto nomatch;
		}
		i++;
	}
	return 1;

nomatch:
	return 0;
}


hostmatch(pattern,name)
char	*pattern;
char	*name;
{
	struct	hostent		*hp;
	struct	sockaddr_in	sin;
	char			pat[512];
	char			nam[512];
	char			*p;
	int			x;
	int			y;
	struct in_addr		*hp_addr;
	int			eq;

	/* copy into private area because we lowercase names */
	if((x = strlen(pattern)) >= sizeof(pat)) {
		syslog(LLEV,"fwtkcfgerr: pattern %.100s too long!",pattern);
		return(0);
	}
	strcpy(pat,pattern);
	for(y = 0; y < x; y++)
		pat[y] = tolower(pat[y]);


	if((x = strlen(name)) >= sizeof(nam)) {
		syslog(LLEV,"fwtkcfgerr: name %.100s too long!",name);
		return(0);
	}
	strcpy(nam,name);
	for(y = 0; y < x; y++)
		if(isupper(nam[y]))
			nam[y] = tolower(nam[y]);


	/* is the pattern numeric ? ,pjc: num:mask? */
	p = pat;
	while(*p != '\0' &&
	    (*p == '.' || *p == '*' || *p == '?' || isdigit(*p) || *p == ':'))
		p++;


	/* match against a text name */
	if(*p != '\0') {
		long		f;
		char		*p = nam;
		char		*rev;

		eq = 0;
		while(*p != '\0' && (*p == '.' || isdigit(*p)))
			p++;

		/* if the name is also a text name, just match */
		if(*p != 0)
			return(namatch(pat,nam));

		/* fooey, it's not, we need to reverse lookup */
		if((f = inet_addr(nam)) == (long) -1) {
			syslog(LLEV,"fwtkcfgerr: inet_addr, malformed address: %.100s",nam);
			return(0);
		}

		hp = gethostbyaddr((char *)&f,sizeof(f),AF_INET);
		if(hp == (struct hostent *)0)
			return(namatch(pat,"unknown"));

		/* rewrite name */
		if((x = strlen(hp->h_name)) >= sizeof(nam)) {
			syslog(LLEV,"fwtksyserr: name %.512s too long!",hp->h_name);
			return(0);
		}
		strcpy(nam,hp->h_name);
		for(y = 0; y < x; y++)
			if(isupper(nam[y]))
				nam[y] = tolower(nam[y]);

		/* cross-check reverse lookup to try to detect DNS spoofs */
		hp = gethostbyname(nam);
		if(hp == (struct hostent *)0)
			return(namatch(pat,"unknown"));

		if(hp->h_length > sizeof(f)) {
			syslog(LLEV,"securityalert: invalid host address length (%d) hostname %.512s", hp->h_length, nam);
			return(0);
		}
		while((hp_addr = (struct in_addr *)*hp->h_addr_list++) != (struct in_addr *)0) {

			if (hp_addr && !rev)
				rev = inet_ntoa(*hp_addr);
			if(bcmp(hp_addr,&f,hp->h_length) == 0) {
				eq = 1;
				break;
			}
		}

		if(!eq) {
			syslog(LLEV,"securityalert: possible spoof - DNS lookup for address %.20s gives name %.512s but the reverse lookup is %.20s",
				name,nam,rev);
			return(namatch(pat,"unknown"));
		}

		/* name valid: match */
		return(namatch(pat,nam));
	}



	/* match against a numeric pattern */
	/* pjc: or num:mask */

	p = nam;
	while(*p != '\0' && (*p == '.' || isdigit(*p)))
		p++;

	/* all numeric match is easy ! */
	if(*p == '\0')
		return(maskmatch(pat,nam));

	/* get address and covert to numbers to match on */
	hp = gethostbyname(nam);

	/* unknown host can never match numeric spec */
	if(hp == (struct hostent *)0)
		return(0);

	/* match names */
	eq = 0;
	while((hp_addr = (struct in_addr *)*hp->h_addr_list++) != (struct in_addr *)0) {
		if (hp->h_length > sizeof(sin.sin_addr.s_addr)) {
			syslog(LLEV,"securityalert: invalid host address length (%d) hostname %.512s", hp->h_length, nam);
			return(0);
		}
		bcopy(hp_addr,&sin.sin_addr,hp->h_length);
		eq = maskmatch(pat, inet_ntoa(sin.sin_addr));
		if (eq)
			return eq;
	}
	return 0;
}





#ifdef	TESTNAMATCH
#include <stdio.h>

main()
{
	char	buf1[1024];
	char	buf2[1024];

	while(1) {
		fprintf(stderr,"pattern: ");
		if(gets(buf1) == (char *)0)
			exit(0);
		fprintf(stderr,"name: ");
		if(gets(buf2) == (char *)0)
			exit(0);
		if(hostmatch(buf1,buf2))
			printf("matches\n");
		else
			printf("no match\n");
	}
}
#endif
