/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/netacl/RCS/netacl.c,v 1.6 1997/01/18 19:41:59 rick Exp $";


#include	<syslog.h>
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<pwd.h>
#include	<time.h>

#include	"firewall.h"

static	int	acceptrule();

static	char	rhost[512];
static	char	raddr[512];
static	char	*service;

static	char	dhost[512];
static	int	dport;
static	char	dportbuf[10];

main(ac,av)
int	ac;
char	*av[];
{
	Cfg	*cfp;
	Cfg	*cf;
	char	nbuf[512];
	char	**xav = av;

#ifndef	LOG_DAEMON
	openlog("netacl",LOG_PID);
#else
	openlog("netacl",LOG_PID|LOG_NDELAY,LFAC);
#endif

	if (ac > 2 && !strcmp(av[1],"-daemon")) {
		int port = str_to_port(av[2]);

		ac -= 2;
		av += 2;
		syslog(LLEV,"Starting daemon mode on port %d",port);
		do_daemon(port);
	}

	if(ac == 1) {
		char * p;

		service = xav[0];
		if ((p = (char *)strrchr(service,'/')))
			service = &p[1];
	} else
		service = av[1];

	if(strlen(service) + 9 > sizeof(nbuf)) {
		syslog(LLEV,"fwtkcfgerr: name of av[](%.100s) too long",service);
		exit(1);
	}

	strcpy(nbuf,"netacl-");
	strcat(nbuf,service);

	if((cfp = cfg_read(nbuf)) == (Cfg *)-1) {
		syslog(LLEV,"fwtkcfgerr: %.512s exiting - cannot read configuration",service);
		exit(1);
	}

	if(peername(0,rhost,raddr,sizeof(rhost))) {
		syslog(LLEV,"fwtksyserr: %.512s exiting - cannot get peername",service);
		exit(1);
	}


	/* get list of permitted/denied hosts */
	for(cf = cfg_get("hosts",cfp); cf != (Cfg *)0; cf = cfg_get("hosts",(Cfg *)0)) {
		int	x;

		for(x = 0; x < cf->argc; x++) {

			/*
			if we hit a value with a leading '-' we are
			past processing the host names
			*/
			if(!strcmp(cf->argv[x],"-exec"))
				break;
			if(!strcmp(cf->argv[x],"-user"))
				break;
			if(!strcmp(cf->argv[x],"-group"))
				break;
			if(!strcmp(cf->argv[x],"-chroot"))
				break;
			if(!strcmp(cf->argv[x],"-dest"))
				break;
			if(!strcmp(cf->argv[x],"-port"))
				break;

			if(hostmatch(cf->argv[x],raddr)) {
				acceptrule(service,cf,cf->argc,cf->argv);
				break;
			}
		}
	}

	exit_deny();
	exit(1); /* not reached */
}

int
exit_deny()
{
	if (dhost[0] != '\0') {
		syslog(LLEV,"deny host=%.512s/%.20s service=%.100s dest=%.512s port=%d",
			rhost,raddr,service,dhost,dport);
	} else {
		syslog(LLEV,"deny host=%.512s/%.20ss service=%.100s",rhost,raddr,service);
	}
	exit(1);
}

static	int
acceptrule(srv,c,ac,av)
char	*srv;
Cfg	*c;
int	ac;
char	**av;
{
	int	avbase = 0;
	char	*chrdir = (char *)0;
	int	runuid = -1;
	int	rungid = -1;
	int	xecind = -1;
	int	x;
	int	found;

	for(x = 0; x < ac; x++)
		if (!strcmp(av[x],"-exec")) {
			xecind = x;
			break;
		}

	if (xecind < 0) {
		syslog(LLEV,"fwtkcfgerr: no exec clause in rule line %d",c->ln);
		exit(1);
	}

	found = 1;
	for (x = 0; x < ac; x++) {
		if (!strcmp(av[x],"-dest")) {
			if (dhost[0] == '\0')
				return 0;	/* can not apply */
			found = found & 2;	/* just keep bit 1 */
			for(x++; x < ac; x++) {
				if (!strcmp(av[x],"{"))
					continue;
				if (!strcmp(av[x],"}"))
					break;
				if(av[x][0] == '-') {
					x--;
					break;
				}
				if ((found & 2) == 0) {
					if (av[x][0] == '!') {
						if (!hostmatch(&av[x][1],dhost))
							found |= 2;
					} else if(hostmatch(av[x], dhost))
						found |= 2;
				}
			}
		} else if (!strcmp(av[x], "-port")) {
			x++;
			if (x >= ac) {
				syslog(LLEV,"fwtkcfgerr: -port takes an argument, %d",c->ln);
				exit(1);
			}
			if (dhost[0] == '\0')
				return 0;	/* cannot match */
			if (!namatch(av[x], dportbuf))
				return 0;
		}
	}
	if (!found)
		return 0;

	/* src and dst match so now apply this rule */
	if(c->flags & PERM_DENY) {
		exit_deny();
		exit(1);
	}

	for(x = 0; x < xecind; x++)
		if(!strcmp(av[x],"-user")) {
			if((runuid  = mapuid(av[x+1])) == -1) {
				syslog(LLEV,"fwtkcfgerr: cannot map uid %.100s",av[x+1]);
				exit(1);
			}
			break;
		}

	for(x = 0; x < xecind; x++)
		if(!strcmp(av[x],"-group")) {
			if((rungid  = mapgid(av[x+1])) == -1) {
				syslog(LLEV,"fwtkcfgerr: cannot map gid %.100s",av[x+1]);
				exit(1);
			}
			break;
		}

	for(x = 0; x < xecind; x++)
		if(!strcmp(av[x],"-chroot")) {
			chrdir = av[x+1];
			break;
		}


	if(chrdir != (char *)0) {
		chdir("/");
		if((chdir(chrdir) != 0 || chroot(chrdir) != 0)) {
			syslog(LLEV,"fwtksyserr: cannot chroot %.512s: %m",chrdir);
			exit(1);
		}
		chdir("/");
	}

	if(rungid != -1 && setgid(rungid)) {
		syslog(LLEV,"fwtksyserr: cannot setgid %d: %m",rungid);
		exit(1);
	}

	if(runuid != -1 && setuid(runuid)) {
		syslog(LLEV,"fwtksyserr: cannot setuid %d: %m",runuid);
		exit(1);
	}

	syslog(LLEV,"permit host=%.512s/%.20s service=%.100s execute=%.512s",rhost,raddr,service,av[xecind + 1]);
	execv(av[xecind + 1],&av[xecind + 1]);
	syslog(LLEV,"fwtksyserr: exec: %.512s : %m",av[xecind + 1]);
	exit(1);
}
