/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Wei Xu, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/home/rick/fwtk2.0/fwtk/x-gw/RCS/pmsg.c,v 1.4 1997/07/22 14:04:27 rick Exp $";


#include        "ulib.h"
#include        <syslog.h>

int uselog=0;



/*******************************************************
 *  perrno: use strerror()
 *  uselog must be set before puting msg to the log 
 *         file which can also be used as debeg ouputs.
 *******************************************************/
void pmsg( msg, perrno )
char *msg;
int   perrno;
{
   char    buf[8192];

   if( perrno ) {
       sprintf( buf, "%.7500s: %.500s\n", msg, strerror(errno) );
   } else {
	strncpy(buf, msg, sizeof(buf));
	buf[sizeof(buf)-1] = '\0';
   }

   if( uselog ) syslog( LLEV, buf );
   else {
       fprintf( stderr, buf );
       fflush(stderr);
   }
}

void exitmsg( start_time, msg )
time_t	start_time;
char	*msg;	/* additional msgs */
{
	char    buf[256];
	time_t  end_time;

	time(&end_time);
	if(!msg) sprintf( buf,"exit duration=%d seconds\n",end_time-start_time );
	else  sprintf( buf,"%s exit duration=%d seconds\n",msg,end_time-start_time );
	pmsg(buf,0);

	if(uselog) closelog();
}   

dump_struct(pmsg,data,sz)
	char    *pmsg;
        caddr_t data;
	int     sz;
{
	int     i,cnt=0,chex=0;
	u_char *p=(u_char *)data;

	printf("%s(%d bytes):",pmsg,sz);
	for(i=0;i<sz;i++) {
		printf("%02x ",*p++);
		cnt++; chex++;
		if(cnt==8) {
			printf("\n");
			cnt=0;
		}
	}
	if(cnt) printf("\n");
}

