/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

 /*
  *      Author: Wei Xu, Trusted Information Systems, Inc.
*/
static  char    RcsId[] = "$Header: /home/rmurphy/fwtk/fwtk/x-gw/RCS/sig.c,v 1.7 1998/02/06 00:10:53 rmurphy Exp $";

#include "ulib.h"
#include "list.h"
#include <sys/wait.h>
#include <signal.h>


  /****************************************
   * return value == -3 the pid alive 
   *        otherwise it died.
   * return: -1: WIFSIGNALED
   *         -2: no status
   *         -3: alive
   *         >=0: WEXITSTATUS
   * when >= -1 the child died
   ****************************************/
int handle_sigpid( sigpid )
pid_t sigpid;
{
        pid_t              temppid;
#if !defined(SYSV) && !defined(HPUX) && !defined(SCO5) && !defined(OSF1) && !defined(AIX)
#ifdef __386BSD__   
	int                wstatus;
#else
	union  wait        wstatus; 
#endif
#else
	int		   wstatus;
#endif
	int                exitstat, wopts=WNOHANG;

	temppid = waitpid(sigpid,(int *)&wstatus,wopts);

	if ( !temppid ) { /* there's no status */
		exitstat= -2;
		goto out;
	}

        if (WIFSIGNALED(wstatus) || WIFSTOPPED(wstatus) ) {
		pmsg("child died abnormally or stopped\n",0);
		exitstat= -1;
		goto out;
	 }

         if( !WIFEXITED(wstatus) ) {
		exitstat== -3;
		goto out;
	}

	 exitstat = WEXITSTATUS(wstatus);
out:
#ifdef WEI_DBG
fprintf(stderr,"handle_sigpid pid=%d: exit_status= %d\n",
                sigpid, exitstat );
#endif  
	 return exitstat; /* must >= 0 */
}

/* ******* chldsigs ***********************************************
 * list_t *pidlist must store the id as the child pid previously.
 * Check (wait) through the list of the pidlist of children. 
 * Callback when the child is exit or signaled.
 * Delete the pid on the list if the child is exited.
 ****************************************************************/
list_t	*chldsigs(pidlist,cb,data)
list_t	*pidlist;
int	(*cb)();	/* return < -1 in order not to delete 
			 * the pid on the list.
			 */
void	*data;
{
	int	ret;
	list_t	*p=pidlist;

	while(p) { 
		if( (ret=handle_sigpid(p->id))>= -1 && cb) 
			ret=cb(p->id,data,ret);
		if( ret>= -1) 
			pidlist=(list_t*)deleteListItem(pidlist,p->id);
	p=p->next;
	} 
	return pidlist;
}

void	sigexit(funct)
void	(*funct)();
{
	signal(SIGINT, funct); 	/* control c	*/
	signal(SIGQUIT,funct);	/* control /	*/
	signal(SIGTERM,funct);	/* kill(1)	*/
#ifdef SIGXCPU
	signal(SIGXCPU,funct);	/* exceeds upu 	*/
#endif
}

