/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *	Author: Wei Xu, Trusted Information Systems, Inc.
 */
static	char	RcsId[] = "$Header: /usr/users/rick/fwtk/fwtk/x-gw/RCS/string.c,v 1.3 1996/03/27 04:47:27 rick Exp $";

#include        "ulib.h"


/*******bncat**********************************************************
 # like strncat this routine handle binary cat
 * return a new buf size.
 **********************************************************************/
char *bncat( s, sbytes, add, addbytes )
char	*s;
int      sbytes;
char	*add;
int 	 addbytes;
{
	int	n=sbytes+addbytes;

	if( !add || addbytes<=0 ) return s;

	if(!sbytes) s=(char*)malloc(n+1);
	else        s=(char*)realloc(s,n+1);
        bcopy((void*)add,(void*)&s[sbytes],(size_t)addbytes);

	return s;
}

/*******strsave********************************************************
 * allocate the memory for the string and return the addr
 **********************************************************************/
 char * strsave( s, len )
 char * s;
 int    len;
 {
     char  *rs;

     if( len<0 || !s || !*s) len=0;

     rs = (char*)malloc( len+1 );
     bzero( rs, len+1 );
     if(len) strncpy( rs,s,len );

     return rs;
 }

/*******stradd********************************************************
 * allocate memory and add addbuf to the string s. return string size.
 *********************************************************************/
char	*stradd(s,addbuf,len)
char	*s, *addbuf;
int	len;
{
	int	n;

	if(len<=0) return s;

	s=(char*)realloc(s,(s)?(n=strlen(s)+len+1):(n=len+1));
        strncat(s,addbuf,len);
	s[n-1]='\0';

	return s;
}

/******* repstr *******************************************************
 * repalce the dlen number of s by insert string with ilen # 
 * starting at s[0]. Be sure s has enough space !
 * return the point after the inserted string, 
 *********************************************************************/
char	*repstr(s,dlen,insert,ilen)
char	*s,*insert;
int	 dlen,ilen;
{
	int 	n,l=ilen-dlen, len=strlen(s);

	if(l>0) {
		/* insert string length is larger than deleted string length */
		len -=dlen;
		while(len--) s[len+ilen]=s[len+dlen];
	}
	strncpy(s,insert,ilen);

	if(l<0) {
		/* insert string length is less than deleted string length */
		sprintf(&s[ilen],"%s",&s[dlen]);
	}
	return &s[ilen];
}

/***************addlist*********************************************/
void **addptrlist( list, item, n )
void ** list;
void  * item;
int   * n;
{
    int	   i,m=0;
    void **olist=list;

    if( list ) while( list[++m] );

    list = (void **)calloc( m+2, sizeof(void*) );
    for( i=0; i<m; i++ ) list[i]=olist[i];
    free( olist );

    list[m++]=item;
    list[m]=NULL;

    if( n ) *n=m;
    return list;
}
 
/***************addstrlist*********************************************
 * add to the string arry of the list.
 * return: a) function return the list array point.
 * if len is not null, return the element # of the list.
 **********************************************************************/
char ** addstrlist( list, s, len )
char  ** list;
char   * s;
int    * len;
 {
     int    n;
     char  *p;

     p = (char*)strsave( s, (len && *len>0)? *len: 0 );
     return (char**)addptrlist((char**)list,(char*)p,len );
}

/***************freestrlist*********************************************/
void freestrlist( list,free_struct )
char	** list;
void	(*free_struct)();
{
   int  n=0;

   if(list) {
   	while( list[n] )  {
		if(free_struct)
			free_struct(list[n++]);
		else
			free( (char*)list[n++] );
	}
   	free( (char**)list );
   }
}
#define freelist(a,b)	freestrlist((char**)(a),(b))


/***************wmatch*********************************************
 * to match the string 'string' to the wildcard pattern 'pattern'.
 * return 0 no match, otherwise 1.
 ******************************************************************/
int wmatch(pattern,string)
char    *pattern;
char    *string;
{
	register char c;
	while(1) {
		switch(c = *pattern++) {
			case '\0': return(*string == '\0');
			case '*' : c = *pattern;
				while(c == '*') c = *++pattern;
                                if(c == '\0') return(1);

                             /* general case, use recursion */
                                while(*string != '\0') {
                                       if(wmatch(pattern,string)) return(1);
                                       ++string;
                                }
                                return(0);

                        default: if(c != *string++) return(0);
                                break;
                    }
	}
}

/*************** wtmatch ***************************************************
 * To match the 'string' to the the wildcard 'pattern' table.
 * return n: the matched number of the pattern on the 'pattern' table list.
 ***************************************************************************/
int wtmatch( pattern, string )
char *pattern;
char *string;
{
   int    n=0, cnt;
   char **list;

   list=tokens( pattern," ",&cnt );
   if( !list ) return 0;

   while(cnt-- >0) {
	if((wmatch(list[cnt],string))) {
	    n=cnt+1;
	    break;
	 }
   }
   freestrlist(list,NULL);
   return(n);
}

/*************** getsep ***************************************************
 * get addr and mask strings from string="addr:mask" with seperate 'sep'  *
 * return -1, error, otherwise 0.					  *
 **************************************************************************/
int getsep(string,sep,add,mask)
        char    *string;
	char	*sep;
	char    **add;
	char    **mask;
{
	static  char    m[BUFSIZE], a[BUFSIZE];
	char	*p;

	if(!string || !*string || !add || !mask) {
		m[0]=a[0]='\0';
		*add=a; *mask=m;
		return -1;
	}

	if((p=strstr(string,sep))) {
		strncpy(a,string,(p-string));
		a[p-string]='\0';
		sprintf(m,"%s",&p[1]);
	} else {
		sprintf(a,"%s",string);
		m[0]='\0';
	}
	*add=a;
	*mask=m;

	return 0;
}
