/* 
 * Copyright (c) 1994, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 *
 *      Author: Wei Xu, Trusted Information Systems, Inc.
#define WEI_DBG
 */

static  char    RcsId[] = "$Header: /home/rmurphy/fwtk/fwtk/x-gw/RCS/x-gw.c,v 1.9 1998/02/06 00:12:45 rmurphy Exp $";

/*************
 * INCLUDES  *
 *************/
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#ifdef AIX
#include <sys/select.h>
#endif
#include <sys/time.h>
#include <netdb.h>
#include <signal.h>
#include <syslog.h>

#include "ulib.h"
#include "list.h"
#include "../firewall.h"





/****************
 * PRIVATE DATA *
 ****************/

#define BASE_PORT	6000
#define TIME_GRAIN	5
static	time_t   start_time;
static	int      permitcnt=0;
static	char     **permitav;


/****************
 * PUBLIC DATA *
 ****************/



/****************
 * Functions   *
 ****************/

void usage()
{
    fprintf(stderr,"usage: x-gw [-options] ...\r\noptions:\r\n");
    fprintf(stderr,"disp display/hostname	where to display the X window\r\n");
    fprintf(stderr,"idle seconds		window idle time\r\n");
    fprintf(stderr,"timeout seconds		window timeout\r\n");
    fprintf(stderr,"from hostname		for proxy log message\r\n");
    fprintf(stderr,"user username		for proxy log message\r\n");
    fprintf(stderr,"prompt string		define prompt\r\n");
    fprintf(stderr,"ver			display x-gw version\r\n");

    exit(1);
}

void	control_exit()
{
	exitmsg( start_time, "control process killed." );
	exit(2);
}

int exit_xfwd_cb(lsd,fadd,pids,fdset,user_data)
int	lsd;
struct  sockaddr_in fadd;
list_t  *pids;
fd_set	fdset;
void   *user_data;
{ 
	if(handle_sigpid((pid_t)user_data)<0) return 0;

	clearList(pids,kill,SIGKILL);
	exitmsg(start_time,"control");
	exit(3);
}

/* ************ query_connect *******************************************
 * return 0 if the connection request is permited.
 * return -1 if error.
 ************************************************************************/
int  query_connect( querysock,saddr,userdata )
int                querysock;
struct sockaddr_in saddr;
void              *userdata;
{
	Widget   dialog;
	char     rladdr[128], riaddr[128], buf[256];
	int      ret= -1, x;

	/* get host name and addr from rladdr */
	sprintf(rladdr,"%s",(char*)&saddr.sin_addr);
	if( peername(querysock,rladdr,riaddr,sizeof(riaddr)) ) {
		pmsg("fwtksyserr: cannot get peer name\n",0);
		return -1;
	}
	if(permitcnt) {
		for(x=0;x<permitcnt;x++) {
			char *hptr = permitav[x];
			if(*hptr == '!') hptr++;
			if(hostmatch(hptr,riaddr)) {
				if(permitav[x][0]!='!') ret=0;
				break;
			}
		}
	} else {
		/* init x create popup on destination: (char*)userdata */
		static   char *argv[]={ "x-gw","-display",NULL,NULL};

        	argv[2]=(char*)userdata;
		xInit( argv[0],(char*)userdata,3,argv );
		sprintf(buf,"Allow X connection from %s?\0",rladdr);
		if(loopDialog(NULL,buf,"OK",OK,"CANCEL",CANCEL,0)==OK) ret=0;
	}

	sprintf(buf,"%s host=%s/%s x-connection\n",
		!ret?"permit":"deny",rladdr,riaddr);
	pmsg(buf,0);

	return ret;
}

cfg_error(where,line)
	char	*where;
	int	line;
{
	char    buf[125];
	sprintf(buf,"%s takes at least one argument, line %d",where,line);
	pmsg(buf,0);
}

/*
 * Look for per user configuration options 
 *
 * return 0 ok, -1 error, >0 specified port number. 
 */

int read_cfg(user, confp)
	char	*user;
	Cfg	*confp;
{
	Cfg	*cfp,*cf;
	int	 port=0, x, y;

	if( confp != (Cfg *)-1) 
	   for(cfp=confp;cfp!= (Cfg *)0;cfp=cfp->next) {
		if(cf=cfg_get("user",cfp)) {
			if(cf->argc<1) {
				cfg_error("user",cf->ln);
				return -1;
			}
		} else continue; 

		if(wmatch(cf->argv[0],user)) {
			for(x=1;x<cf->argc;x++) {
				if(!strcmp("-display",cf->argv[x])){
					if(x++ ==cf->argc) {
						cfg_error("display",cf->ln);
						return -1;
					}
					port=atoi(cf->argv[x]);
				}
				else if(!strcmp("-permit",cf->argv[x])){
					if(x++ ==cf->argc) {
						cfg_error("permit", cf->ln);
						return -1;
					}
					while(x<cf->argc && 
					      cf->argv[x][0] != '-') {
					   y=strlen(cf->argv[x]);
					   permitav=addstrlist(permitav,
							       cf->argv[x++],
							       &y);
					   permitcnt++;
					}
				} else {
					char    buf[125];
					sprintf(buf,"bad argument (%s), line %d"
						   ,cf->argv[x], cf->ln);
					pmsg(buf,0);
					return -1;
				}
			} /* for */
			break;
		} /* if */
	   } /* for */
	return port;
}

int main(argc, argv)
int	argc;
char	*argv[];
{
	struct   sockaddr_in	fwd;
	char		host[MAXHOSTNAMELEN], buf[256], *dpy, *who, *p;
	static char	*cmdargs ="prompt:from:user:disp:idle:timeout:ver";
	int      	port=BASE_PORT+10; /* x port starts from 6010 */
	int      	toport=100+BASE_PORT, newport, len;
	int		lsd,idlemax,timeout;
	pid_t    	pid;
	sws_l		*switches=NULL;
	Cfg		*confp;

	/* syslog */
#ifdef WEI_DBG
	uselog=0;
#else
	uselog=1;
#endif
        if( uselog ) {
#ifndef LOG_DAEMON
        	openlog("x-gw",LOG_PID);
#else
        	openlog("x-gw",LOG_PID|LOG_NDELAY,LFAC);
#endif
        }
	uselog = 0; /** errors go to stderr at setup **/

#ifdef  BINDDEBUG
        debugbind();
#endif
#ifdef FORK
	become_child();
#endif
	time(&start_time);

	if(!(switches=(sws_l*)rd_sws(argc,argv,cmdargs)) && argc>1) usage(); 

	if(p=getarg("ver",switches)) {
		printf("x-gw: %s\r\n", FWTK_VERSION_MINOR);
		goto out;
	}
	if(get_local_hostname(host)) goto out; 

		/* get switches */
	bzero(buf,256);
	if( !(dpy=getarg("disp",switches)) && 
	    !(dpy=getarg("from",switches)) &&
	    !(dpy=getenv("DISPLAY")) ) {      
		sprintf(buf,"%s:0.0",host ); 
    	} else {
		/* dpy=hostname/xxx.xx.xxx.xx:pp */
		sprintf(buf,"%s%s",(p=strchr(dpy,'/'))?&p[1]:dpy,
				   (!strchr(dpy,':'))?":0.0":"");
	}
	dpy=setarg("disp",buf,switches);
	len=strcspn(buf,":");
	buf[len]='\0';

		/* the display hostname */
	if( (pid=atoi(dpy+len+1)) < 0 || pid>(toport-BASE_PORT) ) {
		sprintf(buf,"Invalid display=%s. Must be 0-100\n",dpy+len+1); 
		pmsg(buf,0);
		goto out;
	}
	if( !XOpenDisplay(dpy) ) { /* check the display */
		fprintf( stderr,"Unable to open display=%s\r\n",dpy );
		goto out;
    	}

	/* read x-gw configuration */
	confp = cfg_read("x-gw");

	if((who=getarg("user",switches)) && (newport=read_cfg(who, confp))<0)
		goto out;

	/* lisen to an available port of the proxy */
	if(newport>0) port=newport+BASE_PORT;
	if( (lsd=serv_listen(NULL,AF_INET,NULL,&port,&toport)) < 0 )
		goto out;
	port-=BASE_PORT;
	/* check x-gw config port is in use */
	if(newport && newport != port) {
		sprintf(buf,"Display %d already in use for user %s.\r\n",
			newport,who);
		pmsg(buf,0);
		goto out;
	}

	/** init fwd destination sd **/
	if( saddr_init(buf,AF_INET,pid+BASE_PORT,&fwd) < 0 ) goto out;

	/* If using fixed port assignments don't bother telling them */
	if(!newport) {
		p=getarg("prompt",switches);
		if( p == NULL)
			p = "";
		sprintf(buf,"display port=%s:%d\r\n%s",host,port,p);
		pmsg(buf,0);
	}

	/* clean up to conserve descriptors. use syslog for error outputs */
	close(0); close(1);
#ifndef WEI_DBG
	close(2); uselog=1;
#endif
	/* setup is ok now and popup and display msgs on the control window */
	sprintf( buf,"started from %s by %s to display=%s\n",
		 getarg("from",switches),who,dpy);
	pmsg(buf,0);

#ifndef SCO5
	setenv("DISPLAY",dpy,1);
#endif
	sprintf(buf,
		"Display port is %s:%d\nClick the button to exit x-gw\0",
		 host,port);
	pid = childDialog( "x-gw",dpy,NULL,buf,NULL,0,"EXIT",OK,0 );

	idlemax=timeout=FALSE; /* default no idle/timeout */
	if( confp != (Cfg *)-1){
		Cfg	*cfp;

		if((cfp=cfg_get("idle-timeout",confp)) ||
		   (cfp=cfg_get("idle",confp)))
			idlemax = atoi(cfp->argv[0]);

		/* if timeout is set, all x-connection 
		 * will be shutdown in idlemax sec 
		 */
		if(cfp=cfg_get("timeout",confp)) {
			idlemax=(idlemax>0)?min(atoi(cfp->argv[0]),idlemax):
				atoi(cfp->argv[0]);
			timeout=TRUE;
		}
	}

	/** the main loop for x forward **/
	sigexit(control_exit);
	fwd_loop( lsd,		fwd, 
		  TIME_GRAIN,	idlemax, 
		  query_connect,dpy,
		  exit_xfwd_cb, NULL,
		  (void*)pid,	timeout);

	pmsg("x fwd_loop exits\n",0);

out:	fflush(stdout);
#ifndef WEI_DBG
	closelog();
#endif
	exit(0);
}
