/*
 * voorbeeldprogramma dat toont hoe m'n een bestand kan inlezen in CPP.
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>			/* Directory information.	*/
#include <string>
#include <iostream>
#include <fstream>


using namespace std;

int readDirectory(string bestandsNaam, string &buffer);
int readRegFile(string bestandsNaam, string &buffer);

int readFile(string bestandsNaam, string &buffer){
	/*bepaal welk soort bestand het is*/
	int gelezenBytes;
	struct stat statbuffer;
 	int res = stat(bestandsNaam.c_str(), &statbuffer);
   if(res<0){cerr<<"file error"<<endl; return -1;}

	if(S_ISREG(statbuffer.st_mode)){ 
		/* regular file */
		gelezenBytes = readRegFile(bestandsNaam, buffer);

	}
	else if (S_ISDIR(statbuffer.st_mode)){ 
		/* directory */
	   gelezenBytes = readDirectory(bestandsNaam, buffer);
	
	}   
	return gelezenBytes;
}

int readRegFile(string bestandsNaam, string &buffer){
   ifstream pFile(bestandsNaam.c_str());

   if (pFile==NULL) {cerr<<"File error\n"; return -1;}
   
   string s;
   getline(pFile, s);
   while(pFile.good()){
      buffer+=s;
      getline(pFile, s);
   }
   pFile.close();
  return buffer.length();
}


int readDirectory(string bestandsNaam, string &buffer){
   string newLineHtml = "<br>\n";
   int lSize=0;
    DIR           *dir_p;
    struct dirent *dir_entry_p;
    dir_p = opendir(bestandsNaam.c_str());
	 
	 dir_entry_p = readdir(dir_p);
    while( dir_entry_p != NULL){
      buffer+= dir_entry_p->d_name + newLineHtml;     
      dir_entry_p = readdir(dir_p);
    }
    closedir(dir_p);
    return buffer.length();

}

