/*
 * Decompiled with CFR 0.152.
 */
package be.hogent.iii.voetbal.datalaag.bo;

import be.hogent.iii.voetbal.datalaag.bo.Club;
import be.hogent.iii.voetbal.datalaag.bo.Match;
import be.hogent.iii.voetbal.datalaag.bo.Scheidsrechter;
import be.hogent.iii.voetbal.datalaag.bo.Stadion;
import be.hogent.iii.voetbal.datalaag.bo.Voetballer;
import be.hogent.iii.voetbal.datalaag.interfaces.IClub;
import be.hogent.iii.voetbal.datalaag.interfaces.IDataStorage;
import be.hogent.iii.voetbal.datalaag.interfaces.IDoelpunt;
import be.hogent.iii.voetbal.datalaag.interfaces.IKaart;
import be.hogent.iii.voetbal.datalaag.interfaces.IMatch;
import be.hogent.iii.voetbal.datalaag.interfaces.IPersoon;
import be.hogent.iii.voetbal.datalaag.interfaces.IScheidsrechter;
import be.hogent.iii.voetbal.datalaag.interfaces.IStadion;
import be.hogent.iii.voetbal.datalaag.interfaces.IVoetballer;
import be.hogent.iii.voetbal.datalaag.interfaces.IWissel;
import be.hogent.iii.voetbal.datalaag.interfaces.JDBCException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDataStorage
implements IDataStorage {
    private ResourceBundle constanten = ResourceBundle.getBundle("be.hogent.iii.voetbal.datalaag.bo.databankconstanten");

    public JDBCDataStorage() throws ClassNotFoundException {
        Class.forName(this.constanten.getString("driver"));
    }

    private Connection openConnectie() throws SQLException {
        return DriverManager.getConnection(this.constanten.getString("connectiestring"), this.constanten.getString("username"), this.constanten.getString("password"));
    }

    private IClub createClub(ResultSet rs) throws SQLException {
        return new Club(this, rs.getString(this.constanten.getString("kolom_id")), rs.getString(this.constanten.getString("kolom_naam")), rs.getString(this.constanten.getString("kolom_clubkleuren")), rs.getString(this.constanten.getString("kolom_logo")), rs.getString(this.constanten.getString("kolom_website")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IClub> getClubs() throws JDBCException {
        ArrayList<IClub> clubs = null;
        try {
            Connection conn = this.openConnectie();
            try {
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(this.constanten.getString("select_clubs"));
                    clubs = new ArrayList<IClub>();
                    while (rs.next()) {
                        clubs.add(this.createClub(rs));
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_clubs"));
        }
        return clubs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVoetballer getVoetballer(String id) throws JDBCException {
        IVoetballer voetballer = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_voetballer"));
                try {
                    stmt.setString(1, id);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        voetballer = this.createVoetballer(rs);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            throw new JDBCException(this.constanten.getString("fout_voetballer"));
        }
        return voetballer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMatch(IMatch match) {
        boolean resultaat = false;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("insert_match"));
                try {
                    stmt.setInt(1, match.getSpeeldag());
                    stmt.setString(2, match.getThuisploeg().getId());
                    stmt.setString(3, match.getUitploeg().getId());
                    stmt.setString(4, match.getScheidsrechter().getId());
                    stmt.setDate(5, new Date(match.getDatum().getTime()));
                    stmt.setTime(6, match.getTime());
                    stmt.setInt(7, match.getAantalToeschouwers());
                    stmt.executeUpdate();
                    resultaat = true;
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            resultaat = false;
        }
        return resultaat;
    }

    private IVoetballer createVoetballer(ResultSet rs) throws SQLException {
        return new Voetballer(this, rs.getString(this.constanten.getString("kolom_id")), rs.getString(this.constanten.getString("kolom_foto")), rs.getString(this.constanten.getString("kolom_naam")), rs.getString(this.constanten.getString("kolom_nationaliteit")), rs.getString(this.constanten.getString("kolom_positie")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IPersoon> getSpelers(String clubid) throws JDBCException {
        ArrayList<IPersoon> personen = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_spelers_per_club"));
                try {
                    stmt.setString(1, clubid);
                    ResultSet rs = stmt.executeQuery();
                    personen = new ArrayList<IPersoon>();
                    while (rs.next()) {
                        personen.add(this.createVoetballer(rs));
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_spelers_per_club"));
        }
        return personen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStadion getStadion(String id) throws JDBCException {
        Stadion stadion = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_stadion"));
                try {
                    stmt.setString(1, id);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        stadion = new Stadion(rs.getString(this.constanten.getString("kolom_naam")), rs.getInt(this.constanten.getString("kolom_capaciteit")), rs.getString(this.constanten.getString("kolom_straat")), rs.getInt(this.constanten.getString("kolom_nummer")), rs.getString(this.constanten.getString("kolom_gemeente")), rs.getInt(this.constanten.getString("kolom_postcode")));
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_stadion"));
        }
        return stadion;
    }

    private IScheidsrechter createScheidsrechter(ResultSet rs) throws SQLException {
        return new Scheidsrechter(rs.getString(this.constanten.getString("kolom_id")), rs.getString(this.constanten.getString("kolom_foto")), rs.getString(this.constanten.getString("kolom_naam")), rs.getString(this.constanten.getString("kolom_nationaliteit")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IScheidsrechter getScheidsrechter(int matchid) throws JDBCException {
        IScheidsrechter scheidsrechter = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_referee_match"));
                try {
                    stmt.setInt(1, matchid);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        scheidsrechter = this.createScheidsrechter(rs);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            throw new JDBCException(this.constanten.getString("fout_scheidsrechter"));
        }
        return scheidsrechter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IVoetballer> getVoetballerMatch(int matchid, String query) throws JDBCException {
        ArrayList<IVoetballer> personen = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(query);
                try {
                    stmt.setInt(1, matchid);
                    stmt.setInt(2, matchid);
                    ResultSet rs = stmt.executeQuery();
                    personen = new ArrayList<IVoetballer>();
                    while (rs.next()) {
                        personen.add(this.createVoetballer(rs));
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_spelers_per_match"));
        }
        return personen;
    }

    @Override
    public List<IVoetballer> getSpelersMatch(int matchid, String locatie) throws JDBCException {
        List<IVoetballer> resultaat = null;
        if (locatie.equals("thuis")) {
            resultaat = this.getVoetballerMatch(matchid, this.constanten.getString("select_thuisspelers_match"));
        } else if (locatie.equals("uit")) {
            resultaat = this.getVoetballerMatch(matchid, this.constanten.getString("select_uitspelers_match"));
        }
        return resultaat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClub getClubMatch(int matchid, String query) throws JDBCException {
        IClub club = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(query);
                try {
                    stmt.setInt(1, matchid);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        club = this.createClub(rs);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_club"));
        }
        return club;
    }

    @Override
    public IClub getPloegMatch(int matchid, String locatie) throws JDBCException {
        IClub resultaat = null;
        if (locatie.equals("thuis")) {
            resultaat = this.getClubMatch(matchid, this.constanten.getString("select_thuisclub_match"));
        } else if (locatie.equals("uit")) {
            resultaat = this.getClubMatch(matchid, this.constanten.getString("select_uitclub_match"));
        }
        return resultaat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, List<IClub>> getClubsSpeler(String spelerid) throws JDBCException {
        HashMap<Integer, List<IClub>> werkgevers = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_clubs_speler"));
                try {
                    stmt.setString(1, spelerid);
                    ResultSet rs = stmt.executeQuery();
                    werkgevers = new HashMap<Integer, List<IClub>>();
                    while (rs.next()) {
                        IClub club = this.createClub(rs);
                        int jaartal = rs.getInt(this.constanten.getString("kolom_jaartal"));
                        if (werkgevers.containsKey(jaartal)) {
                            ((List)werkgevers.get(jaartal)).add(club);
                            continue;
                        }
                        ArrayList<IClub> lijst = new ArrayList<IClub>();
                        lijst.add(club);
                        werkgevers.put(jaartal, lijst);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_clubs_speler"));
        }
        return werkgevers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClub getClub(String clubid) throws JDBCException {
        IClub club = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_club"));
                try {
                    stmt.setString(1, clubid);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        club = this.createClub(rs);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_club"));
        }
        return club;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMatch getMatch(int matchid) throws JDBCException {
        IMatch match = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_match"));
                try {
                    stmt.setInt(1, matchid);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        match = this.createMatch(rs);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            throw new JDBCException(this.constanten.getString("fout_match"));
        }
        return match;
    }

    private IMatch createMatch(ResultSet rs) throws SQLException {
        return new Match(this, rs.getInt(this.constanten.getString("kolom_id")), rs.getInt(this.constanten.getString("kolom_speeldag")), rs.getDate(this.constanten.getString("kolom_datum")), rs.getTime(this.constanten.getString("kolom_uur")), rs.getInt(this.constanten.getString("kolom_aantaltoeschouwers")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<Integer, List<IMatch>> getMatchen() throws JDBCException {
        HashMap<Integer, List<IMatch>> matchen = null;
        try {
            Connection conn = this.openConnectie();
            try {
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(this.constanten.getString("select_matchen"));
                    matchen = new HashMap<Integer, List<IMatch>>();
                    while (rs.next()) {
                        IMatch match = this.createMatch(rs);
                        if (matchen.containsKey(match.getSpeeldag())) {
                            matchen.get(match.getSpeeldag()).add(match);
                            continue;
                        }
                        ArrayList<IMatch> lijst = new ArrayList<IMatch>();
                        lijst.add(match);
                        matchen.put(match.getSpeeldag(), lijst);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_matchen"));
        }
        return matchen;
    }

    @Override
    public List<IKaart> getKaarten(int matchid) throws JDBCException {
        return null;
    }

    @Override
    public List<IDoelpunt> getDoelpunten(int matchid) throws JDBCException {
        return null;
    }

    @Override
    public List<IWissel> getWissels(int matchid) throws JDBCException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IScheidsrechter> getScheidsrechters() throws JDBCException {
        ArrayList<IScheidsrechter> scheidsrechters = null;
        try {
            Connection conn = this.openConnectie();
            try {
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(this.constanten.getString("select_scheidsrechters"));
                    scheidsrechters = new ArrayList<IScheidsrechter>();
                    while (rs.next()) {
                        scheidsrechters.add(this.createScheidsrechter(rs));
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new JDBCException(this.constanten.getString("fout_scheidsrechters"));
        }
        return scheidsrechters;
    }

    @Override
    public IMatch getLegeMatch() {
        return new Match();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IScheidsrechter getScheidsrechter(String scheidsrechterId) throws JDBCException {
        IScheidsrechter scheidsrechter = null;
        try {
            Connection conn = this.openConnectie();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.constanten.getString("select_scheidsrechter"));
                try {
                    stmt.setString(1, scheidsrechterId);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        scheidsrechter = this.createScheidsrechter(rs);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            throw new JDBCException(this.constanten.getString("fout_scheidsrechter"));
        }
        return scheidsrechter;
    }
}

