/*
 * Decompiled with CFR 0.152.
 */
package be.hogent.iii.voetbal.datalaag.bo;

import be.hogent.iii.voetbal.datalaag.interfaces.IClub;
import be.hogent.iii.voetbal.datalaag.interfaces.IDataStorage;
import be.hogent.iii.voetbal.datalaag.interfaces.IDoelpunt;
import be.hogent.iii.voetbal.datalaag.interfaces.IKaart;
import be.hogent.iii.voetbal.datalaag.interfaces.IMatch;
import be.hogent.iii.voetbal.datalaag.interfaces.IScheidsrechter;
import be.hogent.iii.voetbal.datalaag.interfaces.IVoetballer;
import be.hogent.iii.voetbal.datalaag.interfaces.IWissel;
import be.hogent.iii.voetbal.datalaag.interfaces.JDBCException;
import java.sql.Time;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Match
implements IMatch {
    private int id;
    private int speeldag;
    private Date datum;
    private Time uur;
    private int aantalToeschouwers;
    private IDataStorage datastorage;
    private IClub thuisploeg;
    private IClub uitploeg;
    private IScheidsrechter referee;

    public Match(IDataStorage datastorage, int id, int speeldag, Date datum, Time uur, int aantalToeschouwers) {
        this.id = id;
        this.speeldag = speeldag;
        this.datum = datum;
        this.uur = uur;
        this.aantalToeschouwers = aantalToeschouwers;
        try {
            this.datastorage = datastorage;
            this.uitploeg = datastorage.getPloegMatch(id, "uit");
            this.referee = datastorage.getScheidsrechter(id);
            this.thuisploeg = datastorage.getPloegMatch(id, "thuis");
        }
        catch (JDBCException ex) {
            Logger.getLogger(Match.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    Match() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getSpeeldag() {
        return this.speeldag;
    }

    @Override
    public IClub getThuisploeg() {
        return this.thuisploeg;
    }

    @Override
    public IClub getUitploeg() {
        return this.uitploeg;
    }

    @Override
    public IScheidsrechter getScheidsrechter() {
        return this.referee;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public Time getTime() {
        return this.uur;
    }

    @Override
    public int getAantalToeschouwers() {
        return this.aantalToeschouwers;
    }

    @Override
    public List<IVoetballer> getThuisPloegSpelers() {
        try {
            return this.datastorage.getSpelersMatch(this.id, "thuis");
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IVoetballer> getUitPloegSpelers() {
        try {
            return this.datastorage.getSpelersMatch(this.id, "uit");
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IKaart> getKaarten() {
        try {
            return this.datastorage.getKaarten(this.id);
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IDoelpunt> getDoelpunten() {
        try {
            return this.datastorage.getDoelpunten(this.id);
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IWissel> getWissels() {
        try {
            return this.datastorage.getWissels(this.id);
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public void setThuisploeg(IClub thuisploeg) {
        this.thuisploeg = thuisploeg;
    }

    @Override
    public void setUitploeg(IClub uitploeg) {
        this.uitploeg = uitploeg;
    }

    @Override
    public void setSpeeldag(int speeldag) {
        this.speeldag = speeldag;
    }

    @Override
    public void setScheidsrechter(IScheidsrechter scheidsrechter) {
        this.referee = scheidsrechter;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    @Override
    public void setTime(Time uur) {
        this.uur = uur;
    }

    @Override
    public void setAantalToeschouwers(int aantalToeschouwers) {
        this.aantalToeschouwers = aantalToeschouwers;
    }
}

