/*
 * Decompiled with CFR 0.152.
 */
package be.hogent.iii.voetbal.main;

import be.hogent.iii.voetbal.datalaag.interfaces.AbstractDataStorageFabriek;
import be.hogent.iii.voetbal.datalaag.interfaces.IClub;
import be.hogent.iii.voetbal.datalaag.interfaces.IDataStorage;
import be.hogent.iii.voetbal.datalaag.interfaces.IMatch;
import be.hogent.iii.voetbal.datalaag.interfaces.IPersoon;
import be.hogent.iii.voetbal.datalaag.interfaces.IScheidsrechter;
import be.hogent.iii.voetbal.datalaag.interfaces.IStadion;
import be.hogent.iii.voetbal.datalaag.interfaces.IVoetballer;
import java.util.List;
import java.util.Map;

public class TestMain {
    public static void main(String[] args) {
        try {
            IDataStorage data = AbstractDataStorageFabriek.newInstance("be.hogent.iii.voetbal.datalaag.bo.JDBCDataStorage");
            if (data != null) {
                System.out.println("data is niet null");
            } else {
                System.out.println("data is null");
            }
            for (IClub club : data.getClubs()) {
                System.out.println("Naam : " + club.getNaam());
                System.out.println("Id " + club.getId());
                System.out.println("Clubkleuren " + club.getClubkleuren());
                System.out.println("Logo " + club.getLogo());
                System.out.println("Website " + club.getWebsite());
            }
            IStadion stadion = data.getStadion("ROE");
            System.out.println("Stadion naam: " + stadion.getNaam());
            System.out.println("capaciteit " + stadion.getCapaciteit());
            System.out.println("straat " + stadion.getStraat());
            System.out.println("nummer " + stadion.getNummer());
            System.out.println("gemeente " + stadion.getGemeenteNaam());
            System.out.println("postcode " + stadion.getPostCode());
            IScheidsrechter scheids = data.getScheidsrechter(5);
            System.out.println("id " + scheids.getId());
            System.out.println("naam " + scheids.getNaam());
            System.out.println("foto " + scheids.getFoto());
            System.out.println("nationaliteit " + scheids.getNationaliteit());
            IClub club = data.getClub("ROE");
            System.out.println("Naam : " + club.getNaam());
            System.out.println("Id " + club.getId());
            System.out.println("Clubkleuren " + club.getClubkleuren());
            System.out.println("Logo " + club.getLogo());
            System.out.println("Website " + club.getWebsite());
            for (IPersoon persoon : club.getSpelers()) {
                System.out.println("id " + persoon.getId());
                System.out.println("naam " + persoon.getNaam());
                System.out.println("foto " + persoon.getFoto());
                System.out.println("nationaliteit " + persoon.getNationaliteit());
                System.out.println("positie" + ((IVoetballer)persoon).getPositie());
            }
            IVoetballer voetballer = data.getVoetballer("JELLEVOSSEN");
            System.out.println("id " + voetballer.getId());
            System.out.println("naam " + voetballer.getNaam());
            System.out.println("foto " + voetballer.getFoto());
            System.out.println("nationaliteit " + voetballer.getNationaliteit());
            System.out.println("positie" + voetballer.getPositie());
            club = data.getPloegMatch(1, "thuis");
            System.out.println("Naam : " + club.getNaam());
            System.out.println("Id " + club.getId());
            System.out.println("Clubkleuren " + club.getClubkleuren());
            System.out.println("Logo " + club.getLogo());
            System.out.println("Website " + club.getWebsite());
            club = data.getPloegMatch(1, "uit");
            System.out.println("Naam : " + club.getNaam());
            System.out.println("Id " + club.getId());
            System.out.println("Clubkleuren " + club.getClubkleuren());
            System.out.println("Logo " + club.getLogo());
            System.out.println("Website " + club.getWebsite());
            for (Map.Entry<Integer, List<IMatch>> m : data.getMatchen().entrySet()) {
                System.out.println("Speeldag: " + m.getKey());
                for (IMatch match : m.getValue()) {
                    System.out.println("Naam thuis" + match.getThuisploeg().getId());
                    System.out.println("Naam uit" + match.getUitploeg().getId());
                    System.out.println("Datum" + match.getDatum());
                    System.out.println("Uur" + match.getTime());
                    System.out.println("Aantal Toeschouwers: " + match.getAantalToeschouwers());
                }
            }
            System.out.println("\n\n");
            IMatch match = data.getMatch(1);
            System.out.println("Naam thuis" + match.getThuisploeg().getId());
            System.out.println("Naam uit" + match.getUitploeg().getId());
            System.out.println("Datum" + match.getDatum());
            System.out.println("Uur" + match.getTime());
            System.out.println("Aantal Toeschouwers: " + match.getAantalToeschouwers());
            System.out.println("\n\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

