/*
 * Decompiled with CFR 0.152.
 */
package be.hogent.iii.voetbal.datalaag.bo;

import be.hogent.iii.voetbal.datalaag.interfaces.IClub;
import be.hogent.iii.voetbal.datalaag.interfaces.IDataStorage;
import be.hogent.iii.voetbal.datalaag.interfaces.IDoelpunt;
import be.hogent.iii.voetbal.datalaag.interfaces.IKaart;
import be.hogent.iii.voetbal.datalaag.interfaces.IMatch;
import be.hogent.iii.voetbal.datalaag.interfaces.IScheidsrechter;
import be.hogent.iii.voetbal.datalaag.interfaces.IVoetballer;
import be.hogent.iii.voetbal.datalaag.interfaces.IWissel;
import be.hogent.iii.voetbal.datalaag.interfaces.JDBCException;
import java.sql.Time;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Match
implements IMatch {
    private int id;
    private int speeldag;
    private Date datum;
    private Time uur;
    private int aantalToeschouwers;
    private IDataStorage datastorage;

    public Match(IDataStorage datastorage, int id, int speeldag, Date datum, Time uur, int aantalToeschouwers) {
        this.id = id;
        this.speeldag = speeldag;
        this.datum = datum;
        this.uur = uur;
        this.aantalToeschouwers = aantalToeschouwers;
        this.datastorage = datastorage;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getSpeeldag() {
        return this.speeldag;
    }

    @Override
    public IClub getThuisploeg() {
        try {
            return this.datastorage.getPloegMatch(this.id, "thuis");
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public IClub getUitploeg() {
        try {
            return this.datastorage.getPloegMatch(this.id, "uit");
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public IScheidsrechter getScheidsrechter() {
        try {
            return this.datastorage.getScheidsrechter(this.id);
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public Time getTime() {
        return this.uur;
    }

    @Override
    public int getAantalToeschouwers() {
        return this.aantalToeschouwers;
    }

    @Override
    public List<IVoetballer> getThuisPloegSpelers() {
        try {
            return this.datastorage.getSpelersMatch(this.id, "thuis");
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IVoetballer> getUitPloegSpelers() {
        try {
            return this.datastorage.getSpelersMatch(this.id, "uit");
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IKaart> getKaarten() {
        try {
            return this.datastorage.getKaarten(this.id);
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IDoelpunt> getDoelpunten() {
        try {
            return this.datastorage.getDoelpunten(this.id);
        }
        catch (JDBCException ex) {
            return null;
        }
    }

    @Override
    public List<IWissel> getWissels() {
        try {
            return this.datastorage.getWissels(this.id);
        }
        catch (JDBCException ex) {
            return null;
        }
    }
}

