﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Configuration;
using VoetbalInterface;

namespace VoetbalDataLaag
{
    public class VoetbalInfoImpl : MarshalByRefObject, VoetbalInfo
    {
        DbProviderFactory fabriek;
        string connString;

        public VoetbalInfoImpl() 
        {
            Console.WriteLine("start constructor");
            ConnectionStringSettings connSets = ConfigurationManager.ConnectionStrings["voetbalDB"];
            Console.WriteLine("configuratie opgehaald");
            Console.WriteLine(connSets);
            fabriek = DbProviderFactories.GetFactory(connSets.ProviderName);
            Console.WriteLine("fabriek aangemaakt");
            connString = connSets.ConnectionString;
            Console.WriteLine("einde constructor");
        }

        public DataTable Wedstrijden {
            get
            {
                DbConnection conn = fabriek.CreateConnection();
                conn.ConnectionString = connString;
                DbCommand opdracht = fabriek.CreateCommand();
                opdracht.Connection = conn;
                opdracht.CommandText = ConfigurationManager.AppSettings["SELECT_WEDSTRIJDEN"];
                DbDataAdapter adapter = fabriek.CreateDataAdapter();
                adapter.SelectCommand = opdracht;
                DataTable wedstrijden = new DataTable();
                adapter.Fill(wedstrijden);
                return wedstrijden;
            }
        }

        public DataTable SpelersPerPloeg(string ploeg)
        {
            DbConnection conn = fabriek.CreateConnection();
            conn.ConnectionString = connString;
            DbCommand opdracht = fabriek.CreateCommand();
            opdracht.Connection = conn;
            opdracht.CommandText = ConfigurationManager.AppSettings["SELECT_SPELERS_PLOEG"];
            DbParameter paramPloeg = fabriek.CreateParameter();
            paramPloeg.ParameterName = "@ploeg";
            paramPloeg.Value = ploeg;
            opdracht.Parameters.Add(paramPloeg);
            DbDataAdapter adapter = fabriek.CreateDataAdapter();
            adapter.SelectCommand = opdracht;
            DataTable spelers = new DataTable();
            adapter.Fill(spelers);
            return spelers;
        }
    }
}
